/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.batik.bridge.FontFamilyResolver;
import org.apache.batik.bridge.GlyphLayout;
import org.apache.batik.bridge.SVGGVTFont;
import org.apache.batik.bridge.StrokingTextPainter;
import org.apache.batik.bridge.TextLayoutFactory;
import org.apache.batik.bridge.TextNode;
import org.apache.batik.bridge.TextSpanLayout;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.svg.font.FOPFontFamilyResolverImpl;
import org.apache.fop.svg.font.FOPGVTFont;
import org.apache.fop.svg.font.FOPGVTGlyphVector;
import org.apache.fop.svg.text.BidiAttributedCharacterIterator;
import org.apache.fop.util.CharUtilities;

public abstract class NativeTextPainter
extends StrokingTextPainter {
    protected static final Log log = LogFactory.getLog(NativeTextPainter.class);
    protected final FontInfo fontInfo;
    protected final FontFamilyResolver fontFamilyResolver;
    protected Font font;
    protected TextPaintInfo tpi;
    private static final TextLayoutFactory COMPLEX_SCRIPT_TEXT_LAYOUT_FACTORY = new TextLayoutFactory(){

        public TextSpanLayout createTextLayout(AttributedCharacterIterator aci, int[] charMap, Point2D offset, FontRenderContext frc) {
            return new GlyphLayout(aci, charMap, offset, frc);
        }
    };

    public NativeTextPainter(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
        this.fontFamilyResolver = new FOPFontFamilyResolverImpl(fontInfo);
    }

    protected abstract boolean isSupported(Graphics2D var1);

    protected final void paintTextRun(StrokingTextPainter.TextRun textRun, Graphics2D g2d) throws IOException {
        TextSpanLayout layout;
        GVTGlyphVector gv;
        this.logTextRun(textRun);
        AttributedCharacterIterator runaci = textRun.getACI();
        runaci.first();
        this.tpi = (TextPaintInfo)runaci.getAttribute(PAINT_INFO);
        if (this.tpi == null || !this.tpi.visible) {
            return;
        }
        if (this.tpi.composite != null) {
            g2d.setComposite(this.tpi.composite);
        }
        if (!((gv = (layout = textRun.getLayout()).getGlyphVector()).getFont() instanceof FOPGVTFont)) {
            assert (gv.getFont() == null || gv.getFont() instanceof SVGGVTFont);
            textRun.getLayout().draw(g2d);
            return;
        }
        GeneralPath debugShapes = log.isDebugEnabled() ? new GeneralPath() : null;
        this.preparePainting(g2d);
        this.saveGraphicsState();
        this.setInitialTransform(g2d.getTransform());
        this.clip(g2d.getClip());
        this.beginTextObject();
        this.writeGlyphs((FOPGVTGlyphVector)gv, debugShapes);
        this.endTextObject();
        this.restoreGraphicsState();
        if (debugShapes != null) {
            g2d.setStroke(new BasicStroke(0.0f));
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.draw(debugShapes);
        }
    }

    protected void writeGlyphs(FOPGVTGlyphVector gv, GeneralPath debugShapes) throws IOException {
        AffineTransform localTransform = new AffineTransform();
        Point2D prevPos = null;
        AffineTransform prevGlyphTransform = null;
        this.font = ((FOPGVTFont)gv.getFont()).getFont();
        int index = 0;
        int c = gv.getNumGlyphs();
        while (index < c) {
            if (gv.isGlyphVisible(index)) {
                Point2D glyphPos = gv.getGlyphPosition(index);
                AffineTransform glyphTransform = gv.getGlyphTransform(index);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("pos " + glyphPos + ", transform " + glyphTransform));
                }
                if (debugShapes != null) {
                    Shape sh = gv.getGlyphLogicalBounds(index);
                    if (sh == null) {
                        sh = new Ellipse2D.Double(glyphPos.getX(), glyphPos.getY(), 2.0, 2.0);
                    }
                    debugShapes.append(sh, false);
                }
                localTransform.setToIdentity();
                localTransform.translate(glyphPos.getX(), glyphPos.getY());
                if (glyphTransform != null) {
                    localTransform.concatenate(glyphTransform);
                }
                localTransform.scale(1.0, -1.0);
                this.positionGlyph(prevPos, glyphPos, glyphTransform != null || prevGlyphTransform != null);
                char glyph = (char)gv.getGlyphCode(index);
                prevPos = glyphPos;
                prevGlyphTransform = glyphTransform;
                this.writeGlyph(glyph, localTransform);
            }
            ++index;
        }
    }

    protected void paintTextRuns(List textRuns, Graphics2D g2d) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("paintTextRuns: count = " + textRuns.size()));
        }
        if (!this.isSupported(g2d)) {
            super.paintTextRuns(textRuns, g2d);
            return;
        }
        int i = 0;
        while (i < textRuns.size()) {
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)textRuns.get(i);
            try {
                this.paintTextRun(textRun, g2d);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ++i;
        }
    }

    protected CharSequence collectCharacters(AttributedCharacterIterator runaci) {
        StringBuffer chars = new StringBuffer();
        runaci.first();
        while (runaci.getIndex() < runaci.getEndIndex()) {
            chars.append(runaci.current());
            runaci.next();
        }
        return chars;
    }

    public List computeTextRuns(TextNode node, AttributedCharacterIterator nodeACI, AttributedCharacterIterator[] chunkACIs) {
        nodeACI.first();
        int defaultBidiLevel = ((Integer)nodeACI.getAttribute(WRITING_MODE)).intValue() == WRITING_MODE_RTL.intValue() ? 1 : 0;
        int i = 0;
        int n = chunkACIs.length;
        while (i < n) {
            chunkACIs[i] = new BidiAttributedCharacterIterator(chunkACIs[i], defaultBidiLevel);
            ++i;
        }
        return super.computeTextRuns(node, nodeACI, chunkACIs, null);
    }

    protected Set getTextRunBoundaryAttributes() {
        Set textRunBoundaryAttributes = super.getTextRunBoundaryAttributes();
        if (!textRunBoundaryAttributes.contains(BIDI_LEVEL)) {
            textRunBoundaryAttributes.add(BIDI_LEVEL);
        }
        return textRunBoundaryAttributes;
    }

    protected List reorderTextRuns(StrokingTextPainter.TextChunk chunk, List runs) {
        int mn = -1;
        int mx = -1;
        for (StrokingTextPainter.TextRun r : runs) {
            int level = r.getBidiLevel();
            if (level < 0) continue;
            if (mn < 0 || level < mn) {
                mn = level;
            }
            if (mx >= 0 && level <= mx) continue;
            mx = level;
        }
        if (mx > 0) {
            int l1 = mx;
            int l2 = (mn & 1) == 0 ? mn + 1 : mn;
            while (l1 >= l2) {
                runs = this.reorderRuns(runs, l1);
                --l1;
            }
        }
        boolean mirror = true;
        this.reverseGlyphs(runs, mirror);
        return runs;
    }

    private List reorderRuns(List runs, int level) {
        assert (level >= 0);
        ArrayList<StrokingTextPainter.TextRun> runsNew = new ArrayList<StrokingTextPainter.TextRun>();
        int i = 0;
        int n = runs.size();
        while (i < n) {
            StrokingTextPainter.TextRun tri = (StrokingTextPainter.TextRun)runs.get(i);
            if (tri.getBidiLevel() < level) {
                runsNew.add(tri);
            } else {
                int s;
                int e = s = i;
                while (e < n) {
                    StrokingTextPainter.TextRun tre = (StrokingTextPainter.TextRun)runs.get(e);
                    if (tre.getBidiLevel() < level) break;
                    ++e;
                }
                if (s < e) {
                    runsNew.addAll(this.reverseRuns(runs, s, e));
                }
                i = e - 1;
            }
            ++i;
        }
        if (!runsNew.equals(runs)) {
            runs = runsNew;
        }
        return runs;
    }

    private List reverseRuns(List runs, int s, int e) {
        int n = e - s;
        ArrayList<StrokingTextPainter.TextRun> runsNew = new ArrayList<StrokingTextPainter.TextRun>(n);
        if (n > 0) {
            int i = 0;
            while (i < n) {
                int k = n - i - 1;
                StrokingTextPainter.TextRun tr = (StrokingTextPainter.TextRun)runs.get(s + k);
                tr.reverse();
                runsNew.add(tr);
                ++i;
            }
        }
        return runsNew;
    }

    private void reverseGlyphs(List runs, boolean mirror) {
        for (StrokingTextPainter.TextRun r : runs) {
            r.maybeReverseGlyphs(mirror);
        }
    }

    protected abstract void preparePainting(Graphics2D var1);

    protected abstract void saveGraphicsState() throws IOException;

    protected abstract void restoreGraphicsState() throws IOException;

    protected abstract void setInitialTransform(AffineTransform var1) throws IOException;

    protected abstract void clip(Shape var1) throws IOException;

    protected abstract void beginTextObject() throws IOException;

    protected abstract void endTextObject() throws IOException;

    protected abstract void positionGlyph(Point2D var1, Point2D var2, boolean var3);

    protected abstract void writeGlyph(char var1, AffineTransform var2) throws IOException;

    protected final void logTextRun(StrokingTextPainter.TextRun textRun) {
        AttributedCharacterIterator runaci = textRun.getACI();
        TextSpanLayout layout = textRun.getLayout();
        runaci.first();
        if (log.isTraceEnabled()) {
            int charCount = runaci.getEndIndex() - runaci.getBeginIndex();
            log.trace((Object)"================================================");
            log.trace((Object)"New text run:");
            log.trace((Object)("char count: " + charCount));
            log.trace((Object)("range: " + runaci.getBeginIndex() + " - " + runaci.getEndIndex()));
            log.trace((Object)("glyph count: " + layout.getGlyphCount()));
        }
    }

    protected final void logCharacter(char ch, TextSpanLayout layout, int index, boolean visibleChar) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("glyph " + index + " -> " + layout.getGlyphIndex(index) + " => " + ch));
            if (CharUtilities.isAnySpace((int)ch) && ch != ' ') {
                log.trace((Object)("Space found: " + Integer.toHexString(ch)));
            } else if (ch == '\u200d') {
                log.trace((Object)("ZWJ found: " + Integer.toHexString(ch)));
            } else if (ch == '\u00ad') {
                log.trace((Object)("Soft hyphen found: " + Integer.toHexString(ch)));
            }
            if (!visibleChar) {
                log.trace((Object)("Invisible glyph found: " + Integer.toHexString(ch)));
            }
        }
    }

    protected FontFamilyResolver getFontFamilyResolver() {
        return this.fontFamilyResolver;
    }

    protected TextLayoutFactory getTextLayoutFactory() {
        return COMPLEX_SCRIPT_TEXT_LAYOUT_FACTORY;
    }
}

