# Oxygen XLIFF Plugin

A standalone Swing UI application for managing translation tasks using the oxygen-xliff-translator framework.

## Overview

This module provides a modern graphical user interface for the Oxygen XLIFF Translation Tool. It allows users to create, monitor, and control translation jobs through an intuitive desktop application built with Java Swing.

## Features

### Translation Task Management
- **Create New Tasks**: Dialog-based task creation with support for:
  - Task name and description
  - Product information
  - XLIFF file selection
  - Optional translation memory files
- **Task Monitoring**: Real-time display of:
  - Task status (Created, Running, Stopped, Completed, Failed, Queued)
  - Progress information with current phase
  - Progress bars showing completion percentage
  - Translation units completed vs total
- **Task Control**: Actions available via toolbar:
  - Start/Resume translation tasks
  - Stop running tasks
  - Delete tasks (with confirmation)

### User Interface
- **Main Panel**: Split layout with toolbar and tasks display
- **Translation Tasks Panel**: Scrollable list of task cards showing detailed status
- **Toolbar**: Action buttons for task management
- **Modern UI**: System look-and-feel with intuitive design

### Background Processing
- **Threading**: All translation operations run in background using SwingWorker
- **Progress Monitoring**: Real-time UI updates via TranslationMonitor implementation
- **Task Manager**: Coordinates between UI and translation system
- **Periodic Refresh**: Automatic UI updates every 2 seconds

## Architecture

### Core Components

#### Application Layer
- `TranslationToolApplication`: Main application class and entry point
- `MainTranslationPanel`: Root UI panel coordinating all components

#### UI Components
- `TranslationTasksPanel`: Displays translation tasks as cards
- `TranslationToolbar`: Action buttons for task management
- `NewTranslationTaskDialog`: Dialog for creating new translation tasks

#### Management Layer
- `TranslationTaskManager`: Coordinates background operations and monitoring
- `UITranslationMonitor`: Updates UI based on translation progress events

### Dependencies
- **oxygen-xliff-translator**: Core translation API and job management
- **Java Swing**: UI framework
- **Lombok**: Code generation and boilerplate reduction
- **SLF4J + Logback**: Logging framework

## Building and Running

### Prerequisites
- Java 17 or later
- Maven 3.6 or later
- Access to oxygen-xliff-translator module

### Build
```bash
cd oxygen-xliff-plugin
mvn clean compile
```

### Package
```bash
mvn clean package
```
This creates an executable JAR with all dependencies in the `target/` directory.

### Run
```bash
# Run directly with Maven
mvn exec:java -Dexec.mainClass="com.oxygenxml.translator.plugin.ui.TranslationToolApplication"

# Or run the packaged JAR
java -jar target/oxygen-xliff-plugin-1.0-SNAPSHOT.jar
```

## Configuration

### Translation System
The application initializes the AI translator system with default configuration:
- Maximum parallel jobs: 3
- Translation directory: "translation-data"
- Persistence interval: 30 seconds
- Auto-restore jobs: enabled

### Logging
Logging is configured via `src/main/resources/logback.xml`:
- Console output for development
- Rolling file logs in `logs/` directory
- DEBUG level for application packages
- INFO level for root logger

## Usage

### Creating a New Translation Task
1. Click "New Task" in the toolbar
2. Fill in the required information:
   - Task name (required)
   - Product name (required)
   - Select XLIFF file (required)
   - Optionally add description and memory file
3. Click OK to create the task
4. Choose whether to start the task immediately

### Managing Tasks
- **Start/Resume**: Click "Resume Task" to start or resume a stopped task
- **Stop**: Click "Stop Task" to pause a running task
- **Delete**: Click "Delete Task" to remove a task (with confirmation)

### Monitoring Progress
- Task cards show real-time status and progress
- Progress bars indicate completion percentage
- Current phase information (Starting, Splitting, Translating, Merging)
- Translation units count (completed/total)

## Thread Safety

The application is designed with thread safety in mind:
- UI updates are performed on the Event Dispatch Thread
- Background operations use SwingWorker
- Translation system access is coordinated through the task manager
- Concurrent collections are used for thread-safe state management

## Error Handling

- Comprehensive exception handling with user-friendly error dialogs
- Logging of all errors and important events
- Graceful degradation when translation system is unavailable
- Input validation in dialogs and forms

## Extensibility

The modular design allows for easy extension:
- New UI components can be added to the main panel
- Additional task actions can be integrated into the toolbar
- Custom monitors can be implemented for specialized tracking
- The task manager can be extended for additional background operations