# Oxygen AI Positron VERTEX AI Connector

This add-on allows you to connect the Oxygen AI Positron plugin with Vertex AI

## Compatibility

The add-on is compatible with Oxygen XML Editor/Author/Developer and WebAuthor version 27.1 or newer. 

## How to install

1. Go to **Help->Install new add-ons** to open an add-on selection dialog box.
2. Enter or paste https://www.oxygenxml.com/InstData/Addons/default/updateSite.xml in the **Show add-ons from** field.
3. Select the **Oxygen AI Positron Vertex AI Connector** add-on and click **Next**.
4. Read the end-user license agreement. Then select the **I accept all terms of the end-user license agreement** option and click **Finish**.
5. Restart the application. 

Result: The **Vertex AI** will be available into the AI Connector combo menu from the "Plugins / Oxygen AI Positron / AI Service Configuration" preferences page of the Oxygen AI Positron add-on.

The add-on can also be installed using the following alternative installation procedure:
1. Go to the [Releases page](https://www.oxygenxml.com/InstData/Addons/default/com/oxygenxml/oxygen-ai-positron-vertex-ai-connector-addon/) and download the `oxygen-ai-positron-vertex-ai-connector-addon-{version}-plugin.jar` file.
2. Unzip it inside `{oXygenInstallDir}/plugins`. Make sure you don't create any intermediate folders. After unzipping the archive, the file system should look like this: `{oXygenInstallDir}/plugins/oxygen-ai-positron-vertex-ai-connector-addon-x.y.z`, and inside this folder, there should be a `plugin.xml`file.


### How to configure the Vertex AI Service connector

When the **Vertex AI Service** is selected from Vertex AI Service will be available in the *AI Connector* combo box in the *Plugins* > *Oxygen AI Positron* > *AI Service Configuration* preferences page, the following options are available to configure the connector:

- **Project ID**  
  The ID of your Google Cloud project.

- **Location**  
  The location of your Google Cloud project (e.g., `us-central1`).

- **Model**  
  The AI model to use (e.g., `google/gemini-2.5-flash`).

- **Credential**  
  The content of the Google credential JSON file (service account key file for authentication).

  If this field is left empty, the application will use **Google Cloud’s Application Default Credentials** ([documentation](https://cloud.google.com/docs/authentication/application-default-credentials)), searching for credentials in the following locations:
  - `GOOGLE_APPLICATION_CREDENTIALS` environment variable
  - The attached service account


Copyright and License
---------------------
Copyright 2025 Syncro Soft SRL.
