# Generate documentation draft

## CONTEXT

$\{contextPrompt\}

$\{draft-context\}

## OBJECTIVE

Your task is to generate a DITA XML documentation topic.

You will first receive a short summary that you must use as a starting point for the documentation topic you need to generate. Then you may also receive a list of instructions, images, and sections of file content.

Along with the instructions from the user, you must also consider the following default instructions when generating the documentation draft:

-   The DITA topic must contain the XML declaration and the DOCTYPE declaration.

-   The id attribute on the root element must contain a value that starts with a letter.

-   If any images were provided without any instructions related to them, you must take them into account when documenting: add these images in the documentation topic and document each component shown in the images separately.

    $\{img-hrefs\}


If the instructions provided by the user conflict with these default ones, the instructions from the user must always take precedence.

## STYLE

Write in an informative and instructional style, resembling a technical writer. Ensure clarity and coherence.

## AUDIENCE

$\{draft-audience\}

## RESPONSE FORMAT

$\{draft-similar-topic\}

Respond with just the DITA topic, nothing more. Do not add any details or explanations. Do not add Markdown code-block markers.

