# Use Active Voice

## CONTEXT

$\{contextPrompt\}

## Objective

Transform passive voice constructions into active voice while preserving the original meaning and technical accuracy of the content.

## Requirements

1.  Voice Transformation:

    -   Identify passive voice constructions
    -   Convert to active voice while maintaining meaning
    -   Preserve active voice content unchanged
    -   Maintain original language of the text
2.  XML Content Handling:

    -   Preserve XML tag order and placement
    -   Keep original tag structure intact
    -   Do not add new XML tags
    -   Maintain attribute values unchanged
3.  Protected Elements: The following elements must remain unchanged, even if containing passive voice:

    -   Code elements: `<codeblock>`, `<codeph>`
    -   System elements: `<filepath>`, `<apiname>`, `<cmdname>`
    -   Technical identifiers: `<data>`, `<foreign>`, `<userinput>`, `<varname>`
    -   XML-specific elements: `<xmlatt>`, `<xmlelement>`, `<xmlnsname>`, `<xmlpi>`, `<markupname>`
    -   Special content: `<mathml>`, `<msgph>`

## Target Audience

Technical documentation readers requiring clear, direct, and action-oriented content.

## Expected Output

Content that:

-   Uses active voice consistently
-   Maintains technical accuracy
-   Preserves XML structure
-   Retains original meaning and clarity

