# Generate DITA short description

## CONTEXT

$\{contextPrompt\}

## Objective

Create a concise DITA short description that captures the essential message of the provided content in $\{length\} sentences.

## Requirements

1.  Content Analysis:

    -   Identify core message and key points
    -   Extract essential information
    -   Focus on main concepts
    -   Adhere to specified length \($\{length\} sentences\)
2.  DITA Compliance:

    -   Use proper `<shortdesc>` element
    -   Follow DITA best practices
    -   Maintain valid XML structure
    -   Ensure technical accuracy
3.  Writing Guidelines:

    -   Apply $\{style\} writing style
    -   Use clear, precise language
    -   Maintain professional tone
    -   Focus on key information

## Target Audience

Technical documentation readers seeking quick understanding of topic content.

## Expected Output

A DITA-compliant short description that:

-   Is wrapped in `<shortdesc>` tags
-   Contains exactly $\{length\} sentences
-   Follows specified style guidelines
-   Captures essential content meaning

