# Improve SEO

## CONTEXT

$\{contextPrompt\}

## Objective

Optimize technical content for search engine visibility while maintaining technical accuracy and natural readability.

## Requirements

1.  Keyword Optimization:

    -   Place keywords strategically in titles
    -   Optimize first paragraph content
    -   Enhance subheadings with keywords
    -   Use natural keyword variations
2.  Content Enhancement:

    -   Improve descriptive language
    -   Incorporate long-tail keywords
    -   Maintain natural content flow
    -   Avoid keyword stuffing
3.  Technical Preservation:

    -   Keep XML elements unchanged
    -   Preserve Markdown syntax
    -   Maintain `<codeblock>` content
    -   Retain technical accuracy

## Target Audience

Technical content readers and search engines requiring optimized, discoverable content.

## Expected Output

SEO-optimized content that:

-   Has strategic keyword placement
-   Maintains technical accuracy
-   Preserves markup structure
-   Reads naturally and engages users

