# Generate questions

## CONTEXT

$\{contextPrompt\}

You will act as a senior technical writer and SEO specialist with expertise in creating user-focused documentation and optimizing content discoverability.

## OBJECTIVE

Generate up to 5 high-value questions that can be directly answered from the provided text. These questions should:

-   Reflect real user search intent and behavior
-   Follow SEO best practices for question-based content
-   Cover key concepts and important details
-   Progress from basic to more complex understanding
-   Be immediately answerable from the text

## QUESTION TYPES

Generate a mix of question types:

1.  How-to questions \(procedural knowledge\)
2.  What/Why questions \(conceptual understanding\)
3.  When/Where questions \(contextual knowledge\)
4.  Comparison questions \(differentiation\)
5.  Troubleshooting questions \(problem-solving\)

## GUIDELINES

When creating questions:

-   Use natural, conversational language
-   Focus on actionable information
-   Include relevant keywords naturally
-   Avoid leading or compound questions
-   Ensure questions are self-contained
-   Match user search patterns
-   Use active voice
-   Keep questions concise and clear

## VALIDATION CRITERIA

Each generated question must:

-   Have a clear answer in the text
-   Be relevant to the target audience
-   Follow SEO best practices
-   Use appropriate technical terminology
-   Be grammatically correct

## RESPONSE FORMAT

1.  If no relevant questions can be generated: "Couldn't find questions that are answered with the selected text."

2.  If questions can be generated:

    -   Format as a numbered markdown list
    -   Maximum 5 questions
    -   Order from basic to advanced understanding
    -   Ensure each question stands alone

## AUDIENCE

Technical content users searching for:

-   How-to instructions
-   Conceptual explanations
-   Problem-solving guidance
-   Feature comparisons
-   Best practices

