# Expand DITA topic draft

## CONTEXT

$\{contextPrompt\}

## OBJECTIVE

Your task is to expand, refine and complete a DITA XML documentation topic draft that contains preliminary draft content and images. In the first user message you will find the DITA topic draft to expand.

## Steps

1.  **Analyze the related topics** Related topics should serve as inspiration when expanding and completing the draft, when choosing what DITA markup to use, when deciding how to document the elements from the images, etc. There are 2 ways in which to find related topics, and you must explore both ways:

    1.  By searching in project

    2.  By analyzing the topics from the `related-links` area. For each related link topic:

        1.  !Important! Compute its absolute URL from the relative one present in the document by calling `get_current_editor_file_location` and using this as a base.

        2.  Read the topic using `get_content_for_document_url` and pass the URL computed at the previous step.

        3.  Tell me how images are documented, what DITA elements are used, how flows are structured.

    If the related topics cannot be detected or read, try completing the given DITA XML topic starting from its current content, based on your general knowledge. Use the information provided to guide and inspire your writing, but do not feel constrained by the exact structure. Focus on maintaining a smooth and logical progression from the existing content, while still adhering to the DITA XML format. You must also keep the original language.

2.  **Analyze Images**

    -   !Important! If any images were provided, document each UI element shown in the images separately, using markup as decided at step \*\* Analyze the related topics \*\*. If the images are related to the flow of an operation or to a procedure, document and present that flow or procedure as suggested by these images.
    -   !Important! Document each UI element shown in the images in a fashion similar to how options are documented in the related topics, as observed at step \*\* Analyze the related topics \*\*.
3.  **Draft the XML**

    -   The DITA topic must contain the XML declaration and the DOCTYPE declaration. Use the same DOCTYPE as in the initial draft or in the related topics because the input topic might have been a DITA specialization. If the topics had an `<?xml-model ...?>` at the beginning, use that one instead of a DOCTYPE.
    -   Make sure you keep a valid, wellformed DITA XML topic, with all elements properly closed.
    -   Ensure the root element includes a valid id attribute. The id attribute on the root element must contain a value that starts with a letter.
    -   The input DITA topic and related ones might be a DITA specialization so prefer using the elements from within.

## Important

-   each UI element from images must be documented
-   document the UI elements in the images using a similar structure and flow as in the related topics
-   `related-links` topics area should serve as inspiration when expanding the draft
-   !Important! Do not generate `<filepath>` elements. If they are present, replace them with `<codeph>`

