/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.util;

import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.auth.BrowserOpener;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.ui.LinkLabel;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.PlatformUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.LFDetector;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.Button;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.ToolbarButton;
import ro.sync.ui.theme.SAThemeColorProvider;

public class UIUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)UIUtil.class.getName());
    public static final String AI_POSITRON_LABEL = "AI Positron";
    private static final char MAC_META_SYMBOL = '\u2318';
    private static final char SHIFT_SYMBOL = '\u21e7';
    private static final char ALT_SYMBOL = '\u2325';
    private static final char CTRL_SYMBOL = '\u2303';
    public static final int INTERNAL_PADDING = 2;
    public static final int MIN_SPACING = 3;
    public static final int SPACING = 5;
    public static final int SUBORDINATE_SPACING = 5;
    public static final int UNRELATED_COMPONENTS_SPACING = 7;
    private static JButton auxBtn = null;

    private UIUtil() {
    }

    public static JComponent createWrappedMessage(String text) {
        JTextComponent area = UIUtil.createTransparentTextArea(true);
        area.setText(text);
        JScrollPane scPane = OxygenUIComponentsFactory.createScrollPane((Component)area, (int)20, (int)30);
        scPane.setBorder(BorderFactory.createEmptyBorder());
        scPane.setOpaque(false);
        return scPane;
    }

    public static JTextComponent createTransparentTextArea(boolean wrap) {
        JTextArea area = new JTextArea();
        area.setBorder(BorderFactory.createEmptyBorder());
        area.setEditable(false);
        area.setCaretPosition(0);
        area.setOpaque(false);
        area.setEditable(false);
        if (wrap) {
            area.setLineWrap(true);
            area.setWrapStyleWord(true);
        }
        return area;
    }

    public static Insets getSpacingInsets() {
        return new Insets(5, 5, 5, 5);
    }

    public static Insets getNoInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public static Insets getSlimInsetsTop() {
        return new Insets(2, 0, 0, 0);
    }

    public static Insets getSpacingInsetsNoTop() {
        return new Insets(0, 5, 5, 5);
    }

    public static Insets getSpacingInsetsNoBottom() {
        return new Insets(5, 5, 0, 5);
    }

    public static int getSpacing() {
        return 5;
    }

    public static JLabel createLinkLabel(final String uri, String labelName) {
        return new LinkLabel(labelName){

            @Override
            public void performAction() {
                new BrowserOpener().openWebpage(uri);
            }
        };
    }

    public static int calculateMaxButtonPreferredWidth(List<PositronAIActionBase> actions, Insets buttonMargins) {
        if (!SwingUtilities.isEventDispatchThread()) {
            logger.warn("This method must be called from the AWT thread!");
        }
        int maxWidth = 0;
        if (auxBtn == null) {
            auxBtn = new Button();
            if (PlatformUtils.isMacOS()) {
                int macOSBorderLimit = 12;
                Border originalBorder = auxBtn.getBorder();
                if (originalBorder.getBorderInsets((Component)UIUtil.auxBtn).right > macOSBorderLimit) {
                    auxBtn.setBorder(BorderFactory.createEmptyBorder(0, macOSBorderLimit, 0, macOSBorderLimit));
                }
            }
        }
        for (PositronAIActionBase action : actions) {
            auxBtn.setText(action.getActionDetails().getTitle());
            auxBtn.setMargin(buttonMargins);
            Dimension preferredSize = auxBtn.getPreferredSize();
            if (preferredSize == null || preferredSize.width <= maxWidth) continue;
            maxWidth = preferredSize.width;
        }
        return maxWidth;
    }

    public static String getMacOSKeyModifiersSymbol(int modifiers) {
        StringBuilder result = new StringBuilder();
        if ((modifiers & 0x80) != 0) {
            result.append("\u2303 ");
        }
        if ((modifiers & 0x200) != 0) {
            result.append("\u2325 ");
        }
        if ((modifiers & 0x40) != 0) {
            result.append("\u21e7 ");
        }
        if ((modifiers & 0x100) != 0) {
            result.append("\u2318 ");
        }
        return result.toString();
    }

    public static void drawMultiLinePlaceholder(JTextComponent textComp, Graphics g, String placeholderMessage) {
        Graphics2D graphics = (Graphics2D)g;
        int[] inactiveTextColorVals = new SAThemeColorProvider().getInactiveTextColor();
        Color inactiveTextColor = new Color(inactiveTextColorVals[0], inactiveTextColorVals[1], inactiveTextColorVals[2]);
        graphics.setColor(inactiveTextColor);
        int availableWidth = textComp.getWidth();
        Insets insets = textComp.getInsets();
        if (insets == null || insets.left == 0) {
            insets = new Insets(0, 2, 0, 2);
        }
        String wrappedText = UIUtil.getWrappedText(placeholderMessage, graphics.getFontMetrics(), availableWidth -= insets.left + insets.right);
        int yPos = textComp.getBaseline(textComp.getWidth(), textComp.getHeight());
        UIUtil.drawWrappedString(graphics, wrappedText, insets.left, yPos);
    }

    private static String getWrappedText(String text, FontMetrics fontMetrics, int availableWidth) {
        StringBuilder wrappedText = new StringBuilder();
        if (text.contains("\n")) {
            String[] lines;
            for (String line : lines = text.split("\\n")) {
                int lineWidth = fontMetrics.stringWidth(line);
                if (lineWidth < availableWidth) {
                    wrappedText.append(line).append("\n");
                    continue;
                }
                UIUtil.wrapWords(line, fontMetrics, availableWidth, wrappedText);
            }
        } else {
            UIUtil.wrapWords(text, fontMetrics, availableWidth, wrappedText);
        }
        return wrappedText.toString();
    }

    private static void wrapWords(String text, FontMetrics fontMetrics, int availableWidth, StringBuilder wrappedText) {
        String[] words;
        int lineWidth = 0;
        for (String word : words = text.split("\\s+")) {
            int wordWidth = fontMetrics.stringWidth(word);
            if (lineWidth + wordWidth > availableWidth) {
                wrappedText.append("\n");
                lineWidth = 0;
            }
            wrappedText.append(word).append(" ");
            lineWidth += wordWidth + fontMetrics.stringWidth(" ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void drawWrappedString(Graphics2D graphics, String text, int x, int y) {
        Map originalRenderingHints = UIUtil.updateAntialiasing(graphics);
        try {
            for (String line : text.split("\n")) {
                graphics.drawString(line, x, y);
                y += graphics.getFontMetrics().getHeight();
            }
        }
        finally {
            graphics.setRenderingHints(originalRenderingHints);
        }
    }

    private static Map updateAntialiasing(Graphics graphics) {
        RenderingHints oldHints = null;
        Graphics2D g2d = null;
        if (graphics instanceof Graphics2D) {
            g2d = (Graphics2D)graphics;
            oldHints = g2d.getRenderingHints();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Object obj = toolkit.getDesktopProperty("awt.font.desktophints");
            if (obj instanceof Map) {
                Map map = (Map)obj;
                g2d.addRenderingHints(map);
            }
            if (g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING) != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
                if (LFDetector.isMacLF()) {
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                } else {
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
                }
            }
        }
        return oldHints;
    }

    public static JButton createBrowseForDirOrFileButton(JTextField textField, boolean browseForDir) {
        return UIUtil.createBrowseForDirOrFileButton(textField, browseForDir, new String[]{"md", "txt"});
    }

    public static JButton createBrowseForDirOrFileButton(final JTextField textField, final boolean browseForDir, final String[] extensions) {
        AbstractAction browseAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                File file2 = file = browseForDir ? PluginWorkspaceProvider.getPluginWorkspace().chooseDirectory() : PluginWorkspaceProvider.getPluginWorkspace().chooseFile(Translator.getInstance().getTranslation("Additional_context_files"), extensions, Translator.getInstance().getTranslation("Additional_context_files"));
                if (file != null) {
                    textField.setText(file.getPath());
                }
            }
        };
        ToolbarButton browseButton = new ToolbarButton((Action)browseAction, false);
        browseButton.setIcon((Icon)IconsLoader.loadIcon("/images/Open16.png"));
        return browseButton;
    }

    public static JScrollPane createScrollPane(JComponent component, int verticalScrollBarPolicy, int horizontalScrollbarPolicy) {
        JScrollPane sp = OxygenUIComponentsFactory.createScrollPane((Component)component, (int)verticalScrollBarPolicy, (int)horizontalScrollbarPolicy);
        if (sp.getVerticalScrollBar() != null) {
            sp.getVerticalScrollBar().setUnitIncrement(10);
        }
        return sp;
    }

    public static void setComponentsEnabled(Container container, boolean enabled) {
        Component[] components;
        for (Component component : components = container.getComponents()) {
            component.setEnabled(enabled);
            if (!(component instanceof Container)) continue;
            UIUtil.setComponentsEnabled((Container)component, enabled);
        }
    }

    public static JTextArea createMessageArea(String text) {
        JTextArea msgArea = new JTextArea(text){

            @Override
            public AccessibleContext getAccessibleContext() {
                return new JLabel(this.getText()).getAccessibleContext();
            }
        };
        msgArea.setWrapStyleWord(true);
        msgArea.setLineWrap(true);
        msgArea.setEditable(false);
        msgArea.setCaretPosition(0);
        msgArea.setHighlighter(null);
        msgArea.setFocusable(false);
        msgArea.setOpaque(false);
        msgArea.setBorder(BorderFactory.createEmptyBorder());
        Font font = UIManager.getFont("Label.font");
        if (font != null) {
            msgArea.setFont(font);
        }
        return msgArea;
    }

    public static JRootPane getRootPane(Component component) {
        JRootPane rootPane = null;
        while (component != null) {
            Container parent = component.getParent();
            if (component instanceof RootPaneContainer) {
                rootPane = ((RootPaneContainer)((Object)component)).getRootPane();
                break;
            }
            component = parent;
        }
        return rootPane;
    }

    public static void runNowOrLaterOnAWT(Runnable toRun) {
        if (SwingUtilities.isEventDispatchThread()) {
            toRun.run();
        } else {
            SwingUtilities.invokeLater(toRun);
        }
    }

    public static String getKeystrokeTooltipRepresentation(KeyStroke keyStroke) {
        Object acceleratorText = "";
        if (keyStroke != null) {
            int keyCode;
            int modifiers = keyStroke.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = (String)acceleratorText + "+";
            }
            acceleratorText = (keyCode = keyStroke.getKeyCode()) != 0 ? (String)acceleratorText + KeyEvent.getKeyText(keyCode) : (String)acceleratorText + keyStroke.getKeyChar();
        }
        return acceleratorText;
    }

    public static boolean isDescendingFromRootPane(JRootPane parentRootPane, Component component) {
        boolean isDescendingComponent = false;
        for (Component comp = component; comp != null; comp = comp.getParent()) {
            Window owner;
            if (comp instanceof Window && (owner = ((Window)comp).getOwner()) instanceof JDialog) {
                comp = ((JDialog)owner).getRootPane();
            }
            if (!(comp instanceof JRootPane) || comp != parentRootPane) continue;
            isDescendingComponent = true;
            break;
        }
        return isDescendingComponent;
    }

    public static void invokeSynchronously(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException | InvocationTargetException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setAllDescendantsEnabled(Container container, boolean isEnabled) {
        Arrays.stream(container.getComponents()).forEach(component -> {
            if (component instanceof Container) {
                UIUtil.setAllDescendantsEnabled((Container)component, isEnabled);
            }
            component.setEnabled(isEnabled);
        });
    }
}

