/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.util;

import java.awt.FontMetrics;

public class TextUtil {
    public static String getTruncatedText(String originalFileName, FontMetrics fm, int availableWidth) {
        if (availableWidth <= 0 || fm.stringWidth(originalFileName) <= availableWidth) {
            return originalFileName;
        }
        String ellipsis = "...";
        int ellipsisWidth = fm.stringWidth(ellipsis);
        int textWidth = availableWidth - ellipsisWidth;
        int halfWidth = textWidth / 2;
        int beginChars = 0;
        int width = 0;
        for (char c : originalFileName.toCharArray()) {
            if ((width += fm.charWidth(c)) > halfWidth) break;
            ++beginChars;
        }
        int endChars = 0;
        width = 0;
        char[] chars = originalFileName.toCharArray();
        for (int i = chars.length - 1; i >= 0 && (width += fm.charWidth(chars[i])) <= halfWidth; --i) {
            ++endChars;
        }
        if (beginChars + endChars >= originalFileName.length() - 3) {
            return originalFileName;
        }
        String beginning = originalFileName.substring(0, beginChars);
        String end = originalFileName.substring(originalFileName.length() - endChars);
        return beginning + ellipsis + end;
    }
}

