/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.util;

import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.IFunctionSignaturesRepository;
import com.oxygenxml.positron.utilities.functions.RAGFunctionSignature;
import com.oxygenxml.positron.utilities.functions.WriteFunctionSignature;
import java.util.TreeSet;

public class RAGFunctionsUtil {
    private RAGFunctionsUtil() {
    }

    public static String createRAGFunctionsEnumeration(IFunctionSignaturesRepository repo, boolean forRetrieval) {
        StringBuilder ragFunctionsEnumeration = new StringBuilder();
        TreeSet functionNames = new TreeSet(repo.getAvailableFunctionNames());
        for (String functionName : functionNames) {
            ChatFunctionSignature signature = repo.searchForFunctionSignature(functionName);
            boolean includeFunction = false;
            includeFunction = forRetrieval ? signature instanceof RAGFunctionSignature && ((RAGFunctionSignature)signature).accessesProjectResources() : signature instanceof WriteFunctionSignature;
            if (!includeFunction) continue;
            ragFunctionsEnumeration.append(functionName);
            if (signature.getUIDecriptionForChatMessage() == null || signature.getUIDecriptionForChatMessage().isEmpty()) continue;
            ragFunctionsEnumeration.append(" \u2013 ").append(signature.getUIDecriptionForChatMessage()).append("\n");
        }
        return ragFunctionsEnumeration.toString();
    }
}

