/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.util;

import com.fasterxml.jackson.databind.JavaType;
import com.oxygenxml.ai.positron.license.exception.InvalidLicenseException;
import com.oxygenxml.positron.api.connector.AIConnector;
import com.oxygenxml.positron.api.connector.dto.Pair;
import com.oxygenxml.positron.api.connector.param.CheckBoxConnectorParam;
import com.oxygenxml.positron.api.connector.param.ConnectorParamBase;
import com.oxygenxml.positron.api.connector.param.FieldConnectorParamBase;
import com.oxygenxml.positron.api.connector.param.KeyValueTableConnectorParam;
import com.oxygenxml.positron.api.connector.param.ModelsComboConnectorParam;
import com.oxygenxml.positron.api.connector.param.PasswordTextFieldConnectorParam;
import com.oxygenxml.positron.api.connector.param.TextFieldConnectorParam;
import com.oxygenxml.positron.connector.AIConnectorConfigsManager;
import com.oxygenxml.positron.connector.AIConnectorConfiguration;
import com.oxygenxml.positron.connector.ConnectorConfigurationsPO;
import com.oxygenxml.positron.core.util.JsonHelper;
import com.oxygenxml.positron.core.util.PositronOptionsUtil;
import com.oxygenxml.positron.plugin.license.DirectConnectionLicenseManager;
import com.oxygenxml.positron.plugin.util.AiPositronServiceAccess;
import com.oxygenxml.positron.plugin.util.SecurityHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.ExternalPersistentObject;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.util.editorvars.EditorVariables;

public final class DirectConnectionConfigurationHelper {
    private DirectConnectionConfigurationHelper() {
        throw new UnsupportedOperationException("Instantiation of this helper class is not allowed!");
    }

    public static ConnectorParamBase getConnectorParamById(AIConnector connector, String paramId) {
        return connector.getParametersList().stream().filter(param -> Objects.equals(param.getId(), paramId)).findFirst().orElse(null);
    }

    public static Optional<AIConnectorConfiguration> getSelectedConnectorConfiguration() {
        ConnectorConfigurationsPO connectorConfigurations = (ConnectorConfigurationsPO)PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)new ConnectorConfigurationsPO());
        Optional<AIConnectorConfiguration> toRet = Optional.empty();
        if (connectorConfigurations != null && connectorConfigurations.getCurrentConfigurationId() != null) {
            toRet = AIConnectorConfigsManager.getInstance().getConfigurations().stream().filter(config -> config.getConfigurationId().equals(connectorConfigurations.getCurrentConfigurationId())).findFirst();
        }
        return toRet;
    }

    public static boolean isDirectConnection() {
        return DirectConnectionConfigurationHelper.getSelectedConnectorConfiguration().isPresent() || !AiPositronServiceAccess.getInstance().isAiPositronServiceConnectionEnabledFromAiServicePreferences() || !AiPositronServiceAccess.getInstance().hasAccessToAiPositronService();
    }

    public static boolean isLicenseForDirectConnectionValid() {
        boolean isLicenesedDirectConnection = true;
        try {
            DirectConnectionLicenseManager.getInstance().checkDirectConnectionLicense();
        }
        catch (InvalidLicenseException e) {
            isLicenesedDirectConnection = false;
        }
        return isLicenesedDirectConnection;
    }

    public static String computeOptionIdentifier(AIConnectorConfiguration connectorConfiguration, ConnectorParamBase param) {
        return DirectConnectionConfigurationHelper.computeOptionIdentifier(connectorConfiguration.getConfigurationId(), connectorConfiguration.getConnectorId(), param.getId());
    }

    public static String computeOptionIdentifier(String connectorConfigurationId, String connectorId, String paramId) {
        return PositronOptionsUtil.computeOptionIdentifier((String)"oxygen.positron.plugin.direct.connector.param", (String)connectorConfigurationId, (String)connectorId, (String)paramId);
    }

    public static String getOptionValueForPseudoParam(AIConnectorConfiguration connectorConfiguration, String pseudoParamId) {
        String toRet = null;
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        if (optionsStorage != null) {
            ConnectorConfigurationsPO persistentConfigs = (ConnectorConfigurationsPO)optionsStorage.getPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)new ConnectorConfigurationsPO());
            Map configParams = persistentConfigs.getConfigurationParameters(connectorConfiguration.getConfigurationId());
            toRet = (String)configParams.get(pseudoParamId);
        }
        return toRet;
    }

    public static Object getOptionValueForParam(AIConnectorConfiguration connectorConfiguration, ConnectorParamBase param, boolean forceDefaultValue) {
        return DirectConnectionConfigurationHelper.getValueForParam(connectorConfiguration, param, forceDefaultValue, false);
    }

    public static Object getValueForParam(AIConnectorConfiguration connectorConfiguration, ConnectorParamBase param, boolean forceDefaultValue, boolean shouldExpandVariables) {
        Object toReturn = null;
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        if (optionsStorage != null) {
            ConnectorConfigurationsPO persistentConfigs = (ConnectorConfigurationsPO)optionsStorage.getPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)new ConnectorConfigurationsPO());
            switch (param.getType()) {
                case TEXT_FIELD: {
                    toReturn = DirectConnectionConfigurationHelper.getParamValueForTextField(connectorConfiguration, (TextFieldConnectorParam)param, forceDefaultValue, persistentConfigs);
                    if (!shouldExpandVariables) break;
                    toReturn = EditorVariables.expandEditorVariables((String)((String)toReturn), null);
                    break;
                }
                case COMBO_BOX: 
                case MODEL_COMBO_BOX: {
                    toReturn = DirectConnectionConfigurationHelper.getParamValueForComboBox(connectorConfiguration, (FieldConnectorParamBase)((ModelsComboConnectorParam)param), forceDefaultValue, persistentConfigs);
                    if (!shouldExpandVariables) break;
                    toReturn = EditorVariables.expandEditorVariables((String)((String)toReturn), null);
                    break;
                }
                case CHECK_BOX: {
                    toReturn = DirectConnectionConfigurationHelper.getParamValueForCheckBox(connectorConfiguration, (CheckBoxConnectorParam)param, forceDefaultValue, persistentConfigs);
                    break;
                }
                case PASSWORD_TEXT_FIELD: {
                    toReturn = DirectConnectionConfigurationHelper.getParamValueForPasswordTextField(connectorConfiguration, (PasswordTextFieldConnectorParam)param, forceDefaultValue, optionsStorage);
                    if (!shouldExpandVariables) break;
                    toReturn = EditorVariables.expandEditorVariables((String)((String)toReturn), null);
                    break;
                }
                case KEY_VALUE_TABLE: {
                    List<Pair<String, String>> paramValueList = DirectConnectionConfigurationHelper.getParamValueForKeyValueTable(connectorConfiguration, (KeyValueTableConnectorParam)param, forceDefaultValue, persistentConfigs);
                    if (shouldExpandVariables) {
                        for (int i = 0; i < paramValueList.size(); ++i) {
                            Pair<String, String> pair = paramValueList.get(i);
                            pair.setSecond((Object)EditorVariables.expandEditorVariables((String)((String)pair.getSecond()), null));
                        }
                    }
                    toReturn = paramValueList;
                    break;
                }
            }
        }
        return toReturn;
    }

    private static List<Pair<String, String>> getParamValueForKeyValueTable(AIConnectorConfiguration connectorConfiguration, KeyValueTableConnectorParam param, boolean forceDefaultValue, ConnectorConfigurationsPO persistentConfigs) {
        ArrayList<Pair<String, String>> items = new ArrayList<Pair<String, String>>();
        if (forceDefaultValue) {
            if (param.getDefaultValue() != null) {
                items.addAll(param.getDefaultValue());
            }
        } else {
            Map configParams = persistentConfigs.getConfigurationParameters(connectorConfiguration.getConfigurationId());
            String paramValue = (String)configParams.get(param.getId());
            String stringValues = paramValue != null ? paramValue : (param.getDefaultValue() != null ? JsonHelper.getInstance().toJSON((Object)param.getDefaultValue()) : "");
            Object value = JsonHelper.getInstance().toObject(stringValues, (JavaType)JsonHelper.getInstance().constructCollectionType(List.class, Pair.class));
            if (value instanceof List) {
                items.addAll((Collection)value);
            }
        }
        return items;
    }

    private static String getParamValueForPasswordTextField(AIConnectorConfiguration connectorConfiguration, PasswordTextFieldConnectorParam param, boolean forceDefaultValue, WSOptionsStorage optionsStorage) {
        String defaultValue;
        String string = defaultValue = param.getDefaultValue() != null ? param.getDefaultValue() : "";
        if (forceDefaultValue) {
            return defaultValue;
        }
        String option = optionsStorage.getOption(DirectConnectionConfigurationHelper.computeOptionIdentifier(connectorConfiguration, (ConnectorParamBase)param), null);
        return option != null ? SecurityHelper.getInstance().decryptText(option) : defaultValue;
    }

    private static Object getParamValueForCheckBox(AIConnectorConfiguration connectorConfiguration, CheckBoxConnectorParam param, boolean forceDefaultValue, ConnectorConfigurationsPO persistentConfigs) {
        if (forceDefaultValue) {
            return param.getDefaultValue();
        }
        Map configParams = persistentConfigs.getConfigurationParameters(connectorConfiguration.getConfigurationId());
        String paramValue = (String)configParams.get(param.getId());
        if (paramValue != null) {
            return Boolean.parseBoolean(paramValue);
        }
        return param.getDefaultValue();
    }

    private static Object getParamValueForComboBox(AIConnectorConfiguration connectorConfiguration, FieldConnectorParamBase param, boolean forceDefaultValue, ConnectorConfigurationsPO persistentConfigs) {
        String defaultValue;
        String string = defaultValue = param.getDefaultValue() != null ? param.getDefaultValue() : "";
        if (forceDefaultValue) {
            return defaultValue;
        }
        Map configParams = persistentConfigs.getConfigurationParameters(connectorConfiguration.getConfigurationId());
        String paramValue = (String)configParams.get(param.getId());
        return paramValue != null ? paramValue : defaultValue;
    }

    private static String getParamValueForTextField(AIConnectorConfiguration connectorConfiguration, TextFieldConnectorParam param, boolean forceDefaultValue, ConnectorConfigurationsPO persistentConfigs) {
        String defaultValue;
        String string = defaultValue = param.getDefaultValue() != null ? param.getDefaultValue() : "";
        if (forceDefaultValue) {
            return defaultValue;
        }
        Map configParams = persistentConfigs.getConfigurationParameters(connectorConfiguration.getConfigurationId());
        String paramValue = (String)configParams.get(param.getId());
        return paramValue != null ? paramValue : defaultValue;
    }
}

