/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.ui;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.util.PlatformUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import ro.sync.exml.workspace.api.standalone.ui.Button;

public class OKOtherAndCancelDialog
extends JDialog {
    public static final int DLG_MARGIN_GAP_MAC = 24;
    public static final int DLG_MARGIN_GAP_WIN = 11;
    public static final int HGAP_MAC = 12;
    public static final int HGAP_WIN = 7;
    private final Button okButton = new Button(Translator.getInstance().getTranslation("Ok"));
    private final Button otherButton = new Button(Translator.getInstance().getTranslation("Other"));
    private final Button cancelButton = new Button(Translator.getInstance().getTranslation("Cancel"));
    private static final Dimension MAC_OS_DIMENSION = new Dimension(80, 26);
    private static final Dimension WIN_OS_DIMENSION = new Dimension(75, 23);
    private static final Dimension OTHER_OS_DIMENSION = new Dimension(85, 23);
    private static final int MAC_OS_WIDTH_DISPLACEMENT = 15;
    private static final int MAC_OS_HEIGHT_DISPLACEMENT = 4;
    private int result = -1;
    private final JPanel contentPanel = new JPanel(new BorderLayout());
    private final Dimension buttonsSize = PlatformUtils.isWin() ? WIN_OS_DIMENSION : (PlatformUtils.isMacOS() ? MAC_OS_DIMENSION : OTHER_OS_DIMENSION);
    public static final int RESULT_EXIT_FROM_DIALOG = -1;
    public static final int RESULT_CANCEL = 0;
    public static final int RESULT_OK = 1;
    public static final int RESULT_OTHER = 2;

    public OKOtherAndCancelDialog(Frame parentFrame, String title, boolean modal) {
        super((Window)parentFrame, title, modal ? Dialog.DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS);
        this.getRootPane().setDefaultButton((JButton)this.okButton);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OKOtherAndCancelDialog.this.cancelButton.isEnabled()) {
                    OKOtherAndCancelDialog.this.result = -1;
                    OKOtherAndCancelDialog.this.dispose();
                }
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), cancelAction);
        this.getRootPane().getActionMap().put(cancelAction, cancelAction);
        int bw = PlatformUtils.isMacOS() ? 24 : 11;
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(bw, bw, bw, bw));
        GridBagConstraints gridBagConstr = new GridBagConstraints();
        gridBagConstr.gridx = 0;
        gridBagConstr.gridy = 0;
        gridBagConstr.fill = 1;
        gridBagConstr.weightx = 1.0;
        gridBagConstr.weighty = 1.0;
        gridBagConstr.anchor = 17;
        gridBagConstr.gridwidth = 3;
        gridBagConstr.gridheight = 1;
        mainPanel.add((Component)this.contentPanel, gridBagConstr);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        this.okButton.addActionListener(e -> {
            this.result = 1;
            this.dispose();
        });
        this.otherButton.addActionListener(e -> {
            this.result = 2;
            this.dispose();
        });
        this.cancelButton.addActionListener(e -> {
            this.result = 0;
            this.dispose();
        });
        buttonsPanel.add(Box.createHorizontalGlue());
        if (PlatformUtils.isMacOS()) {
            buttonsPanel.add((Component)this.cancelButton);
            buttonsPanel.add(Box.createHorizontalStrut(12));
            buttonsPanel.add((Component)this.otherButton);
            buttonsPanel.add(Box.createHorizontalStrut(12));
            buttonsPanel.add((Component)this.okButton);
        } else {
            buttonsPanel.add((Component)this.okButton);
            buttonsPanel.add(Box.createHorizontalStrut(7));
            buttonsPanel.add((Component)this.otherButton);
            buttonsPanel.add(Box.createHorizontalStrut(7));
            buttonsPanel.add((Component)this.cancelButton);
        }
        gridBagConstr.gridx = 0;
        ++gridBagConstr.gridy;
        gridBagConstr.gridwidth = 3;
        gridBagConstr.gridheight = 1;
        gridBagConstr.weightx = 1.0;
        gridBagConstr.weighty = 0.0;
        gridBagConstr.anchor = 13;
        gridBagConstr.fill = 2;
        gridBagConstr.insets = new Insets(5, 0, 0, 0);
        mainPanel.add((Component)buttonsPanel, gridBagConstr);
        this.setContentPane(mainPanel);
        this.setResizable(false);
        this.pack();
        if (parentFrame != null) {
            this.setIconImage(parentFrame.getIconImage());
            int x = parentFrame.getX() + (parentFrame.getWidth() / 2 - this.getWidth());
            int y = parentFrame.getY() + (parentFrame.getHeight() / 2 - this.getHeight());
            this.setLocation(x, y);
        }
    }

    private void setButtonText(JButton button, String text) {
        if (text != null && text.length() > 0) {
            int textWidth = button.getFontMetrics(button.getFont()).stringWidth(text);
            int textHeight = button.getFontMetrics(button.getFont()).getHeight();
            int allocW = this.buttonsSize.width - button.getMargin().left - button.getMargin().right;
            int allocH = this.buttonsSize.height - button.getMargin().top - button.getMargin().bottom;
            if (PlatformUtils.isMacOS()) {
                allocW -= 15;
                allocH -= 4;
            }
            if (textWidth <= allocW - 4 && textHeight <= allocH) {
                button.setPreferredSize(this.buttonsSize);
            } else {
                button.setPreferredSize(null);
            }
            button.setText(text);
        }
    }

    public void setOKButtonText(String text) {
        this.setButtonText((JButton)this.getOKButton(), text);
    }

    public void setOtherButtonText(String text) {
        this.setButtonText((JButton)this.getOtherButton(), text);
    }

    public void setCancelButtonText(String text) {
        this.setButtonText((JButton)this.getCancelButton(), text);
    }

    public Button getOKButton() {
        return this.okButton;
    }

    public Button getOtherButton() {
        return this.otherButton;
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public int getResult() {
        return this.result;
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }
}

