/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.ui;

import com.oxygenxml.positron.plugin.ui.ThemeColorProvider;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.IllegalComponentStateException;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.basic.util.accessibility.AccessibilityUtil;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public abstract class LinkLabel
extends JLabel {
    private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

    public LinkLabel(String text) {
        super(text);
        this.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                LinkLabel.this.updateFocusBorder();
            }

            @Override
            public void focusGained(FocusEvent e) {
                LinkLabel.this.updateFocusBorder();
            }
        });
        this.setBorder(DEFAULT_NO_FOCUS_BORDER);
        this.setForeground(ThemeColorProvider.getInstance().getLinkColor());
        final HashMap<TextAttribute, Integer> underlinedTextAttributeMap = new HashMap<TextAttribute, Integer>();
        underlinedTextAttributeMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        this.setFont(this.getDerivedFont(underlinedTextAttributeMap));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (LinkLabel.this.isEnabled() && !e.isPopupTrigger() && !SwingUtilities.isRightMouseButton(e)) {
                    LinkLabel.this.performAction();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                LinkLabel.this.setFont(LinkLabel.this.getDerivedFont(underlinedTextAttributeMap));
                LinkLabel.this.setForeground(ThemeColorProvider.getInstance().getLinkHoverColor());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LinkLabel.this.setFont(LinkLabel.this.getDerivedFont(underlinedTextAttributeMap));
                LinkLabel.this.setForeground(ThemeColorProvider.getInstance().getLinkColor());
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if ((e.getKeyCode() == 10 || e.getKeyCode() == 32) && LinkLabel.this.isFocusOwner() && LinkLabel.this.isEnabled()) {
                    e.consume();
                    LinkLabel.this.performAction();
                }
            }
        });
        this.setCursor(new Cursor(12));
        this.setHorizontalAlignment(0);
    }

    private Font getDerivedFont(Map<TextAttribute, Integer> textAttributeMap) {
        return this.getFont().deriveFont(textAttributeMap);
    }

    private void updateFocusBorder() {
        Border border = DEFAULT_NO_FOCUS_BORDER;
        if (this.isFocusOwner()) {
            Color focusColor;
            if ((PlatformDetector.isWinXPOrLater() || AccessibilityUtil.isJavaAccessBridgeEnabled()) && (focusColor = UIManager.getColor("Button.focus", this.getLocale())) != null) {
                border = BorderFactory.createDashedBorder(focusColor);
            }
            if (border == null && (border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder", this.getLocale())) == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder", this.getLocale());
            }
        }
        this.setBorder(border);
    }

    public abstract void performAction();

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            final AccessibleContext accessibleContextSuper = super.getAccessibleContext();
            this.accessibleContext = new AccessibleContext(){

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.HYPERLINK;
                }

                @Override
                public AccessibleStateSet getAccessibleStateSet() {
                    return accessibleContextSuper.getAccessibleStateSet();
                }

                @Override
                public int getAccessibleIndexInParent() {
                    return accessibleContextSuper.getAccessibleIndexInParent();
                }

                @Override
                public int getAccessibleChildrenCount() {
                    return accessibleContextSuper.getAccessibleChildrenCount();
                }

                @Override
                public Accessible getAccessibleChild(int i) {
                    return accessibleContextSuper.getAccessibleChild(i);
                }

                @Override
                public Locale getLocale() throws IllegalComponentStateException {
                    return accessibleContextSuper.getLocale();
                }
            };
        }
        return this.accessibleContext;
    }

    @Override
    public JToolTip createToolTip() {
        return OxygenUIComponentsFactory.installMultilineTooltip((JComponent)this);
    }
}

