/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.refactoring;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.basic.xml.encoding.EncodingDetectorInterface;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.listeners.BatchOperationInfo;
import ro.sync.exml.workspace.api.listeners.BatchOperationsListener;
import ro.sync.xml.encoding.EncodingDetector;

class RefactoredContent {
    private static final Logger logger = LoggerFactory.getLogger(RefactoredContent.class);
    private String initialContent;
    private String changedContent;
    private URL urlToRefactor;
    private File temporaryFileWithUpdatedContent;

    public RefactoredContent(URL refactoredFile, String initialContent, String refactoredContent) {
        this.initialContent = initialContent;
        this.changedContent = refactoredContent;
        this.urlToRefactor = refactoredFile;
    }

    public String getInitialContent() {
        return this.initialContent;
    }

    public String getRefactoredContent() {
        return this.changedContent;
    }

    public URL getFileToRefactor() {
        return this.urlToRefactor;
    }

    public URL getTemporaryFileWithUpdates() throws IOException {
        String fileName = this.urlToRefactor.toString();
        int lastDotIndex = fileName.lastIndexOf(46);
        String extensie = "";
        if (lastDotIndex != -1) {
            extensie = fileName.substring(lastDotIndex + 1);
        }
        this.temporaryFileWithUpdatedContent = File.createTempFile("changed_cotent", "." + extensie);
        this.temporaryFileWithUpdatedContent.deleteOnExit();
        ArrayList bomBytes = new ArrayList();
        EncodingDetectorInterface encodingDetector = EncodingDetector.getInstance();
        String javaEncoding = encodingDetector.getJavaEncoding((Reader)new StringReader(this.changedContent), false, bomBytes);
        String contentType = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().getContentType(URLUtil.correct((File)this.temporaryFileWithUpdatedContent).toString());
        try (OutputStreamWriter createWriter = encodingDetector.createWriter((OutputStream)new FileOutputStream(this.temporaryFileWithUpdatedContent), javaEncoding, encodingDetector.getJavaEncodingFromContentType(contentType), !bomBytes.isEmpty());){
            createWriter.write(this.changedContent);
        }
        catch (IOException e) {
            logger.debug("The temporary file cannot be written. %s", (Throwable)e);
            throw e;
        }
        return URLUtil.correct((File)this.temporaryFileWithUpdatedContent);
    }

    public void applyAllChangesToResource(BatchOperationsListener batchOperationListener) throws IOException {
        ArrayList bomBytes = new ArrayList();
        EncodingDetectorInterface encodingDetector = EncodingDetector.getInstance();
        String javaEncoding = encodingDetector.getJavaEncoding((Reader)new StringReader(this.changedContent), false, bomBytes);
        String contentType = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().getContentType(URLUtil.correct((URL)this.urlToRefactor).toString());
        if (batchOperationListener != null) {
            batchOperationListener.aboutToModifyResource(new BatchOperationInfo(BatchOperationInfo.Type.REPLACE_ALL), this.urlToRefactor);
        }
        try (OutputStreamWriter createWriter = encodingDetector.createWriter(URLUtil.openOutputStream((URL)this.urlToRefactor), javaEncoding, encodingDetector.getJavaEncodingFromContentType(contentType), !bomBytes.isEmpty());){
            createWriter.write(this.changedContent);
        }
        catch (IOException e) {
            logger.debug("The file that must be modified cannot be written. %s", (Throwable)e);
            throw e;
        }
        if (batchOperationListener != null) {
            batchOperationListener.resourceModified(new BatchOperationInfo(BatchOperationInfo.Type.REPLACE_ALL), this.urlToRefactor);
        }
    }

    public void deleteTempFile() {
        try {
            Files.delete(this.temporaryFileWithUpdatedContent.toPath());
        }
        catch (IOException e) {
            logger.debug("The temporary file cannot be deleted. %s", (Throwable)e);
        }
    }
}

