/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.refactoring;

import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.refactoring.ActionUsage;
import com.oxygenxml.positron.plugin.refactoring.PredefinedActionsComboBoxRenderer;
import com.oxygenxml.positron.plugin.refactoring.RefactoringCost;
import com.oxygenxml.positron.plugin.refactoring.RefactoringCostProvider;
import com.oxygenxml.positron.plugin.ui.TextAreaWithPlaceHolder;
import com.oxygenxml.positron.plugin.util.DirectConnectionConfigurationHelper;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.OKCancelDialog;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class RefactorDescriptionDialog
extends OKCancelDialog {
    private static final JRadioButton DEFAULT_RADIO_BUTTON = new JRadioButton();
    private static final int DEFAULT_RADIO_WIDTH = RefactorDescriptionDialog.DEFAULT_RADIO_BUTTON.getPreferredSize().width;
    private static final Translator TRANSLATOR = Translator.getInstance();
    private static final int DESCRIPTION_AREA_PREFERRED_WIDTH = 475;
    private static final int DESCRIPTION_AREA_PREFERRED_HEIGHT = 150;
    private static final int DESCRIPTION_AREA_MINIMUM_WIDTH = 50;
    private static final int DESCRIPTION_AREA_MINIMUM_HEIGHT = 70;
    private JTextArea promptDescriptionArea;
    private ActionUsage userDecision;
    private JComboBox<AIActionDetails> predefinedActionsComboBox;
    private JLabel costInfoLabel;
    private JLabel unknownExtensionInfoLabel;
    private CompletionActionsManager completionActionsManager;
    private static RefactorDescriptionDialog instance;
    private RefactoringCostProvider refactorCostProvider;

    public static RefactorDescriptionDialog getInstance() {
        if (instance == null) {
            instance = new RefactorDescriptionDialog();
        }
        return instance;
    }

    private RefactorDescriptionDialog() {
        super(PluginWorkspaceProvider.getPluginWorkspace() != null ? (JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame() : null, TRANSLATOR.getTranslation("Refactor_Title"), true);
        this.setOkButtonText(TRANSLATOR.getTranslation("Refactor_Preview_Button"));
        this.setResizable(true);
        this.getContentPane().add(this.createMainPanel());
    }

    private JPanel createRadioButtonsPanel(final JPanel mainPanel) {
        JPanel radioButtonsPanel = new JPanel(new GridBagLayout());
        final JRadioButton usePredefinedPromptRadioBtn = new JRadioButton(TRANSLATOR.getTranslation("Refactor_Using_Predefined_Action") + ":");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        radioButtonsPanel.add((Component)usePredefinedPromptRadioBtn, gbc);
        this.predefinedActionsComboBox = OxygenUIComponentsFactory.createComboBox(new DefaultComboBoxModel());
        this.predefinedActionsComboBox.setRenderer(new PredefinedActionsComboBoxRenderer(this.predefinedActionsComboBox.getRenderer()));
        this.predefinedActionsComboBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!usePredefinedPromptRadioBtn.isSelected()) {
                    usePredefinedPromptRadioBtn.setSelected(true);
                }
            }
        });
        this.predefinedActionsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RefactorDescriptionDialog.this.refactorCostProvider != null) {
                    RefactorDescriptionDialog.this.updateCostInfoMessage(RefactorDescriptionDialog.this.refactorCostProvider.getRefactoringCostForAction(RefactorDescriptionDialog.this.getSelectedPredefinedAction()));
                }
                mainPanel.repaint();
            }
        });
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.top = 5 - RefactorDescriptionDialog.DEFAULT_RADIO_BUTTON.getInsets().bottom;
        gbc.insets.left = DEFAULT_RADIO_WIDTH;
        radioButtonsPanel.add(this.predefinedActionsComboBox, gbc);
        final JRadioButton useCustomActionRadioBtn = new JRadioButton(TRANSLATOR.getTranslation("Refactor_Using_Custom_Action"));
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.fill = 0;
        gbc.insets.top = 11;
        gbc.insets.left = 0;
        gbc.weightx = 1.0;
        radioButtonsPanel.add((Component)useCustomActionRadioBtn, gbc);
        ++gbc.gridy;
        gbc.insets.top = 5 - RefactorDescriptionDialog.DEFAULT_RADIO_BUTTON.getInsets().bottom;
        gbc.insets.left = DEFAULT_RADIO_WIDTH;
        JLabel extraInstructionsLabel = new JLabel(TRANSLATOR.getTranslation("Refactor_Using_Custom_Action_Details"));
        radioButtonsPanel.add((Component)extraInstructionsLabel, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets.top = 5;
        String placeholder = TRANSLATOR.getTranslation("Short_Example") + ": " + TRANSLATOR.getTranslation("Instructions_dialog_example");
        this.promptDescriptionArea = new TextAreaWithPlaceHolder(placeholder);
        this.promptDescriptionArea.setLineWrap(true);
        this.promptDescriptionArea.setWrapStyleWord(true);
        this.promptDescriptionArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                RefactorDescriptionDialog.this.repaint();
            }
        });
        JScrollPane scrollPane = OxygenUIComponentsFactory.createScrollPane((Component)this.promptDescriptionArea, (int)20, (int)31);
        scrollPane.setPreferredSize(new Dimension(475, 150));
        scrollPane.setMinimumSize(new Dimension(50, 70));
        radioButtonsPanel.add((Component)scrollPane, gbc);
        FocusAdapter actionFieldsFocusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!useCustomActionRadioBtn.isSelected()) {
                    useCustomActionRadioBtn.setSelected(true);
                }
            }
        };
        scrollPane.addFocusListener(actionFieldsFocusListener);
        this.promptDescriptionArea.addFocusListener(actionFieldsFocusListener);
        ButtonGroup group = new ButtonGroup();
        group.add(useCustomActionRadioBtn);
        group.add(usePredefinedPromptRadioBtn);
        ItemListener itemListener = e -> {
            if (e.getStateChange() == 1) {
                Object eventSource = e.getSource();
                if (eventSource == useCustomActionRadioBtn) {
                    this.userDecision = ActionUsage.USE_CUSTOM_ACTION;
                } else if (eventSource == usePredefinedPromptRadioBtn) {
                    this.userDecision = ActionUsage.USE_DEFINED_ACTION;
                }
                if (this.refactorCostProvider != null) {
                    this.updateCostInfoMessage(this.refactorCostProvider.getRefactoringCostForAction(this.getActionToExecute()));
                }
                mainPanel.repaint();
            }
        };
        useCustomActionRadioBtn.addItemListener(itemListener);
        usePredefinedPromptRadioBtn.addItemListener(itemListener);
        usePredefinedPromptRadioBtn.setSelected(true);
        return radioButtonsPanel;
    }

    public AIActionDetails getSelectedPredefinedAction() {
        return (AIActionDetails)this.predefinedActionsComboBox.getSelectedItem();
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.anchor = 17;
        String message = TRANSLATOR.getTranslation("Refactor_Instructions");
        JComponent multiLineLabel = OxygenUIComponentsFactory.createMultilineLabel((String)(message + "."), (boolean)false);
        multiLineLabel.setBorder(BorderFactory.createEmptyBorder());
        panel.add((Component)multiLineLabel, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.insets.top = 7;
        panel.add((Component)this.createRadioButtonsPanel(panel), gbc);
        this.costInfoLabel = new JLabel();
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.insets.top = 11;
        ++gbc.gridy;
        panel.add((Component)this.costInfoLabel, gbc);
        this.unknownExtensionInfoLabel = new JLabel();
        ++gbc.gridy;
        gbc.insets.top = 7;
        gbc.insets.bottom = 11;
        panel.add((Component)this.unknownExtensionInfoLabel, gbc);
        return panel;
    }

    private void updateCostInfoMessage(RefactoringCost updateRefactoringCost) {
        boolean thereAreFilesWithUnknownExtensions;
        if (DirectConnectionConfigurationHelper.isDirectConnection()) {
            this.costInfoLabel.setText("");
            this.unknownExtensionInfoLabel.setText("");
            return;
        }
        Object[] info = new Object[]{updateRefactoringCost.getNoOfFilesToRefactor(), updateRefactoringCost.getCost()};
        String lastInfoMessage = MessageFormat.format(TRANSLATOR.getTranslation("Refactor_Cost"), info);
        this.costInfoLabel.setText(lastInfoMessage);
        this.unknownExtensionInfoLabel.setText("");
        boolean bl = thereAreFilesWithUnknownExtensions = updateRefactoringCost.getUnknownResourcesProperties().getNrOfFilesWithUnknownExtensions() > 0;
        if (thereAreFilesWithUnknownExtensions) {
            String extensionInfo = MessageFormat.format(TRANSLATOR.getTranslation("Refactor_Unknown_Extension"), updateRefactoringCost.getUnknownResourcesProperties().getNrOfFilesWithUnknownExtensions());
            this.unknownExtensionInfoLabel.setText(extensionInfo);
        }
    }

    public int showDialog(List<AIActionDetails> completionActions, RefactoringCostProvider refactorCostProvider, CompletionActionsManager completionActionsManager) {
        this.refactorCostProvider = refactorCostProvider;
        this.completionActionsManager = completionActionsManager;
        ArrayList<AIActionDetails> comboActions = new ArrayList<AIActionDetails>();
        int itemCount = this.predefinedActionsComboBox.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            comboActions.add(this.predefinedActionsComboBox.getItemAt(i));
        }
        if (!this.areTheSameActions(completionActions, comboActions)) {
            this.repopulateActionsCombo(completionActions);
        }
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        if (this.userDecision == ActionUsage.USE_CUSTOM_ACTION) {
            this.promptDescriptionArea.requestFocusInWindow();
            this.promptDescriptionArea.selectAll();
        }
        this.setVisible(true);
        return this.getResult();
    }

    private void repopulateActionsCombo(List<AIActionDetails> completionActions) {
        AIActionDetails prevSelItem = (AIActionDetails)this.predefinedActionsComboBox.getSelectedItem();
        this.predefinedActionsComboBox.removeAllItems();
        completionActions.forEach(actionDetails -> this.predefinedActionsComboBox.addItem((AIActionDetails)actionDetails));
        if (prevSelItem != null) {
            this.predefinedActionsComboBox.setSelectedItem(prevSelItem);
        }
    }

    private boolean areTheSameActions(List<AIActionDetails> completionActions, List<AIActionDetails> comboActions) {
        if (completionActions.size() != comboActions.size()) {
            return false;
        }
        ArrayList<AIActionDetails> list1 = new ArrayList<AIActionDetails>(comboActions);
        ArrayList<AIActionDetails> list2 = new ArrayList<AIActionDetails>(completionActions);
        Comparator<AIActionDetails> comparator = new Comparator<AIActionDetails>(){

            @Override
            public int compare(AIActionDetails o1, AIActionDetails o2) {
                return o1.getId().compareTo(o2.getId());
            }
        };
        Collections.sort(list1, comparator);
        Collections.sort(list2, comparator);
        for (int i = 0; i < list1.size(); ++i) {
            if (((AIActionDetails)list1.get(i)).equals(list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public String getPromptDescription() {
        return this.promptDescriptionArea.getText().trim();
    }

    protected void doOK() {
        String description;
        if (this.userDecision == ActionUsage.USE_CUSTOM_ACTION && (description = this.getPromptDescription()).isEmpty()) {
            PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage(TRANSLATOR.getTranslation("Instructions_mandatory"));
            return;
        }
        super.doOK();
    }

    public AIActionDetails getActionToExecute() {
        return this.userDecision == ActionUsage.USE_DEFINED_ACTION ? this.getSelectedPredefinedAction() : this.completionActionsManager.getPseudoActionDetailsByID("ai-based-refactoring");
    }

    @VisibleForTesting
    JComboBox<AIActionDetails> getPredefinedActionsComboBox() {
        return this.predefinedActionsComboBox;
    }
}

