/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.recordexamples;

import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.recordexamples.DiffEntry;
import com.oxygenxml.positron.plugin.recordexamples.InstructionsWithExamples;
import com.oxygenxml.positron.plugin.recordexamples.StartRecordingDialogInterface;
import com.oxygenxml.positron.plugin.recordexamples.StartRecordingDialogProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.diff.api.DiffException;
import ro.sync.diff.api.DiffOptions;
import ro.sync.diff.api.Difference;
import ro.sync.diff.api.DifferencePerformer;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.listeners.WSEditorChangeListener;
import ro.sync.exml.workspace.api.results.ResultsManager;
import ro.sync.exml.workspace.api.util.CompareUtilAccess;

public class EditorRecorder {
    private static final Logger logger = LoggerFactory.getLogger((String)EditorRecorder.class.getName());
    private static StartRecordingDialogProvider startRecordingDialogProvider = null;
    private Map<URL, String> initialContent = new HashMap<URL, String>();
    private State currentState = State.NOT_RUNNING;
    private WSEditorChangeListener editorChangeListener;
    private Optional<String> userInstructionsFromDialog;

    public static EditorRecorder getInstance() {
        return SingletonHelper.INSTANCE;
    }

    public static void setStartRecordingDialogProvider(StartRecordingDialogProvider startRecordingDialogProvider) {
        EditorRecorder.startRecordingDialogProvider = startRecordingDialogProvider;
    }

    public void startRecording() {
        this.initialContent.clear();
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        WSEditor currentEditor = pluginWorkspace.getCurrentEditorAccess(0);
        if (currentEditor == null) {
            String message = Translator.getInstance().getTranslation("Recording_failure_because_no_editor_opened");
            pluginWorkspace.showErrorMessage(message);
        } else {
            this.userInstructionsFromDialog = this.getInstructionsFromUser();
            if (this.userInstructionsFromDialog.isEmpty()) {
                return;
            }
            this.storeInitialContent(currentEditor.getEditorLocation());
            this.editorChangeListener = new WSEditorChangeListener(){

                public void editorActivated(URL editorLocation) {
                    if (!EditorRecorder.this.initialContent.containsKey(editorLocation)) {
                        EditorRecorder.this.storeInitialContent(editorLocation);
                    }
                }
            };
            pluginWorkspace.addEditorChangeListener(this.editorChangeListener, 0);
            this.currentState = State.RUNNNING;
        }
    }

    @VisibleForTesting
    Optional<String> getInstructionsFromUser() {
        StartRecordingDialogInterface startRecordingDialog;
        Optional<String> fromUser = Optional.empty();
        if (startRecordingDialogProvider != null && (startRecordingDialog = startRecordingDialogProvider.getStartRecordingDialog()) != null && startRecordingDialog.showDialog() == 1) {
            fromUser = Optional.of(startRecordingDialog.getPromptDescription());
        }
        return fromUser;
    }

    List<DiffEntry> getAllExamples() {
        return this.getAllExamples(this.initialContent);
    }

    private List<DiffEntry> getAllExamples(Map<URL, String> diffedContent) {
        ArrayList<DiffEntry> examples = new ArrayList<DiffEntry>();
        for (Map.Entry<URL, String> entry : diffedContent.entrySet()) {
            Optional<Object> diffEntry = Optional.empty();
            try {
                diffEntry = this.getExample(entry.getKey(), entry.getValue());
            }
            catch (DiffException e) {
                logger.debug(e.getMessage());
                this.shorErrorInResultsView((Exception)((Object)e), null);
            }
            if (diffEntry.isEmpty()) continue;
            examples.add((DiffEntry)diffEntry.get());
        }
        logger.debug("Examples:\n{}", examples);
        return examples;
    }

    private void shorErrorInResultsView(Exception e, URL editorLocation) {
        ResultsManager resultsManager = PluginWorkspaceProvider.getPluginWorkspace().getResultsManager();
        DocumentPositionedInfo resultInfo = new DocumentPositionedInfo(2, e.getMessage());
        if (editorLocation != null) {
            resultInfo.setAdditionalInfo(editorLocation);
        }
        resultsManager.addResult(Translator.getInstance().getTranslation("Error"), resultInfo, ResultsManager.ResultType.PROBLEM, true, true);
    }

    public InstructionsWithExamples stopRecording() {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        pluginWorkspace.removeEditorChangeListener(this.editorChangeListener, 0);
        InstructionsWithExamples prompt = new InstructionsWithExamples(this.userInstructionsFromDialog.get(), this.getAllExamples());
        this.userInstructionsFromDialog = Optional.empty();
        this.initialContent.clear();
        this.currentState = State.NOT_RUNNING;
        return prompt;
    }

    public Optional<DiffEntry> getExample(URL editorURL, String initialContent) throws DiffException {
        Optional<DiffEntry> exampleToReturn = Optional.empty();
        String modifiedEditorContent = EditorRecorder.getCurrentContentFromEditor(editorURL);
        List<Difference> diffs = this.performDiff(new StringReader(initialContent), new StringReader(modifiedEditorContent));
        if (!diffs.isEmpty()) {
            int leftMinIndex = diffs.get(0).getLeftIntervalStart();
            int leftMaxIndex = diffs.get(0).getLeftIntervalEnd();
            int rightMinIndex = diffs.get(0).getRightIntervalStart();
            int rightMaxIndex = diffs.get(0).getRightIntervalEnd();
            for (Difference difference : diffs) {
                if (logger.isDebugEnabled()) {
                    logger.debug("LEFT: {}", (Object)(difference.getLeftIntervalStart() + " - " + difference.getLeftIntervalEnd()));
                    logger.debug(initialContent.substring(difference.getLeftIntervalStart(), difference.getLeftIntervalEnd()));
                    logger.debug("RIGHT: {}", (Object)(difference.getRightIntervalStart() + " " + difference.getRightIntervalEnd()));
                    logger.debug(modifiedEditorContent.substring(difference.getRightIntervalStart(), difference.getRightIntervalEnd()));
                }
                leftMinIndex = Integer.min(leftMinIndex, difference.getLeftIntervalStart());
                leftMaxIndex = Integer.max(leftMaxIndex, difference.getLeftIntervalEnd());
                rightMinIndex = Integer.min(rightMinIndex, difference.getRightIntervalStart());
                rightMaxIndex = Integer.max(rightMaxIndex, difference.getRightIntervalEnd());
            }
            exampleToReturn = Optional.of(new DiffEntry(initialContent.substring(leftMinIndex, leftMaxIndex), modifiedEditorContent.substring(rightMinIndex, rightMaxIndex), leftMinIndex, leftMaxIndex, rightMinIndex, rightMaxIndex));
        }
        return exampleToReturn;
    }

    List<Difference> performDiff(Reader initialContentReader, Reader finalContentReader) throws DiffException {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        CompareUtilAccess compareUtilAccess = pluginWorkspace.getCompareUtilAccess();
        DifferencePerformer diffPerformer = compareUtilAccess.createDiffPerformer();
        DiffOptions options = new DiffOptions();
        options.setAlgorithm(4);
        return diffPerformer.performDiff(initialContentReader, finalContentReader, null, null, null, options, null);
    }

    public boolean isRunning() {
        return this.currentState == State.RUNNNING;
    }

    void storeInitialContent(URL editorLocation) {
        String initialContentOfEditor = EditorRecorder.getCurrentContentFromEditor(editorLocation);
        this.initialContent.put(editorLocation, initialContentOfEditor);
    }

    public static String getCurrentContentFromEditor(URL editorLocation) {
        String editorContent = "";
        WSEditor editor = PluginWorkspaceProvider.getPluginWorkspace().getEditorAccess(editorLocation, 0);
        try {
            URL correctedURL = URLUtil.correct((URL)editorLocation);
            Reader in = editor != null ? editor.createContentReader() : PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().createReader(correctedURL, null);
            try (BufferedReader reader = new BufferedReader(in);){
                editorContent = reader.lines().collect(Collectors.joining("\n"));
                logger.debug("Initial editor content for {}\n: {}", (Object)editorLocation, (Object)editorContent);
            }
            catch (IOException e) {
                logger.debug((Object)e, (Throwable)e);
            }
        }
        catch (IOException e) {
            logger.debug((Object)e, (Throwable)e);
        }
        return editorContent;
    }

    Map<URL, String> getInitialContent() {
        return this.initialContent;
    }

    @VisibleForTesting
    WSEditorChangeListener getEditorChangeListener() {
        return this.editorChangeListener;
    }

    public static enum State {
        RUNNNING,
        NOT_RUNNING;

    }

    private static class SingletonHelper {
        private static final EditorRecorder INSTANCE = new EditorRecorder();

        private SingletonHelper() {
        }
    }
}

