/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.recordexamples;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.recordexamples.PositronActionDetails;
import com.oxygenxml.positron.plugin.ui.ApplicationListCellRendererWrapper;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionTypeComboBoxRenderer
extends ApplicationListCellRendererWrapper {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private static final Logger logger = LoggerFactory.getLogger((String)ActionTypeComboBoxRenderer.class.getName());

    public ActionTypeComboBoxRenderer(ListCellRenderer wrappedRenderer) {
        super(wrappedRenderer);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel component = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        PositronActionDetails.PositronActionType actionType = (PositronActionDetails.PositronActionType)((Object)value);
        component.setText(this.getDisplayName(actionType));
        component.setToolTipText(this.getToolTip(actionType));
        return component;
    }

    private String getToolTip(PositronActionDetails.PositronActionType actionType) {
        switch (actionType) {
            case REPLACE_CONTENT: {
                return TRANSLATOR.getTranslation("Replace_Content_Tooltip");
            }
            case INSERT_CONTENT: {
                return TRANSLATOR.getTranslation("Insert_Content_Tooltip");
            }
        }
        logger.warn("A different action type was supplied that the expected ones for tool tip text");
        return actionType.name();
    }

    private String getDisplayName(PositronActionDetails.PositronActionType actionType) {
        switch (actionType) {
            case REPLACE_CONTENT: {
                return TRANSLATOR.getTranslation("Replace_Content_Label");
            }
            case INSERT_CONTENT: {
                return TRANSLATOR.getTranslation("Insert_Content_Label");
            }
        }
        logger.warn("A different action type was supplied that the expected ones");
        return actionType.name();
    }
}

