/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.preferences;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.functions.FunctionsPromptToResponsePO;
import com.oxygenxml.positron.functions.SaxonAIFunctionExecutor;
import com.oxygenxml.positron.plugin.preferences.DataDeletionManager;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.exml.plugin.option.OptionPagePluginExtension;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.ExternalPersistentObject;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class XPathFunctionsOptionPageExtension
extends OptionPagePluginExtension {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private static final JCheckBox DUMMY_CHECKBOX = new JCheckBox();
    private static final int JCHECKBOX_WIDTH = XPathFunctionsOptionPageExtension.DUMMY_CHECKBOX.getPreferredSize().width;
    public static final int TEXT_FIELD_DEFAULT_WIDTH_LIMIT = 200;
    private JCheckBox enableXPathFunctionsCheckBox;
    private JCheckBox cacheFunctionsReponseCheckBox;
    private JSpinner cacheSizeSpinner;
    private JLabel cacheSizeLabel;
    private JCheckBox notifyAboutRequestsNumberCheckBox;
    private JSpinner requestsNumberToNotifySpinner;

    public JComponent init(PluginWorkspace pluginWorkspace) {
        JPanel optionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.addAdditionalFunctionsSection(optionPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.85;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        gbc.insets = UIUtil.getNoInsets();
        optionPanel.add((Component)new JPanel(), gbc);
        this.loadPageState(pluginWorkspace);
        return optionPanel;
    }

    private void addAdditionalFunctionsSection(JPanel mainPanel, GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = UIUtil.getNoInsets();
        gbc.fill = 0;
        this.enableXPathFunctionsCheckBox = new JCheckBox(TRANSLATOR.getTranslation("Enable_XPath_functions"));
        mainPanel.add((Component)this.enableXPathFunctionsCheckBox, gbc);
        ++gbc.gridy;
        gbc.insets.left = JCHECKBOX_WIDTH - XPathFunctionsOptionPageExtension.DUMMY_CHECKBOX.getInsets().left;
        this.cacheFunctionsReponseCheckBox = new JCheckBox(TRANSLATOR.getTranslation("Cache_responses_and_reuse_them"));
        mainPanel.add((Component)this.cacheFunctionsReponseCheckBox, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.insets.left += JCHECKBOX_WIDTH;
        gbc.weightx = 0.0;
        this.cacheSizeLabel = new JLabel(TRANSLATOR.getTranslation("Cache_size") + ":");
        mainPanel.add((Component)this.cacheSizeLabel, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.left = 5;
        JPanel spinnerAndCacheReset = new JPanel(new GridBagLayout());
        mainPanel.add((Component)spinnerAndCacheReset, gbc);
        try {
            this.cacheSizeSpinner = new JSpinner(new SpinnerNumberModel(NumberParserUtil.parseInt((String)"500"), 0, 100000, 100));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.cacheSizeSpinner.setPreferredSize(new Dimension(this.cacheSizeSpinner.getPreferredSize().width, this.cacheSizeSpinner.getMinimumSize().height));
        GridBagConstraints constrInner = new GridBagConstraints();
        constrInner.gridx = 0;
        constrInner.gridy = 0;
        constrInner.weightx = 1.0;
        constrInner.fill = 2;
        spinnerAndCacheReset.add((Component)this.cacheSizeSpinner, constrInner);
        JButton clearCacheButton = OxygenUIComponentsFactory.createButton((Action)new AbstractAction(TRANSLATOR.getTranslation("Clear_cache")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
                optionsStorage.setPersistentObjectOption("oxygen.positron.plugin.functions.cache.encrypted", (ExternalPersistentObject)new FunctionsPromptToResponsePO());
                SaxonAIFunctionExecutor.getFunctionsCache().clearCache();
            }
        });
        ++constrInner.gridx;
        constrInner.weightx = 0.0;
        constrInner.fill = 0;
        constrInner.insets.left = 5;
        spinnerAndCacheReset.add((Component)clearCacheButton, constrInner);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.insets.left = JCHECKBOX_WIDTH - XPathFunctionsOptionPageExtension.DUMMY_CHECKBOX.getInsets().left;
        gbc.insets.top = 5;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.notifyAboutRequestsNumberCheckBox = new JCheckBox(TRANSLATOR.getTranslation("Notify_when_requests_exceed"));
        mainPanel.add((Component)this.notifyAboutRequestsNumberCheckBox, gbc);
        gbc.gridx += 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.left = 5;
        try {
            this.requestsNumberToNotifySpinner = new JSpinner(new SpinnerNumberModel(NumberParserUtil.parseInt((String)"100"), 0, 100000, 100));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.requestsNumberToNotifySpinner.setPreferredSize(new Dimension(this.requestsNumberToNotifySpinner.getPreferredSize().width, this.requestsNumberToNotifySpinner.getMinimumSize().height));
        mainPanel.add((Component)this.requestsNumberToNotifySpinner, gbc);
        this.notifyAboutRequestsNumberCheckBox.addActionListener(event -> {
            JCheckBox cb = (JCheckBox)event.getSource();
            this.requestsNumberToNotifySpinner.setEnabled(cb.isSelected());
        });
        String warningMessage = "\n" + TRANSLATOR.getTranslation("XPath_functions_enabling_warning");
        this.enableXPathFunctionsCheckBox.addActionListener(event -> {
            JCheckBox cb = (JCheckBox)event.getSource();
            if (cb.isSelected()) {
                PluginWorkspaceProvider.getPluginWorkspace().showWarningMessage(warningMessage);
            }
            this.cacheFunctionsReponseCheckBox.setEnabled(cb.isSelected());
            this.cacheSizeSpinner.setEnabled(cb.isSelected());
            this.cacheSizeLabel.setEnabled(cb.isSelected());
            this.notifyAboutRequestsNumberCheckBox.setEnabled(cb.isSelected());
            this.requestsNumberToNotifySpinner.setEnabled(cb.isSelected());
        });
    }

    public void apply(PluginWorkspace pluginWorkspace) {
        if (DataDeletionManager.getInstance().wasDataDeleted()) {
            return;
        }
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        if (optionsStorage != null) {
            optionsStorage.setOption("oxygen.positron.plugin.enable.xpath.functions", String.valueOf(this.enableXPathFunctionsCheckBox.isSelected()));
            optionsStorage.setOption("oxygen.positron.plugin.cache.functions.response", String.valueOf(this.cacheFunctionsReponseCheckBox.isSelected()));
            optionsStorage.setOption("oxygen.positron.plugin.functions.cache.size", String.valueOf(this.cacheSizeSpinner.getValue()));
            optionsStorage.setOption("oxygen.positron.plugin.notify.about.requests.number", String.valueOf(this.notifyAboutRequestsNumberCheckBox.isSelected()));
            optionsStorage.setOption("oxygen.positron.plugin.requests.number.to.notify", String.valueOf(this.requestsNumberToNotifySpinner.getValue()));
            try {
                FunctionsPromptToResponsePO.setMaxCacheSize(NumberParserUtil.parseInt((String)this.cacheSizeSpinner.getValue().toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void loadPageState(PluginWorkspace pluginWorkspace) {
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        if (optionsStorage != null) {
            boolean enableFunctions = Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.enable.xpath.functions", String.valueOf(Boolean.TRUE)));
            this.enableXPathFunctionsCheckBox.setSelected(enableFunctions);
            this.cacheFunctionsReponseCheckBox.setSelected(Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.cache.functions.response", String.valueOf(Boolean.TRUE))));
            try {
                this.cacheSizeSpinner.setValue(NumberParserUtil.parseInt((String)optionsStorage.getOption("oxygen.positron.plugin.functions.cache.size", "500")));
                this.requestsNumberToNotifySpinner.setValue(NumberParserUtil.parseInt((String)optionsStorage.getOption("oxygen.positron.plugin.requests.number.to.notify", "100")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.notifyAboutRequestsNumberCheckBox.setSelected(Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.notify.about.requests.number", String.valueOf(Boolean.TRUE))));
            this.cacheFunctionsReponseCheckBox.setEnabled(enableFunctions);
            this.cacheSizeSpinner.setEnabled(enableFunctions);
            this.cacheSizeLabel.setEnabled(enableFunctions);
            this.notifyAboutRequestsNumberCheckBox.setEnabled(enableFunctions);
            this.requestsNumberToNotifySpinner.setEnabled(enableFunctions);
        }
    }

    public void restoreDefaults() {
        this.enableXPathFunctionsCheckBox.setSelected(true);
        this.cacheFunctionsReponseCheckBox.setEnabled(true);
        this.cacheFunctionsReponseCheckBox.setSelected(true);
        try {
            this.cacheSizeSpinner.setEnabled(true);
            this.cacheSizeSpinner.setValue(NumberParserUtil.parseInt((String)"500"));
            this.requestsNumberToNotifySpinner.setEnabled(true);
            this.requestsNumberToNotifySpinner.setValue(NumberParserUtil.parseInt((String)"100"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.notifyAboutRequestsNumberCheckBox.setEnabled(true);
        this.notifyAboutRequestsNumberCheckBox.setSelected(true);
    }

    public String[] getProjectLevelOptionKeys() {
        return new String[]{"oxygen.positron.plugin.enable.xpath.functions", "oxygen.positron.plugin.cache.functions.response", "oxygen.positron.plugin.functions.cache.size", "oxygen.positron.plugin.notify.about.requests.number"};
    }

    public String getTitle() {
        return Translator.getInstance().getTranslation("XPath_Functions");
    }

    public String getKey() {
        return "xpath_functions_preferences_page";
    }

    public String getHelpPageURL() {
        return "https://www.oxygenxml.com/doc/ug-positron-desktop/ai/xpath_preferences.html";
    }
}

