/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.preferences;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.core.filter.SensitiveContentFilter;
import com.oxygenxml.positron.core.filter.SensitiveContentPattern;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.mcp.ObjectMapperUtil;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.OKCancelDialog;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class TestAllPatternsDialog
extends OKCancelDialog {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private final JTextArea originalTextArea = OxygenUIComponentsFactory.createTextArea(null);
    private final JTextArea filteredTextArea = OxygenUIComponentsFactory.createTextArea(null);
    private static final int WIDTH = 700;
    private static final int HEIGHT = 500;
    private final SensitiveContentFilter patternsFilter;

    public TestAllPatternsDialog(List<SensitiveContentPattern> userPatterns, boolean includeDefaultPatterns) {
        super((JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame(), TRANSLATOR.getTranslation("Test_Sensitive_Data_Masking_Title"), true);
        JFrame parentFrame;
        ObjectMapper mapper = ObjectMapperUtil.createObjectMapperNoFailUnknownProps();
        this.patternsFilter = new SensitiveContentFilter(() -> {
            try {
                return mapper.writeValueAsString((Object)userPatterns);
            }
            catch (JsonProcessingException e) {
                return "[]";
            }
        }, () -> includeDefaultPatterns);
        this.setOkButtonText(TRANSLATOR.getTranslation("Close"));
        this.getCancelButton().setVisible(false);
        this.setMinimumSize(new Dimension(525, 500));
        this.setPreferredSize(new Dimension(700, 500));
        this.setResizable(true);
        this.filteredTextArea.setEditable(false);
        this.getContentPane().add(this.createGUIPanel());
        this.pack();
        this.originalTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TestAllPatternsDialog.this.updateFilteredText();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TestAllPatternsDialog.this.updateFilteredText();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TestAllPatternsDialog.this.updateFilteredText();
            }
        });
        JFrame jFrame = parentFrame = PluginWorkspaceProvider.getPluginWorkspace() != null ? (JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame() : null;
        if (parentFrame != null) {
            this.setIconImage(parentFrame.getIconImage());
            this.setLocationRelativeTo(parentFrame);
        }
        this.setDefaultCloseOperation(2);
    }

    private JPanel createGUIPanel() {
        JPanel guiPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = UIUtil.getSpacingInsets();
        guiPanel.add((Component)new JLabel(TRANSLATOR.getTranslation("Original_Text")), gbc);
        ++gbc.gridy;
        gbc.weighty = 0.5;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, 3, 5);
        this.originalTextArea.setRows(8);
        this.originalTextArea.setLineWrap(true);
        this.originalTextArea.setWrapStyleWord(true);
        JScrollPane originalScrollPane = OxygenUIComponentsFactory.createScrollPane((Component)this.originalTextArea, (int)20, (int)31);
        originalScrollPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        guiPanel.add((Component)originalScrollPane, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 3, 5);
        guiPanel.add((Component)new JLabel(TRANSLATOR.getTranslation("Filtered_Text")), gbc);
        ++gbc.gridy;
        gbc.weighty = 0.5;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 5, 0, 5);
        this.filteredTextArea.setRows(8);
        this.filteredTextArea.setLineWrap(true);
        this.filteredTextArea.setWrapStyleWord(true);
        JScrollPane filteredScrollPane = OxygenUIComponentsFactory.createScrollPane((Component)this.filteredTextArea, (int)20, (int)31);
        filteredScrollPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        guiPanel.add((Component)filteredScrollPane, gbc);
        return guiPanel;
    }

    private void updateFilteredText() {
        String originalText = this.originalTextArea.getText();
        if (originalText == null || originalText.trim().isEmpty()) {
            this.filteredTextArea.setText("");
            return;
        }
        String filteredText = this.patternsFilter.maskText(originalText);
        this.patternsFilter.clearMappings();
        this.filteredTextArea.setText(filteredText);
        this.filteredTextArea.setCaretPosition(0);
    }
}

