/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.preferences;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.core.filter.SensitiveContentPattern;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.preferences.AddOrEditPatternDialog;
import com.oxygenxml.positron.plugin.preferences.DataDeletionManager;
import com.oxygenxml.positron.plugin.preferences.DeleteAllDataAction;
import com.oxygenxml.positron.plugin.preferences.TestAllPatternsDialog;
import com.oxygenxml.positron.plugin.ui.LinkLabel;
import com.oxygenxml.positron.plugin.ui.MultilineLabel;
import com.oxygenxml.positron.plugin.ui.SectionPane;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.plugin.option.OptionPagePluginExtension;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class PrivacyPreferencePage
extends OptionPagePluginExtension {
    private static final Logger log = LoggerFactory.getLogger(PrivacyPreferencePage.class);
    private static final Translator TRANSLATOR = Translator.getInstance();
    private JTable patternsTable;
    private PatternsTableModel patternsTableModel;
    private JButton editButton;
    private JButton deleteButton;
    private JButton testAllPatternsButton;
    private JCheckBox enableDefaultPatternsCheckbox;
    private static final int PATTERN_COLUMN_INDEX = 0;

    public JComponent init(final PluginWorkspace pluginWorkspace) {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.enableDefaultPatternsCheckbox = new JCheckBox(TRANSLATOR.getTranslation("Enable_Default_Sensitive_Patterns")){

            @Override
            public JToolTip createToolTip() {
                return OxygenUIComponentsFactory.installMultilineTooltip((JComponent)this);
            }
        };
        this.enableDefaultPatternsCheckbox.setToolTipText(TRANSLATOR.getTranslation("Enable_Default_Sensitive_Patterns_Tooltip"));
        this.enableDefaultPatternsCheckbox.addActionListener(e -> this.updateButtonStates());
        mainPanel.add((Component)this.enableDefaultPatternsCheckbox, gbc);
        ++gbc.gridy;
        gbc.insets.left += new JCheckBox().getPreferredSize().width;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        MultilineLabel builtInMaskingDescription = new MultilineLabel(TRANSLATOR.getTranslation("Built_in_Data_Masking_Description"));
        mainPanel.add((Component)builtInMaskingDescription, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        JPanel labelAndInfoPanel = new JPanel(new FlowLayout(0, 0, 0));
        JLabel additionalPatternsLabel = new JLabel(TRANSLATOR.getTranslation("Additional_data_masking_patterns_description"));
        labelAndInfoPanel.add(additionalPatternsLabel);
        final String additionalPatternsInfoText = TRANSLATOR.getTranslation("Additional_data_masking_patterns_info");
        JButton additionalPatternsInfoButton = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction("", IconsLoader.loadIcon("/images/Info12.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                pluginWorkspace.showInformationMessage(additionalPatternsInfoText);
            }
        }, (boolean)false);
        additionalPatternsInfoButton.setToolTipText(additionalPatternsInfoText);
        additionalPatternsInfoButton.setMargin(new Insets(3, 3, 3, 3));
        labelAndInfoPanel.add(additionalPatternsInfoButton);
        mainPanel.add((Component)labelAndInfoPanel, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 0, 0, 0);
        this.patternsTableModel = new PatternsTableModel();
        this.patternsTable = OxygenUIComponentsFactory.createTable((TableModel)this.patternsTableModel);
        this.patternsTable.setFillsViewportHeight(true);
        this.patternsTable.setSelectionMode(0);
        this.patternsTable.getTableHeader().setReorderingAllowed(false);
        this.patternsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PrivacyPreferencePage.this.editPattern();
                }
            }
        });
        this.patternsTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PrivacyPreferencePage.this.editPattern();
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.patternsTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateButtonStates();
            }
        });
        this.patternsTableModel.addTableModelListener(e -> this.updateButtonStates());
        JScrollPane scrollPane = OxygenUIComponentsFactory.createScrollPane((Component)this.patternsTable, (int)20, (int)30);
        scrollPane.setPreferredSize(new Dimension(scrollPane.getPreferredSize().width, 50));
        mainPanel.add((Component)scrollPane, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        JPanel buttonsPanel = this.createButtonsPanel();
        mainPanel.add((Component)buttonsPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 0);
        JPanel testAllPatternsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbctestAllPatternsPanel = new GridBagConstraints();
        gbctestAllPatternsPanel.gridx = 0;
        gbctestAllPatternsPanel.gridy = 0;
        gbctestAllPatternsPanel.anchor = 17;
        gbctestAllPatternsPanel.insets = new Insets(0, 0, 0, 0);
        JLabel testAllPatternsLabel = new JLabel(TRANSLATOR.getTranslation("Test_Sensitive_Data_Masking_Description") + ":");
        testAllPatternsPanel.add((Component)testAllPatternsLabel, gbctestAllPatternsPanel);
        gbctestAllPatternsPanel.gridx = 0;
        gbctestAllPatternsPanel.gridy = 1;
        gbctestAllPatternsPanel.insets = new Insets(5, 0, 0, 0);
        AbstractAction testAllPatternsAction = new AbstractAction(TRANSLATOR.getTranslation("Test_Sensitive_Data_Masking") + "..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                new TestAllPatternsDialog(PrivacyPreferencePage.this.patternsTableModel.getPatterns(), PrivacyPreferencePage.this.enableDefaultPatternsCheckbox.isSelected()).setVisible(true);
            }
        };
        this.testAllPatternsButton = OxygenUIComponentsFactory.createButton((Action)testAllPatternsAction);
        this.testAllPatternsButton.setEnabled(false);
        testAllPatternsPanel.add((Component)this.testAllPatternsButton, gbctestAllPatternsPanel);
        mainPanel.add((Component)testAllPatternsPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        mainPanel.add((Component)new SectionPane(TRANSLATOR.getTranslation("Your_Data"), true), gbc);
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 0, 0, 0);
        JPanel userDataPanel = this.createUserDataManagementPanel();
        mainPanel.add((Component)userDataPanel, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.insets = new Insets(25, 0, 0, 0);
        JPanel aiIgnoreInfoPanel = this.createAiIgnoreInfoPanel();
        mainPanel.add((Component)aiIgnoreInfoPanel, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(5, 0, 0, 0);
        JPanel toolsRagInfoPanel = this.createToolsRagInfoPanel();
        mainPanel.add((Component)toolsRagInfoPanel, gbc);
        this.loadPatterns();
        this.updateButtonStates();
        return mainPanel;
    }

    private JPanel createAiIgnoreInfoPanel() {
        JPanel infoPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 0, 0, 3);
        JLabel infoIcon = new JLabel(IconsLoader.loadIcon("/images/LicenseInfo16.png"));
        infoPanel.add((Component)infoIcon, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        MultilineLabel infoLabel = new MultilineLabel(TRANSLATOR.getTranslation("AI_Ignore_Files_Info") + " ");
        infoPanel.add((Component)infoLabel, gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        JLabel linkLabel = UIUtil.createLinkLabel("https://www.oxygenxml.com/doc/ug-positron-desktop/ai/functionality_features.html#functionality_features__section_ukv_f5h_1fc", TRANSLATOR.getTranslation("Read_more"));
        infoPanel.add((Component)linkLabel, gbc);
        return infoPanel;
    }

    private JPanel createUserDataManagementPanel() {
        JPanel dataPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        JPanel labelPanel = new JPanel(new FlowLayout(0, 0, 0));
        JLabel infoLabel = new JLabel(TRANSLATOR.getTranslation("Your_Data_Info_Short"));
        labelPanel.add(infoLabel);
        JButton infoButton = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction("", IconsLoader.loadIcon("/images/Info12.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginWorkspaceProvider.getPluginWorkspace().showInformationMessage(TRANSLATOR.getTranslation("Your_Data_Info_Detailed"));
            }
        }, (boolean)false);
        infoButton.setToolTipText(TRANSLATOR.getTranslation("More_details"));
        infoButton.setMargin(new Insets(3, 3, 3, 3));
        labelPanel.add(infoButton);
        dataPanel.add((Component)labelPanel, gbc);
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 0, 0, 0);
        DeleteAllDataAction deleteAllDataAction = new DeleteAllDataAction(() -> {
            this.patternsTableModel.clearPatterns();
            this.enableDefaultPatternsCheckbox.setSelected(true);
        });
        JButton deleteAllDataButton = OxygenUIComponentsFactory.createButton((Action)deleteAllDataAction);
        dataPanel.add((Component)deleteAllDataButton, gbc);
        return dataPanel;
    }

    private JPanel createToolsRagInfoPanel() {
        JPanel infoPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 0, 0, 3);
        JLabel infoIcon = new JLabel(IconsLoader.loadIcon("/images/LicenseInfo16.png"));
        infoPanel.add((Component)infoIcon, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        MultilineLabel toolsRagLabel = new MultilineLabel(TRANSLATOR.getTranslation("Tools_RAG_Preferences_Info"));
        infoPanel.add((Component)toolsRagLabel, gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        LinkLabel toolsRagLink = new LinkLabel(TRANSLATOR.getTranslation("Go_To_Tools_RAG")){

            @Override
            public void performAction() {
                PluginWorkspaceProvider.getPluginWorkspace().showPreferencesPages(null, "Positron_addon_rag_config_page", true);
            }
        };
        infoPanel.add((Component)toolsRagLink, gbc);
        return infoPanel;
    }

    private JPanel createButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        buttonsPanel.add((Component)new JPanel(), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 0, 0, 3);
        JButton addButton = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction(TRANSLATOR.getTranslation("Add"), IconsLoader.loadIcon("/images/Add16.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrivacyPreferencePage.this.addPattern();
            }
        }, (boolean)false);
        buttonsPanel.add((Component)addButton, gbc);
        ++gbc.gridx;
        this.editButton = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction(TRANSLATOR.getTranslation("Edit"), IconsLoader.loadIcon("/images/Wrench16.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrivacyPreferencePage.this.editPattern();
            }
        }, (boolean)false);
        this.editButton.setEnabled(false);
        buttonsPanel.add((Component)this.editButton, gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.deleteButton = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction(TRANSLATOR.getTranslation("Delete"), IconsLoader.loadIcon("/images/Remove16.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrivacyPreferencePage.this.deletePattern();
            }
        }, (boolean)false);
        this.deleteButton.setEnabled(false);
        buttonsPanel.add((Component)this.deleteButton, gbc);
        return buttonsPanel;
    }

    private void updateButtonStates() {
        int selectedRow = this.patternsTable.getSelectedRow();
        boolean hasSelection = selectedRow >= 0;
        boolean hasPatterns = this.patternsTableModel.getRowCount() > 0;
        this.editButton.setEnabled(hasSelection);
        this.deleteButton.setEnabled(hasSelection);
        this.testAllPatternsButton.setEnabled(hasPatterns || this.enableDefaultPatternsCheckbox.isSelected());
    }

    private void addPattern() {
        AddOrEditPatternDialog dialog = new AddOrEditPatternDialog(true, null, this.patternsTableModel.getPatterns());
        SensitiveContentPattern pattern = dialog.getPattern();
        if (pattern != null) {
            this.patternsTableModel.addPattern(pattern);
        }
    }

    private void editPattern() {
        SensitiveContentPattern currentPattern;
        AddOrEditPatternDialog dialog;
        SensitiveContentPattern newPattern;
        int selectedRow = this.patternsTable.getSelectedRow();
        if (selectedRow >= 0 && (newPattern = (dialog = new AddOrEditPatternDialog(false, currentPattern = this.patternsTableModel.getPattern(selectedRow), this.patternsTableModel.getPatterns())).getPattern()) != null) {
            this.patternsTableModel.updatePattern(selectedRow, newPattern);
        }
    }

    private void deletePattern() {
        int selectedRow = this.patternsTable.getSelectedRow();
        if (selectedRow >= 0) {
            this.patternsTableModel.deletePattern(selectedRow);
        }
    }

    private void loadPatterns() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        if (optionsStorage != null) {
            boolean enableDefaultPatterns = optionsStorage.getOption("oxygen.positron.plugin.enable.default.sensitive.patterns", "true").equalsIgnoreCase("true");
            this.enableDefaultPatternsCheckbox.setSelected(enableDefaultPatterns);
            String patternsJson = optionsStorage.getOption("oxygen.positron.plugin.sensitive.content.patterns", "");
            if (!patternsJson.isEmpty()) {
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    List patterns = (List)objectMapper.readValue(patternsJson, (TypeReference)new TypeReference<List<SensitiveContentPattern>>(){});
                    if (patterns != null) {
                        for (SensitiveContentPattern pattern : patterns) {
                            if (pattern == null || pattern.getPattern() == null || pattern.getPattern().trim().isEmpty()) continue;
                            this.patternsTableModel.addPattern(pattern);
                        }
                    }
                }
                catch (JsonProcessingException e) {
                    log.debug("Error loading patterns", (Throwable)e);
                }
            }
        }
    }

    public void apply(PluginWorkspace pluginWorkspace) {
        if (DataDeletionManager.getInstance().wasDataDeleted()) {
            return;
        }
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        if (optionsStorage != null) {
            try {
                optionsStorage.setOption("oxygen.positron.plugin.enable.default.sensitive.patterns", String.valueOf(this.enableDefaultPatternsCheckbox.isSelected()));
                List<SensitiveContentPattern> patterns = this.patternsTableModel.getPatterns();
                ObjectMapper objectMapper = new ObjectMapper();
                String patternsJson = objectMapper.writeValueAsString(patterns);
                optionsStorage.setOption("oxygen.positron.plugin.sensitive.content.patterns", patternsJson);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
    }

    public void restoreDefaults() {
        this.patternsTableModel.clearPatterns();
        this.enableDefaultPatternsCheckbox.setSelected(true);
    }

    public String getTitle() {
        return TRANSLATOR.getTranslation("Privacy");
    }

    public String getKey() {
        return "Positron_addon_privacy_page";
    }

    public String[] getProjectLevelOptionKeys() {
        return new String[]{"oxygen.positron.plugin.sensitive.content.patterns"};
    }

    private static class PatternsTableModel
    extends AbstractTableModel {
        private final List<SensitiveContentPattern> patterns = new ArrayList<SensitiveContentPattern>();

        private PatternsTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.patterns.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            return TRANSLATOR.getTranslation(column == 0 ? "Pattern" : "Placeholder_Text");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SensitiveContentPattern pattern = this.patterns.get(rowIndex);
            return columnIndex == 0 ? pattern.getPattern() : pattern.getPlaceholderText();
        }

        public void addPattern(SensitiveContentPattern pattern) {
            this.patterns.add(pattern);
            this.fireTableRowsInserted(this.patterns.size() - 1, this.patterns.size() - 1);
        }

        public void updatePattern(int index, SensitiveContentPattern pattern) {
            this.patterns.set(index, pattern);
            this.fireTableRowsUpdated(index, index);
        }

        public void deletePattern(int index) {
            this.patterns.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        public void clearPatterns() {
            int size = this.patterns.size();
            if (size > 0) {
                this.patterns.clear();
                this.fireTableRowsDeleted(0, size - 1);
            }
        }

        public SensitiveContentPattern getPattern(int index) {
            return this.patterns.get(index);
        }

        public List<SensitiveContentPattern> getPatterns() {
            return new ArrayList<SensitiveContentPattern>(this.patterns);
        }
    }
}

