/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.preferences;

import com.oxygenxml.positron.actions.dialog.internal.DialogType;
import com.oxygenxml.positron.actions.dialog.internal.MessageDialogBuilder;
import com.oxygenxml.positron.api.connector.dto.Pair;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.preferences.KeyValueTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.Button;
import ro.sync.exml.workspace.api.standalone.ui.OKCancelDialog;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class KeyValueTablePanel
extends JPanel {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private static final int KEY_COLUMN_WIDTH = 150;
    private JButton editButton;
    private JButton addButton;
    private JButton deleteButton;
    private KeyValueTableModel model;
    private JTable table;

    public KeyValueTablePanel(List<Pair<String, String>> initialItems) {
        super(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 5, 0);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        JTable itemsTable = this.createTable(initialItems);
        JScrollPane tableScrollPane = new JScrollPane(itemsTable);
        this.add((Component)tableScrollPane, constraints);
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        this.add((Component)this.createButtonsPanel(), constraints);
    }

    public KeyValueTableModel getModel() {
        return this.model;
    }

    private JTable createTable(List<Pair<String, String>> initialItems) {
        this.model = new KeyValueTableModel();
        this.table = OxygenUIComponentsFactory.createTable((TableModel)this.model);
        this.model.setItems(initialItems);
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().setVisible(true);
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                boolean tableHasSelection = this.table.getSelectedRowCount() > 0;
                this.editButton.setEnabled(tableHasSelection && this.table.isEnabled());
                this.deleteButton.setEnabled(tableHasSelection && this.table.isEnabled());
            }
        });
        TableColumn statusCol = this.table.getColumnModel().getColumn(0);
        statusCol.setMinWidth(150);
        statusCol.setPreferredWidth(150);
        statusCol.setMaxWidth(150);
        return this.table;
    }

    private JPanel createButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 13;
        constraints.insets = new Insets(0, 5, 0, 0);
        constraints.weighty = 0.0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        buttonsPanel.add((Component)new JPanel(), constraints);
        constraints.weightx = 0.0;
        ++constraints.gridx;
        constraints.fill = 0;
        buttonsPanel.add((Component)this.createAddButton(), constraints);
        ++constraints.gridx;
        buttonsPanel.add((Component)this.createEditButton(), constraints);
        ++constraints.gridx;
        buttonsPanel.add((Component)this.createDeleteButton(), constraints);
        return buttonsPanel;
    }

    private JButton createAddButton() {
        this.addButton = new Button((Action)new AbstractAction(TRANSLATOR.getTranslation("Add") + "..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddOrEditItemDialog dialog = new AddOrEditItemDialog(true, null, null);
                if (dialog.getResult() == 1) {
                    String key = dialog.getKey();
                    String value = dialog.getValue();
                    boolean itemAlreadyExist = KeyValueTablePanel.this.model.hasKey(key);
                    if (itemAlreadyExist) {
                        KeyValueTablePanel.this.model.editItem(key, key, value);
                    } else {
                        KeyValueTablePanel.this.model.addItem(dialog.getKey(), dialog.getValue());
                    }
                }
            }
        });
        return this.addButton;
    }

    private JButton createEditButton() {
        this.editButton = new Button(new AbstractAction(TRANSLATOR.getTranslation("Edit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddOrEditItemDialog dialog;
                int selectedRow = KeyValueTablePanel.this.table.getSelectedRow();
                if (selectedRow >= 0 && (dialog = new AddOrEditItemDialog(false, (String)KeyValueTablePanel.this.model.getValueAt(selectedRow, 0), (String)KeyValueTablePanel.this.model.getValueAt(selectedRow, 1))).getResult() == 1) {
                    KeyValueTablePanel.this.model.editItem(selectedRow, dialog.getKey(), dialog.getValue());
                }
            }
        }){

            public void setEnabled(boolean newValue) {
                if (newValue) {
                    newValue = KeyValueTablePanel.this.table.getSelectedRow() != -1;
                }
                super.setEnabled(newValue);
            }
        };
        this.editButton.setEnabled(false);
        return this.editButton;
    }

    private JButton createDeleteButton() {
        this.deleteButton = new Button(new AbstractAction(TRANSLATOR.getTranslation("Delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = KeyValueTablePanel.this.table.getSelectedRow();
                if (selectedRow >= 0) {
                    String key = (String)KeyValueTablePanel.this.model.getValueAt(selectedRow, 0);
                    int answer = new MessageDialogBuilder(TRANSLATOR.getTranslation("Delete_Item"), DialogType.QUESTION).setQuestionMessage(MessageFormat.format(TRANSLATOR.getTranslation("Delete_Item_Message"), key)).setOkButtonName(TRANSLATOR.getTranslation("Yes")).setCancelButtonName(TRANSLATOR.getTranslation("No")).buildAndShow().getResult();
                    if (1 == answer) {
                        KeyValueTablePanel.this.model.deleteItem(selectedRow);
                        KeyValueTablePanel.this.addButton.requestFocus();
                    }
                }
            }
        }){

            public void setEnabled(boolean newValue) {
                if (newValue) {
                    newValue = KeyValueTablePanel.this.table.getSelectedRow() != -1;
                }
                super.setEnabled(newValue);
            }
        };
        this.deleteButton.setEnabled(false);
        return this.deleteButton;
    }

    public List<Pair<String, String>> getItems() {
        return this.model.getItems();
    }

    private class CoalescingDocumentListener
    implements DocumentListener {
        private static final int DELAY = 400;
        private CoalescedEventUpdater updater;

        public CoalescingDocumentListener(Runnable runnable) {
            this.updater = new CoalescedEventUpdater(400, runnable);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            this.updater.update();
        }

        public class CoalescedEventUpdater {
            private Timer timer;

            public CoalescedEventUpdater(int delay, Runnable callback) {
                this.timer = new Timer(delay, e -> {
                    this.timer.stop();
                    callback.run();
                });
            }

            public void update() {
                this.timer.restart();
            }
        }
    }

    private class AddOrEditItemDialog
    extends OKCancelDialog {
        private final JTextField keyTF;
        private final JTextField valueTF;
        private static final int WIDTH = 350;
        private static final int HEIGHT = 170;
        private final String oldKey;
        private final String oldValue;

        public AddOrEditItemDialog(boolean isAddDialog, String key, String value) {
            JFrame parentFrame;
            super((JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame(), TRANSLATOR.getTranslation(isAddDialog ? "Add_Item" : "Edit_Item"), true);
            this.keyTF = OxygenUIComponentsFactory.createTextField();
            this.valueTF = OxygenUIComponentsFactory.createTextField();
            if (isAddDialog) {
                this.setOkButtonText(TRANSLATOR.getTranslation("Add"));
            }
            this.oldKey = key;
            this.oldValue = value;
            if (key != null) {
                this.keyTF.setText(key);
                this.keyTF.setCaretPosition(0);
                this.keyTF.setEditable(false);
            }
            if (value != null) {
                this.valueTF.setText(value);
                this.valueTF.setCaretPosition(0);
                this.valueTF.selectAll();
            }
            this.getOkButton().setEnabled(key != null && value != null);
            this.setMinimumSize(new Dimension(262, 170));
            this.setPreferredSize(new Dimension(350, 170));
            this.setResizable(true);
            this.getContentPane().add(this.createGUIPanel());
            this.pack();
            CoalescingDocumentListener updateOkButtonListener = new CoalescingDocumentListener(() -> this.getOkButton().setEnabled(this.valueTF.getText() != null && !this.valueTF.getText().isEmpty() && this.keyTF.getText() != null && !this.keyTF.getText().isEmpty()));
            this.keyTF.getDocument().addDocumentListener(updateOkButtonListener);
            this.valueTF.getDocument().addDocumentListener(updateOkButtonListener);
            JFrame jFrame = parentFrame = PluginWorkspaceProvider.getPluginWorkspace() != null ? (JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame() : null;
            if (parentFrame != null) {
                this.setIconImage(parentFrame.getIconImage());
                this.setLocationRelativeTo(parentFrame);
            }
            this.setDefaultCloseOperation(2);
            this.setResizable(true);
            this.setVisible(true);
        }

        private JPanel createGUIPanel() {
            JPanel guiPanel = new JPanel(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.anchor = 17;
            constraints.insets = new Insets(0, 0, 5, 5);
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            guiPanel.add((Component)new JLabel(TRANSLATOR.getTranslation("Name") + ":"), constraints);
            ++constraints.gridx;
            constraints.weightx = 1.0;
            constraints.insets = new Insets(0, 0, 5, 0);
            constraints.fill = 2;
            guiPanel.add((Component)this.keyTF, constraints);
            constraints.gridx = 0;
            constraints.insets = new Insets(0, 0, 0, 5);
            ++constraints.gridy;
            constraints.fill = 0;
            constraints.weightx = 0.0;
            guiPanel.add((Component)new JLabel(TRANSLATOR.getTranslation("Value") + ":"), constraints);
            ++constraints.gridx;
            constraints.weightx = 1.0;
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.fill = 2;
            guiPanel.add((Component)this.valueTF, constraints);
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.gridwidth = 3;
            constraints.gridheight = 3;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            guiPanel.add((Component)new JPanel(), constraints);
            return guiPanel;
        }

        public String getKey() {
            return this.keyTF.getText();
        }

        public String getValue() {
            return this.valueTF.getText();
        }

        protected void doOK() {
            if (this.oldKey == null || this.oldValue == null) {
                if (KeyValueTablePanel.this.model.hasKey(this.keyTF.getText())) {
                    int answer = new MessageDialogBuilder(TRANSLATOR.getTranslation("Add_Item"), DialogType.WARNING).setQuestionMessage(MessageFormat.format(TRANSLATOR.getTranslation("Replace_Item_Message"), this.keyTF.getText())).setOkButtonName(TRANSLATOR.getTranslation("Yes")).setCancelButtonName(TRANSLATOR.getTranslation("No")).buildAndShow().getResult();
                    if (1 == answer) {
                        super.doOK();
                    }
                } else {
                    super.doOK();
                }
            } else if (!this.oldValue.equals(this.valueTF.getText())) {
                super.doOK();
            } else {
                super.doCancel();
            }
        }
    }
}

