/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.preferences;

import com.oxygenxml.positron.api.connector.dto.Pair;
import com.oxygenxml.positron.core.plugin.Translator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

final class KeyValueTableModel
extends AbstractTableModel {
    public static final int KEY_COLUMN = 0;
    public static final int VALUE_COLUMN = 1;
    public static final int NO_OF_COLUMNS = 2;
    private static final String[] COLUMNS_NAMES = new String[]{Translator.getInstance().getTranslation("Name"), Translator.getInstance().getTranslation("Value")};
    private final List<Pair<String, String>> items = new ArrayList<Pair<String, String>>();

    KeyValueTableModel() {
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this.items.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object temp = null;
        switch (columnIndex) {
            case 0: {
                temp = this.items.get(rowIndex).getFirst();
                break;
            }
            case 1: {
                temp = this.items.get(rowIndex).getSecond();
                break;
            }
        }
        return temp;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class<String> clazz = null;
        switch (columnIndex) {
            case 0: 
            case 1: {
                clazz = String.class;
                break;
            }
        }
        return clazz;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNS_NAMES[columnIndex];
    }

    public void clear() {
        int size = this.items.size();
        this.items.clear();
        this.fireTableRowsDeleted(0, Math.max(0, size - 1));
    }

    public void setItems(List<Pair<String, String>> newItems) {
        this.clear();
        this.items.addAll(newItems);
        this.fireTableRowsDeleted(0, Math.max(0, this.items.size() - 1));
    }

    public void editItem(int index, String newKey, String newValue) {
        this.items.set(index, (Pair<String, String>)new Pair((Object)newKey, (Object)newValue));
        this.fireTableRowsUpdated(index, index);
    }

    public void editItem(String oldKey, String newKey, String newValue) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((String)this.items.get(i).getFirst()).equals(oldKey)) continue;
            this.editItem(i, newKey, newValue);
            break;
        }
    }

    public void deleteItem(int index) {
        this.items.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void addItem(String key, String value) {
        this.items.add((Pair<String, String>)new Pair((Object)key, (Object)value));
        this.fireTableRowsInserted(this.items.size() - 1, this.items.size() - 1);
    }

    public boolean hasKey(String key) {
        return this.items.stream().anyMatch(item -> ((String)item.getFirst()).equals(key));
    }

    public List<Pair<String, String>> getItems() {
        return this.items;
    }
}

