/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.preferences;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.ui.MultilineLabel;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.OKCancelDialog;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class DeleteAllDataConfirmDialog
extends OKCancelDialog {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private final JCheckBox confirmationCheckBox;
    private final Map<String, String> referencedFiles;
    private final JCheckBox deleteFilesCheckbox;
    private JTextArea filesArea;

    public DeleteAllDataConfirmDialog(Map<String, String> referencedFiles) {
        super((JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame(), TRANSLATOR.getTranslation("Delete_All_Data_Dialog_Title"), true);
        this.referencedFiles = referencedFiles;
        this.confirmationCheckBox = new JCheckBox(TRANSLATOR.getTranslation("Delete_All_Data_Confirmation_Checkbox"));
        this.deleteFilesCheckbox = new JCheckBox(TRANSLATOR.getTranslation("Delete_All_Data_Also_Delete_Files"));
        this.setOkButtonText(TRANSLATOR.getTranslation("Delete_All_Data"));
        this.getOkButton().setEnabled(false);
        this.confirmationCheckBox.addActionListener(e -> this.updateOkButtonState());
        this.deleteFilesCheckbox.addActionListener(e -> this.updateFilesAreaState());
        this.setMinimumSize(new Dimension(450, referencedFiles.isEmpty() ? 280 : 450));
        this.setPreferredSize(new Dimension(500, referencedFiles.isEmpty() ? 300 : 500));
        this.setResizable(true);
        this.getContentPane().add(this.createGUIPanel());
        this.pack();
        JFrame parentFrame = (JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame();
        if (parentFrame != null) {
            this.setIconImage(parentFrame.getIconImage());
            this.setLocationRelativeTo(parentFrame);
        }
    }

    public boolean shouldDeleteFiles() {
        return this.deleteFilesCheckbox != null && this.deleteFilesCheckbox.isSelected();
    }

    private JPanel createGUIPanel() {
        JPanel guiPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(5, 5, 3, 3);
        JLabel warningIcon = new JLabel(IconsLoader.loadIcon("/images/Warning16.png"));
        guiPanel.add((Component)warningIcon, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 3, 3, 5);
        JLabel warningLabel = new JLabel("<html><b>" + TRANSLATOR.getTranslation("Delete_All_Data_Warning") + "</b></html>");
        guiPanel.add((Component)warningLabel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(5, 5, 3, 5);
        JLabel descriptionLabel = new JLabel(TRANSLATOR.getTranslation("Delete_All_Data_Description"));
        guiPanel.add((Component)descriptionLabel, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(3, 10, 3, 5);
        MultilineLabel summaryLabel1 = new MultilineLabel(TRANSLATOR.getTranslation("Delete_All_Data_Summary_Item1"));
        guiPanel.add((Component)summaryLabel1, gbc);
        ++gbc.gridy;
        MultilineLabel summaryLabel2 = new MultilineLabel(TRANSLATOR.getTranslation("Delete_All_Data_Summary_Item2"));
        guiPanel.add((Component)summaryLabel2, gbc);
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.anchor = 18;
        JPanel deteleAllDataNote = this.createLabelWithPrefixPanel(false, TRANSLATOR.getTranslation("Delete_All_Data_Project_Settings_Note"));
        guiPanel.add((Component)deteleAllDataNote, gbc);
        if (!this.referencedFiles.isEmpty()) {
            ++gbc.gridy;
            gbc.insets = new Insets(10, 5, 3, 5);
            JLabel filesSectionLabel = new JLabel("<html><b>" + TRANSLATOR.getTranslation("Delete_All_Data_Files_Section_Title") + "</b></html>");
            guiPanel.add((Component)filesSectionLabel, gbc);
            ++gbc.gridy;
            gbc.insets = new Insets(5, 5, 3, 5);
            this.deleteFilesCheckbox.setSelected(false);
            guiPanel.add((Component)this.deleteFilesCheckbox, gbc);
            ++gbc.gridy;
            gbc.anchor = 18;
            gbc.insets = new Insets(3, 15, 3, 5);
            JPanel deleteAllDataFilesWarningPanel = this.createLabelWithPrefixPanel(true, TRANSLATOR.getTranslation("Delete_All_Data_Files_Warning"));
            guiPanel.add((Component)deleteAllDataFilesWarningPanel, gbc);
            deleteAllDataFilesWarningPanel.setEnabled(false);
            ++gbc.gridy;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            JScrollPane filesScrollPane = this.createFilesScrollPane();
            guiPanel.add((Component)filesScrollPane, gbc);
        }
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(15, 5, 5, 5);
        guiPanel.add((Component)this.confirmationCheckBox, gbc);
        if (this.referencedFiles.isEmpty()) {
            ++gbc.gridy;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.insets = UIUtil.getNoInsets();
            guiPanel.add((Component)new JPanel(), gbc);
        }
        return guiPanel;
    }

    private JPanel createLabelWithPrefixPanel(boolean isWarning, String text) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 2;
        gbc.insets.right = 3;
        JLabel prefixLabel = new JLabel(isWarning ? IconsLoader.loadIcon("/images/Warning16.png") : IconsLoader.loadIcon("/images/LicenseInfo16.png"));
        panel.add((Component)prefixLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.right = 0;
        MultilineLabel textLabel = new MultilineLabel(text);
        panel.add((Component)textLabel, gbc);
        return panel;
    }

    private JScrollPane createFilesScrollPane() {
        this.filesArea = new JTextArea();
        this.filesArea.setEditable(false);
        this.filesArea.setLineWrap(false);
        this.filesArea.setWrapStyleWord(false);
        this.filesArea.setEnabled(false);
        StringBuilder filesText = new StringBuilder();
        for (Map.Entry<String, String> entry : this.referencedFiles.entrySet()) {
            filesText.append("\u2022 ").append(entry.getKey()).append(":\n  ");
            filesText.append(entry.getValue());
            File file = new File(entry.getValue());
            if (file.exists()) {
                if (file.isDirectory()) {
                    int fileCount = this.countFilesInDirectory(file);
                    filesText.append("\n  (").append(fileCount).append(" files)");
                } else {
                    long sizeKB = file.length() / 1024L;
                    filesText.append("\n  (").append(sizeKB > 0L ? sizeKB : 1L).append(" KB)");
                }
            }
            filesText.append("\n\n");
        }
        this.filesArea.setText(filesText.toString());
        this.filesArea.setCaretPosition(0);
        JScrollPane filesScrollPane = OxygenUIComponentsFactory.createScrollPane((Component)this.filesArea, (int)20, (int)31);
        return filesScrollPane;
    }

    private int countFilesInDirectory(File directory) {
        int count = 0;
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    count += this.countFilesInDirectory(file);
                    continue;
                }
                ++count;
            }
        }
        return count;
    }

    private void updateOkButtonState() {
        this.getOkButton().setEnabled(this.confirmationCheckBox.isSelected());
    }

    private void updateFilesAreaState() {
        if (this.filesArea != null) {
            boolean isChecked = this.deleteFilesCheckbox.isSelected();
            this.filesArea.setEnabled(isChecked);
        }
    }
}

