/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.preferences;

import com.oxygenxml.positron.connector.ConnectorConfigurationsPO;
import com.oxygenxml.positron.core.plugin.BaseOptionTags;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.plugin.ConnectionConfigUtil;
import com.oxygenxml.positron.plugin.EnterpriseConnectorLoader;
import com.oxygenxml.positron.plugin.preferences.DataDeletionManager;
import com.oxygenxml.positron.plugin.preferences.DeleteAllDataConfirmDialog;
import com.oxygenxml.positron.plugin.preferences.OptionTags;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.ExternalPersistentObject;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class DeleteAllDataAction
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(DeleteAllDataAction.class);
    private static final Translator TRANSLATOR = Translator.getInstance();
    private final Runnable onDataDeleted;

    public DeleteAllDataAction(Runnable onDataDeleted) {
        super(TRANSLATOR.getTranslation("Delete_All_Data") + "...");
        this.onDataDeleted = onDataDeleted;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Map<String, String> referencedFiles = this.collectReferencedFiles();
        DeleteAllDataConfirmDialog confirmDialog = new DeleteAllDataConfirmDialog(referencedFiles);
        confirmDialog.setVisible(true);
        if (confirmDialog.getResult() == 1) {
            this.deleteAllData();
            int deletedFilesCount = 0;
            if (confirmDialog.shouldDeleteFiles()) {
                deletedFilesCount = this.deletePhysicalFiles(referencedFiles);
            }
            DataDeletionManager.getInstance().markDataDeleted();
            String successMessage = this.buildSuccessMessage(confirmDialog.shouldDeleteFiles(), deletedFilesCount, referencedFiles.size());
            PluginWorkspaceProvider.getPluginWorkspace().showInformationMessage(successMessage);
            if (this.onDataDeleted != null) {
                this.onDataDeleted.run();
            }
            this.tryClosePreferencesDialog(e);
        }
    }

    protected void deleteAllData() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        if (optionsStorage != null) {
            ConnectorConfigurationsPO connectorConfigurations = (ConnectorConfigurationsPO)optionsStorage.getPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)new ConnectorConfigurationsPO());
            ConnectionConfigUtil.deletePasswordOptionsForConfigurations(optionsStorage, connectorConfigurations);
            Set<String> allOptionKeys = this.getAllOptionKeys();
            for (String optionKey : allOptionKeys) {
                try {
                    optionsStorage.setStringArrayOption(optionKey, null);
                    optionsStorage.setOption(optionKey, null);
                    optionsStorage.setPersistentObjectOption(optionKey, null);
                }
                catch (Exception ex) {
                    log.debug("Failed to delete option: " + optionKey, (Throwable)ex);
                }
            }
        }
    }

    protected Set<String> getAllOptionKeys() {
        HashSet<String> optionKeys = new HashSet<String>();
        this.collectOptionKeysFromClass(BaseOptionTags.class, optionKeys);
        this.collectOptionKeysFromClass(OptionTags.class, optionKeys);
        return optionKeys;
    }

    private void collectOptionKeysFromClass(Class<?> clazz, Set<String> optionKeys) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || field.getType() != String.class) continue;
            try {
                String value = (String)field.get(null);
                if (value == null) continue;
                optionKeys.add(value);
            }
            catch (IllegalAccessException e) {
                log.debug("Could not access field: " + field.getName(), (Throwable)e);
            }
        }
    }

    protected Map<String, String> collectReferencedFiles() {
        LinkedHashMap<String, String> referencedFiles = new LinkedHashMap<String, String>();
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        PluginWorkspace workspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (optionsStorage != null && workspace != null) {
            this.collectCustomActionsFiles(referencedFiles, optionsStorage, workspace);
            this.collectContextFiles(referencedFiles, optionsStorage, workspace);
            this.collectMCPConfigurationFiles(referencedFiles, optionsStorage, workspace);
        }
        this.collectAIServiceConfigurationFile(referencedFiles);
        return referencedFiles;
    }

    private Optional<String> getExpandedOptionValue(String optionKey, String defaultValue, WSOptionsStorage optionsStorage, PluginWorkspace workspace) {
        String optionValue = optionsStorage.getOption(optionKey, defaultValue);
        if (TextUtils.isNullOrBlank((String)optionValue)) {
            return Optional.empty();
        }
        String expandedPath = workspace.getUtilAccess().expandEditorVariables(optionValue, null);
        if (TextUtils.isNullOrBlank((String)expandedPath)) {
            return Optional.empty();
        }
        return Optional.of(expandedPath);
    }

    private void collectCustomActionsFiles(Map<String, String> referencedFiles, WSOptionsStorage optionsStorage, PluginWorkspace workspace) {
        Optional<String> expandedPath = this.getExpandedOptionValue("oxygen.positron.plugin.actions.folder", "${pd}/positron-ai-actions", optionsStorage, workspace);
        expandedPath.ifPresent(path -> {
            File actionsFolder = new File((String)path);
            if (actionsFolder.exists()) {
                if (actionsFolder.isDirectory()) {
                    File[] files = actionsFolder.listFiles();
                    if (files != null && files.length > 0) {
                        referencedFiles.put(Translator.getInstance().getTranslation("Actions_Folder_Label") + ":", actionsFolder.getAbsolutePath());
                    }
                } else {
                    referencedFiles.put(TRANSLATOR.getTranslation("Custom_Actions_File"), actionsFolder.getAbsolutePath());
                }
            }
        });
    }

    private void collectContextFiles(Map<String, String> referencedFiles, WSOptionsStorage optionsStorage, PluginWorkspace workspace) {
        Optional<String> contextFilesValue = this.getExpandedOptionValue("oxygen.positron.plugin.additional.context.file", "${pd}/ai-context.md, ${pd}/positron-ai/ai-context.md, ${pd}/positron-ai-actions/ai-context.md", optionsStorage, workspace);
        contextFilesValue.ifPresent(value -> {
            String[] files = value.split(",");
            int fileIndex = 1;
            for (String file : files) {
                String expandedPath;
                String trimmed = file.trim();
                if (TextUtils.isNullOrBlank((String)trimmed) || (expandedPath = workspace.getUtilAccess().expandEditorVariables(trimmed, null)) == null || !new File(expandedPath).exists()) continue;
                referencedFiles.put(TRANSLATOR.getTranslation("Context_File") + " " + fileIndex, expandedPath);
                ++fileIndex;
            }
        });
    }

    private void collectMCPConfigurationFiles(Map<String, String> referencedFiles, WSOptionsStorage optionsStorage, PluginWorkspace workspace) {
        Optional<String> mcpConfigValue = this.getExpandedOptionValue("oxygen.positron.plugin.mcp.config.file", "${pd}/positron-ai-actions/mcp-config.json", optionsStorage, workspace);
        mcpConfigValue.ifPresent(value -> {
            String[] configurations;
            for (String configuration : configurations = value.split(",")) {
                String expandedPath = workspace.getUtilAccess().expandEditorVariables(configuration.trim(), null);
                if (TextUtils.isNullOrBlank((String)expandedPath) || !new File(expandedPath).exists()) continue;
                referencedFiles.put(TRANSLATOR.getTranslation("MCP_Configuration_File"), expandedPath);
            }
        });
    }

    private void collectAIServiceConfigurationFile(Map<String, String> referencedFiles) {
        Optional.ofNullable(EnterpriseConnectorLoader.getInstance().getConfigurationURL()).ifPresent(url -> {
            if (URLUtil.isFromLocalDrive((URL)url)) {
                referencedFiles.put(TRANSLATOR.getTranslation("AI_Service_Configuration_File"), URLUtil.getCanonicalFileFromFileUrl((URL)url).getAbsolutePath());
            }
        });
    }

    protected int deletePhysicalFiles(Map<String, String> filePaths) {
        int deletedCount = 0;
        for (Map.Entry<String, String> entry : filePaths.entrySet()) {
            try {
                File file = new File(entry.getValue());
                if (file.isDirectory()) {
                    if (!this.deleteDirectory(file)) continue;
                    ++deletedCount;
                    log.debug("Deleted directory: " + entry.getValue());
                    continue;
                }
                if (!file.delete()) continue;
                ++deletedCount;
                log.debug("Deleted file: " + entry.getValue());
            }
            catch (Exception e) {
                log.warn("Failed to delete: " + entry.getValue(), (Throwable)e);
            }
        }
        return deletedCount;
    }

    private boolean deleteDirectory(File directory) {
        boolean allDeletionsSuccessful = true;
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    allDeletionsSuccessful &= this.deleteDirectory(file);
                    continue;
                }
                allDeletionsSuccessful &= file.delete();
            }
        }
        return allDeletionsSuccessful &= directory.delete();
    }

    private String buildSuccessMessage(boolean filesDeleted, int deletedCount, int totalFiles) {
        StringBuilder message = new StringBuilder();
        message.append(TRANSLATOR.getTranslation("Delete_All_Data_Success"));
        if (filesDeleted && totalFiles > 0) {
            message.append("\n\n");
            message.append(TRANSLATOR.getTranslation("Delete_All_Data_Files_Deleted")).append(" ").append(deletedCount).append("/").append(totalFiles);
        } else if (!filesDeleted && totalFiles > 0) {
            message.append("\n\n");
            message.append(TRANSLATOR.getTranslation("Delete_All_Data_Files_Remain"));
        }
        message.append("\n\n");
        message.append(TRANSLATOR.getTranslation("Delete_All_Data_Restart_Required"));
        return message.toString();
    }

    private void tryClosePreferencesDialog(ActionEvent event) {
        try {
            Window window;
            if (event.getSource() instanceof Component && (window = SwingUtilities.getWindowAncestor((Component)event.getSource())) != null) {
                window.dispose();
            }
        }
        catch (Exception ex) {
            log.debug("Could not close preferences dialog", (Throwable)ex);
        }
    }
}

