/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.preferences;

import com.oxygenxml.positron.connector.AIConnectorConfigsManager;
import com.oxygenxml.positron.connector.ConnectorConfigurationData;
import com.oxygenxml.positron.core.plugin.Translator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public final class ConnectionTableModel
extends AbstractTableModel {
    private static final int NAME_COLUMN = 0;
    private static final int CONNECTOR_TYPE_COLUMN = 1;
    private static final int NO_OF_COLUMNS = 2;
    private static final String[] COLUMNS_NAMES = new String[]{Translator.getInstance().getTranslation("Name"), Translator.getInstance().getTranslation("Connector_Type")};
    private final List<ConnectorConfigurationData> connections = new ArrayList<ConnectorConfigurationData>();

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this.connections.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String result = null;
        ConnectorConfigurationData config = this.connections.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                result = config.getName();
                break;
            }
            case 1: {
                result = this.getConnectorDisplayName(config.getConnectorId());
                break;
            }
        }
        return result;
    }

    private String getConnectorDisplayName(String connectorId) {
        return AIConnectorConfigsManager.getInstance().getConnectorTypes().stream().filter(connector -> connector.getConnectorId().equals(connectorId)).findFirst().map(connector -> connector.getConnectorName()).orElse(connectorId);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNS_NAMES[columnIndex];
    }

    public void clear() {
        int size = this.connections.size();
        this.connections.clear();
        if (size > 0) {
            this.fireTableRowsDeleted(0, size - 1);
        }
    }

    public void setConnections(List<ConnectorConfigurationData> newConnections) {
        this.clear();
        if (newConnections != null) {
            this.connections.addAll(newConnections);
            if (!this.connections.isEmpty()) {
                this.fireTableRowsInserted(0, this.connections.size() - 1);
            }
        }
    }

    public void addConnection(ConnectorConfigurationData configData) {
        this.connections.add(configData);
        int index = this.connections.size() - 1;
        this.fireTableRowsInserted(index, index);
    }

    public void deleteConnection(int index) {
        if (index >= 0 && index < this.connections.size()) {
            this.connections.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public ConnectorConfigurationData getConnectionAt(int index) {
        if (index >= 0 && index < this.connections.size()) {
            return this.connections.get(index);
        }
        return null;
    }

    public boolean hasConnectionWithName(String name) {
        return this.connections.stream().anyMatch(config -> config.getName().equals(name));
    }

    public void updateConnection(int index, ConnectorConfigurationData configData) {
        if (index >= 0 && index < this.connections.size()) {
            this.connections.set(index, configData);
            this.fireTableRowsUpdated(index, index);
        }
    }

    public List<ConnectorConfigurationData> getConnections() {
        return new ArrayList<ConnectorConfigurationData>(this.connections);
    }

    public void moveConnectionUp(int index) {
        if (index > 0 && index < this.connections.size()) {
            ConnectorConfigurationData connection = this.connections.remove(index);
            this.connections.add(index - 1, connection);
            this.fireTableRowsUpdated(index - 1, index);
        }
    }

    public void moveConnectionDown(int index) {
        if (index >= 0 && index < this.connections.size() - 1) {
            ConnectorConfigurationData connection = this.connections.remove(index);
            this.connections.add(index + 1, connection);
            this.fireTableRowsUpdated(index, index + 1);
        }
    }
}

