/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.preferences;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.core.filter.SensitiveContentFilter;
import com.oxygenxml.positron.core.filter.SensitiveContentPattern;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.mcp.ObjectMapperUtil;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.SecurityHelper;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.OKCancelDialog;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class AddOrEditPatternDialog
extends OKCancelDialog {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private final JTextField patternField = OxygenUIComponentsFactory.createTextField();
    private final JTextField placeHolderField = OxygenUIComponentsFactory.createTextField();
    private static final int WIDTH = 600;
    private static final int HEIGHT = 450;
    private final JTextArea testInputArea = OxygenUIComponentsFactory.createTextArea(null);
    private final JTextArea testResultArea = OxygenUIComponentsFactory.createTextArea(null);
    private SensitiveContentPattern patternResult;
    private final List<SensitiveContentPattern> existingPatterns;
    private SensitiveContentPattern editingPattern;
    private final SensitiveContentFilter patternsFilter;
    private SensitiveContentPattern initialPattern;
    private final List<SensitiveContentPattern> patterns = new ArrayList<SensitiveContentPattern>();

    public AddOrEditPatternDialog(boolean isAddDialog, SensitiveContentPattern initialPattern, List<SensitiveContentPattern> existingPatterns) {
        super((JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame(), TRANSLATOR.getTranslation(isAddDialog ? "Add_Pattern" : "Edit_Pattern"), true);
        JFrame parentFrame;
        this.initialPattern = initialPattern;
        this.patterns.add(initialPattern);
        this.existingPatterns = existingPatterns != null ? existingPatterns : new ArrayList();
        this.editingPattern = initialPattern;
        ObjectMapper mapper = ObjectMapperUtil.createObjectMapperNoFailUnknownProps();
        this.patternsFilter = new SensitiveContentFilter(() -> {
            try {
                return mapper.writeValueAsString(this.patterns);
            }
            catch (JsonProcessingException e) {
                return "[]";
            }
        });
        if (isAddDialog) {
            this.setOkButtonText(TRANSLATOR.getTranslation("Add"));
        }
        if (initialPattern != null) {
            this.patternField.setText(initialPattern.getPattern());
            this.patternField.setCaretPosition(0);
            this.patternField.selectAll();
            this.placeHolderField.setText(initialPattern.getPlaceholderText());
            String savedTestInput = initialPattern.getTestInput();
            if (savedTestInput != null && !savedTestInput.isEmpty()) {
                String decryptedTestInput = SecurityHelper.getInstance().decryptText(savedTestInput);
                this.testInputArea.setText(decryptedTestInput);
            }
        }
        this.setMinimumSize(new Dimension(450, 450));
        this.setPreferredSize(new Dimension(600, 450));
        this.setResizable(true);
        this.testResultArea.setEditable(false);
        this.getContentPane().add(this.createGUIPanel());
        this.pack();
        DocumentListener testResultListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddOrEditPatternDialog.this.updateTestResult();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddOrEditPatternDialog.this.updateTestResult();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddOrEditPatternDialog.this.updateTestResult();
            }
        };
        this.patternField.getDocument().addDocumentListener(testResultListener);
        this.placeHolderField.getDocument().addDocumentListener(testResultListener);
        this.testInputArea.getDocument().addDocumentListener(testResultListener);
        this.updateTestResult();
        JFrame jFrame = parentFrame = PluginWorkspaceProvider.getPluginWorkspace() != null ? (JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame() : null;
        if (parentFrame != null) {
            this.setIconImage(parentFrame.getIconImage());
            this.setLocationRelativeTo(parentFrame);
        }
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private JPanel createGUIPanel() {
        JPanel guiPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = UIUtil.getSpacingInsets();
        guiPanel.add((Component)new JLabel(TRANSLATOR.getTranslation("Pattern") + ":"), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        guiPanel.add((Component)this.patternField, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        JButton infoButton = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction("", IconsLoader.loadIcon("/images/Info12.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginWorkspaceProvider.getPluginWorkspace().showInformationMessage(TRANSLATOR.getTranslation("Regex_Patterns_Info"));
            }
        }, (boolean)false);
        infoButton.setMargin(new Insets(1, 1, 1, 1));
        infoButton.setToolTipText(TRANSLATOR.getTranslation("More_details"));
        guiPanel.add((Component)infoButton, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 2;
        gbc.insets = UIUtil.getSpacingInsets();
        guiPanel.add((Component)new JLabel(TRANSLATOR.getTranslation("Placeholder_Text") + ":"), gbc);
        ++gbc.gridx;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        guiPanel.add((Component)this.placeHolderField, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        JButton placeholderInfoButton = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction("", IconsLoader.loadIcon("/images/Info12.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginWorkspaceProvider.getPluginWorkspace().showInformationMessage(TRANSLATOR.getTranslation("Placeholder_Text_Info"));
            }
        }, (boolean)false);
        placeholderInfoButton.setMargin(new Insets(1, 1, 1, 1));
        placeholderInfoButton.setToolTipText(TRANSLATOR.getTranslation("More_details"));
        guiPanel.add((Component)placeholderInfoButton, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 5, 3, 0);
        guiPanel.add((Component)new JLabel(TRANSLATOR.getTranslation("Test_Input")), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.4;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.testInputArea.setRows(3);
        this.testInputArea.setLineWrap(true);
        this.testInputArea.setWrapStyleWord(true);
        JScrollPane testInputScrollPane = OxygenUIComponentsFactory.createScrollPane((Component)this.testInputArea, (int)20, (int)31);
        guiPanel.add((Component)testInputScrollPane, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 3, 0);
        guiPanel.add((Component)new JLabel(TRANSLATOR.getTranslation("Test_Result")), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.4;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.testResultArea.setRows(3);
        this.testResultArea.setLineWrap(true);
        this.testResultArea.setWrapStyleWord(true);
        JScrollPane testResultScrollPane = OxygenUIComponentsFactory.createScrollPane((Component)this.testResultArea, (int)20, (int)31);
        guiPanel.add((Component)testResultScrollPane, gbc);
        return guiPanel;
    }

    public SensitiveContentPattern getPattern() {
        return this.patternResult;
    }

    private boolean isPatternUnique(String pattern) {
        boolean isUnique = true;
        for (SensitiveContentPattern existingPattern : this.existingPatterns) {
            if (this.editingPattern != null && existingPattern.getPattern().equals(this.editingPattern.getPattern()) || !existingPattern.getPattern().equals(pattern)) continue;
            isUnique = false;
            break;
        }
        return isUnique;
    }

    private boolean isValidRegex(String regex) {
        boolean isValid = true;
        if (regex == null || regex.isEmpty()) {
            isValid = false;
        } else {
            try {
                Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                isValid = false;
            }
        }
        return isValid;
    }

    private void updateTestResult() {
        String patternText = this.patternField.getText();
        String placeholderText = this.placeHolderField.getText();
        String testInput = this.testInputArea.getText();
        if (testInput == null || testInput.trim().isEmpty()) {
            this.testResultArea.setText("");
            this.updateOkButtonState();
            return;
        }
        if (patternText == null || patternText.trim().isEmpty()) {
            this.testResultArea.setText("");
            this.updateOkButtonState();
            return;
        }
        if (!this.isValidRegex(patternText)) {
            this.testResultArea.setText(TRANSLATOR.getTranslation("Cannot_Save_Invalid_Regex_Pattern"));
            this.updateOkButtonState();
            return;
        }
        this.patterns.set(0, new SensitiveContentPattern(patternText.trim(), placeholderText != null && !placeholderText.trim().isEmpty() ? placeholderText.trim() : "PLACEHOLDER"));
        String result = this.patternsFilter.maskText(testInput);
        this.patternsFilter.clearMappings();
        if (result.equals(testInput)) {
            this.testResultArea.setText(TRANSLATOR.getTranslation("No_Matches_Found"));
        } else {
            this.testResultArea.setText(result);
            this.testResultArea.setCaretPosition(0);
        }
        this.updateOkButtonState();
    }

    private void updateOkButtonState() {
        boolean isModified = true;
        if (this.initialPattern != null) {
            String originalTestInput = this.initialPattern.getTestInput();
            if (originalTestInput != null && !originalTestInput.isEmpty()) {
                originalTestInput = SecurityHelper.getInstance().decryptText(originalTestInput);
            }
            isModified = !Objects.equals(this.testInputArea.getText(), originalTestInput);
        }
        this.getOkButton().setEnabled(isModified);
    }

    protected void doOK() {
        String pattern = this.patternField.getText();
        String placeholder = this.placeHolderField.getText();
        boolean shouldProceed = true;
        if (pattern == null || pattern.trim().isEmpty()) {
            PluginWorkspaceProvider.getPluginWorkspace().showInformationMessage(TRANSLATOR.getTranslation("Pattern_Field_Cannot_Be_Empty"));
            this.patternField.requestFocus();
            shouldProceed = false;
        }
        if (shouldProceed && (placeholder == null || placeholder.trim().isEmpty())) {
            PluginWorkspaceProvider.getPluginWorkspace().showInformationMessage(TRANSLATOR.getTranslation("Placeholder_Text_Field_Cannot_Be_Empty"));
            this.placeHolderField.requestFocus();
            shouldProceed = false;
        }
        if (shouldProceed && !this.isValidRegex(pattern.trim())) {
            PluginWorkspaceProvider.getPluginWorkspace().showInformationMessage(TRANSLATOR.getTranslation("Cannot_Save_Invalid_Regex_Pattern"));
            this.patternField.requestFocus();
            shouldProceed = false;
        }
        if (shouldProceed) {
            String currentPattern = pattern.trim();
            String currentPlaceholder = placeholder.trim();
            if (!this.isPatternUnique(currentPattern)) {
                PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage(TRANSLATOR.getTranslation("Pattern_Already_Exists_Use_Unique"));
                this.patternField.requestFocus();
                shouldProceed = false;
            }
            if (shouldProceed) {
                String testInput = this.testInputArea.getText();
                String encryptedTestInput = "";
                if (testInput != null && !testInput.isEmpty()) {
                    encryptedTestInput = SecurityHelper.getInstance().encryptText(testInput);
                }
                this.patternResult = new SensitiveContentPattern(currentPattern, currentPlaceholder, encryptedTestInput);
                super.doOK();
            }
        }
    }
}

