/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.preferences;

import com.fasterxml.jackson.databind.JavaType;
import com.oxygenxml.positron.api.connector.AIConnector;
import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.api.connector.dto.Pair;
import com.oxygenxml.positron.api.connector.param.CheckBoxConnectorParam;
import com.oxygenxml.positron.api.connector.param.ComboConnectorParam;
import com.oxygenxml.positron.api.connector.param.ConnectorParamBase;
import com.oxygenxml.positron.api.connector.param.ConnectorParamType;
import com.oxygenxml.positron.api.connector.param.InfoMultilineLabelParam;
import com.oxygenxml.positron.api.connector.param.KeyValueTableConnectorParam;
import com.oxygenxml.positron.api.connector.param.ModelsComboConnectorParam;
import com.oxygenxml.positron.api.connector.param.PasswordTextFieldConnectorParam;
import com.oxygenxml.positron.api.connector.param.TextFieldConnectorParam;
import com.oxygenxml.positron.connector.AIConnectorConfigsManager;
import com.oxygenxml.positron.connector.ConnectorConfigurationData;
import com.oxygenxml.positron.core.auth.BrowserOpener;
import com.oxygenxml.positron.core.engines.EnginesManagerProvider;
import com.oxygenxml.positron.core.engines.IEnginesManager;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.JsonHelper;
import com.oxygenxml.positron.core.util.PositronOptionsUtil;
import com.oxygenxml.positron.plugin.ModelsUIUtil;
import com.oxygenxml.positron.plugin.engine.EnterpriseEnginesManager;
import com.oxygenxml.positron.plugin.preferences.KeyValueTablePanel;
import com.oxygenxml.positron.plugin.ui.ComboBoxItem;
import com.oxygenxml.positron.plugin.ui.GroupedComboBoxModel;
import com.oxygenxml.positron.plugin.ui.MultilineLabel;
import com.oxygenxml.positron.plugin.ui.SectionPane;
import com.oxygenxml.positron.plugin.ui.TextFieldWithPlaceHolder;
import com.oxygenxml.positron.plugin.ui.ThemeColorProvider;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.SecurityHelper;
import com.oxygenxml.positron.plugin.util.UIUtil;
import com.oxygenxml.positron.utilities.ModelIdentifierUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.JTextComponent;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.OKCancelDialog;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.TextField;
import ro.sync.options.SerializableLinkedHashMap;

public class AddEditConnectionDialog
extends OKCancelDialog {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private static final int SPACE_BETWEEN_GROUPED_ELEMENTS_INSET = 3;
    private static final int CONNECTION_ID_UPDATE_DELAY_MS = 200;
    private IEnginesManager enginesManager;
    private TextField connectionNameField;
    private TextField connectionIdField;
    private Timer connectionIdUpdateTimer;
    private JComboBox<AIConnector> connectorsCombo;
    private MultilineLabel disclaimerLabel;
    private JPanel headerPanel;
    private JPanel parametersPanel;
    private final Map<String, List<Component>> connectorParamsComponents = new HashMap<String, List<Component>>();
    private final Map<String, Supplier<Object>> paramsInputsMap = new HashMap<String, Supplier<Object>>();
    private final ConnectorConfigurationData connectionConfiguration;
    private final List<ConnectorConfigurationData> existingConnections;
    private boolean wasCheckboxOrRadio = false;

    public AddEditConnectionDialog(Component parent, List<ConnectorConfigurationData> existingConnections) {
        super((JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame(), TRANSLATOR.getTranslation("Add_Connection"), true);
        this.connectionConfiguration = null;
        this.existingConnections = existingConnections != null ? new ArrayList<ConnectorConfigurationData>(existingConnections) : new ArrayList();
        this.initializeDialog();
    }

    public AddEditConnectionDialog(Component parent, ConnectorConfigurationData connectionConfiguration, List<ConnectorConfigurationData> existingConnections) {
        super((JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame(), TRANSLATOR.getTranslation("Edit_Connection"), true);
        this.connectionConfiguration = connectionConfiguration;
        this.existingConnections = existingConnections != null ? new ArrayList<ConnectorConfigurationData>(existingConnections) : new ArrayList();
        this.initializeDialog();
    }

    private void initializeDialog() {
        this.enginesManager = EnginesManagerProvider.getInstance().getEnginesManager();
        this.createComponents();
        this.layoutComponents();
        this.loadInitialValues();
        this.setPreferredSize(new Dimension(500, 650));
        this.setMinimumSize(new Dimension(450, 550));
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(this.getParent());
    }

    private void createComponents() {
        this.headerPanel = new JPanel(new GridBagLayout());
        this.parametersPanel = new JPanel(new GridBagLayout());
        this.connectionNameField = OxygenUIComponentsFactory.createTextField();
        this.connectionNameField.setWidthLimit(200);
        this.connectionIdField = OxygenUIComponentsFactory.createTextField();
        this.connectionIdField.setWidthLimit(200);
        this.connectionIdField.setEditable(false);
        this.connectionIdField.setEnabled(false);
        this.connectionIdUpdateTimer = new Timer(200, e -> this.updateConnectionIdField());
        this.connectionIdUpdateTimer.setRepeats(false);
        this.connectionNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddEditConnectionDialog.this.scheduleConnectionIdUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddEditConnectionDialog.this.scheduleConnectionIdUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddEditConnectionDialog.this.scheduleConnectionIdUpdate();
            }
        });
        List connectors = AIConnectorConfigsManager.getInstance().getConnectorTypes();
        this.connectorsCombo = OxygenUIComponentsFactory.createComboBox(new JComboBox(new Vector(connectors)).getModel());
        this.connectorsCombo.setEnabled(this.connectionConfiguration == null);
        ListCellRenderer<AIConnector> oldRenderer = this.connectorsCombo.getRenderer();
        this.connectorsCombo.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            Component component = oldRenderer.getListCellRendererComponent(list, (AIConnector)value, index, isSelected, cellHasFocus);
            if (component instanceof JLabel && value != null) {
                ((JLabel)component).setText(value.getConnectorName());
            }
            return component;
        });
        this.disclaimerLabel = new MultilineLabel();
        this.disclaimerLabel.setFont(UIManager.getFont("Label.font"));
        this.disclaimerLabel.setForeground(ThemeColorProvider.getInstance().getDisclaimerColor());
        this.disclaimerLabel.setVisible(false);
        this.connectorsCombo.addItemListener(e -> {
            AIConnector selectedConnector;
            if (e.getStateChange() == 1 && (selectedConnector = (AIConnector)this.connectorsCombo.getSelectedItem()) != null) {
                this.showComponentsForSelectedConnector(selectedConnector.getConnectorId());
                this.updateDisclaimerForConnector(selectedConnector);
            }
        });
    }

    private void layoutComponents() {
        this.layoutHeaderPanel();
        this.layoutParametersPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 256;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.getContentPane().add((Component)this.headerPanel, gbc);
        ++gbc.gridy;
        gbc.insets.left = 5;
        this.getContentPane().add((Component)new SectionPane(TRANSLATOR.getTranslation("Connection_details"), true, false), gbc);
        JScrollPane scrollPane = new JScrollPane(this.parametersPanel);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBorder(null);
        scrollPane.setPreferredSize(new Dimension(300, 200));
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.insets.left = 0;
        gbc.fill = 1;
        this.getContentPane().add((Component)scrollPane, gbc);
    }

    private void layoutHeaderPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = UIUtil.getSpacingInsetsNoBottom();
        this.headerPanel.add((Component)new JLabel(TRANSLATOR.getTranslation("Name") + ":"), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.headerPanel.add((Component)this.connectionNameField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets = UIUtil.getSpacingInsetsNoBottom();
        this.headerPanel.add((Component)new JLabel(TRANSLATOR.getTranslation("Connection_ID") + ":"), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.headerPanel.add((Component)this.connectionIdField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets = UIUtil.getSpacingInsets();
        this.headerPanel.add((Component)new JLabel(TRANSLATOR.getTranslation("Connector_Type") + ":"), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.headerPanel.add(this.connectorsCombo, gbc);
    }

    private void layoutParametersPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.createParameterComponents(gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.parametersPanel.add((Component)this.disclaimerLabel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = UIUtil.getNoInsets();
        this.parametersPanel.add((Component)new JPanel(), gbc);
    }

    private void createParameterComponents(GridBagConstraints gbc) {
        this.connectorParamsComponents.clear();
        this.paramsInputsMap.clear();
        AIConnectorConfigsManager.getInstance().getConnectorTypes().forEach(connector -> this.createParameterComponentsForConnector((AIConnector)connector, gbc));
        if (!AIConnectorConfigsManager.getInstance().getConnectorTypes().isEmpty()) {
            String firstConnectorId = ((AIConnector)AIConnectorConfigsManager.getInstance().getConnectorTypes().get(0)).getConnectorId();
            this.showComponentsForSelectedConnector(firstConnectorId);
        }
    }

    private void createParameterComponentsForConnector(AIConnector connector, GridBagConstraints gbc) {
        this.connectorParamsComponents.put(connector.getConnectorId(), new ArrayList());
        this.wasCheckboxOrRadio = false;
        connector.getParametersList().forEach(param -> this.addUIComponentsForConnectorParam(connector, (ConnectorParamBase)param, gbc));
        if (connector.getParametersList().stream().anyMatch(param -> param.getType() == ConnectorParamType.PASSWORD_TEXT_FIELD)) {
            MultilineLabel apiKeyLabel = new MultilineLabel("* " + TRANSLATOR.getTranslation("Password_Param_Store_Info"));
            gbc.gridwidth = 2;
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.insets.top = 21;
            this.parametersPanel.add((Component)apiKeyLabel, gbc);
            this.connectorParamsComponents.get(connector.getConnectorId()).add(apiKeyLabel);
        }
    }

    private void addUIComponentsForConnectorParam(AIConnector connector, ConnectorParamBase param, GridBagConstraints gbc) {
        gbc.gridx = -1;
        ++gbc.gridy;
        gbc.insets = UIUtil.getSpacingInsetsNoBottom();
        gbc.anchor = 17;
        switch (param.getType()) {
            case CHECK_BOX: {
                gbc.insets.top = 5 - (this.wasCheckboxOrRadio ? 3 : 0);
                this.addCheckBoxParam(connector, (CheckBoxConnectorParam)param, gbc);
                this.wasCheckboxOrRadio = true;
                break;
            }
            case COMBO_BOX: {
                gbc.insets.top = 5 - (this.wasCheckboxOrRadio ? 3 : 0);
                this.addComboBoxParam(connector, (ComboConnectorParam)param, gbc);
                this.wasCheckboxOrRadio = false;
                break;
            }
            case MODEL_COMBO_BOX: {
                gbc.insets.top = 5 - (this.wasCheckboxOrRadio ? 3 : 0);
                this.addModelsComboBoxParam(connector, (ModelsComboConnectorParam)param, gbc);
                this.wasCheckboxOrRadio = false;
                break;
            }
            case TEXT_FIELD: {
                gbc.insets.top = 5 - (this.wasCheckboxOrRadio ? 3 : 0);
                this.addTextFieldParam(connector, (TextFieldConnectorParam)param, gbc);
                this.wasCheckboxOrRadio = false;
                break;
            }
            case PASSWORD_TEXT_FIELD: {
                gbc.insets.top = 5 - (this.wasCheckboxOrRadio ? 3 : 0);
                this.addPasswordTextFieldParam(connector, (PasswordTextFieldConnectorParam)param, gbc);
                this.wasCheckboxOrRadio = false;
                break;
            }
            case KEY_VALUE_TABLE: {
                gbc.insets.top = 5 - (this.wasCheckboxOrRadio ? 3 : 0);
                this.addKeyValueTableParam(connector, (KeyValueTableConnectorParam)param, gbc);
                this.wasCheckboxOrRadio = false;
                break;
            }
            case INFO_MULTILANE_LABEL: {
                gbc.insets.top = 5 - (this.wasCheckboxOrRadio ? 3 : 0);
                this.addMultilineLabelParam(connector, (InfoMultilineLabelParam)param, gbc);
                this.wasCheckboxOrRadio = false;
                break;
            }
        }
    }

    private void showComponentsForSelectedConnector(String selectedConnectorId) {
        AIConnectorConfigsManager.getInstance().getConnectorTypes().forEach(connector -> {
            boolean isSelectedConnector = connector.getConnectorId().equals(selectedConnectorId);
            List<Component> components = this.connectorParamsComponents.get(connector.getConnectorId());
            if (components != null) {
                components.forEach(component -> component.setVisible(isSelectedConnector));
            }
        });
        this.parametersPanel.revalidate();
        this.parametersPanel.repaint();
    }

    private void updateDisclaimerForConnector(AIConnector selectedConnector) {
        String disclaimer = selectedConnector.getDisclaimer();
        if (disclaimer != null && !disclaimer.trim().isEmpty()) {
            this.disclaimerLabel.setText(disclaimer);
            this.disclaimerLabel.setVisible(true);
        } else {
            this.disclaimerLabel.setVisible(false);
        }
        this.parametersPanel.revalidate();
        this.parametersPanel.repaint();
    }

    private void loadInitialValues() {
        if (this.connectionConfiguration != null) {
            this.connectionNameField.setText(this.connectionConfiguration.getName());
            this.connectionIdField.setText(this.connectionConfiguration.getConfigurationId());
            Optional<AIConnector> connectorOpt = AIConnectorConfigsManager.getInstance().getConnectorTypes().stream().filter(c -> c.getConnectorId().equals(this.connectionConfiguration.getConnectorId())).findFirst();
            if (connectorOpt.isPresent()) {
                AIConnector connector = connectorOpt.get();
                this.connectorsCombo.setSelectedItem(connector);
                this.updateDisclaimerForConnector(connector);
            } else {
                String message = String.format("Connector type '%s' not found. The connection may use an unsupported connector.", this.connectionConfiguration.getConnectorId());
                PluginWorkspaceProvider.getPluginWorkspace().showWarningMessage(message);
            }
        } else {
            this.updateConnectionIdField();
        }
    }

    private void scheduleConnectionIdUpdate() {
        if (this.connectionConfiguration == null && this.connectionIdUpdateTimer != null) {
            this.connectionIdUpdateTimer.restart();
        }
    }

    private void updateConnectionIdField() {
        String name;
        String generatedId;
        if (this.connectionConfiguration == null && !(generatedId = ModelIdentifierUtil.createConfigurationId((String)(name = this.connectionNameField.getText()))).equals(this.connectionIdField.getText())) {
            this.connectionIdField.setText(generatedId);
        }
    }

    private boolean validateInput() {
        boolean isValid = true;
        String name = this.connectionNameField.getText().trim();
        String id = this.connectionIdField.getText().trim();
        if (name.isEmpty() || id.isEmpty()) {
            PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage(TRANSLATOR.getTranslation("Connection_name_cannot_be_empty"));
            this.connectionNameField.requestFocus();
            isValid = false;
        } else if (this.connectionConfiguration == null && this.isDuplicateName(name, id)) {
            PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage(TRANSLATOR.getTranslation("Connection_name_already_exists"));
            this.connectionNameField.requestFocus();
            isValid = false;
        } else if (name.startsWith("AI Positron Service / ")) {
            PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage(MessageFormat.format(TRANSLATOR.getTranslation("Connection_name_cannot_start_with"), "AI Positron Service / "));
            this.connectionNameField.requestFocus();
            isValid = false;
        } else if (this.connectionIdField.getText().trim().startsWith("aips")) {
            PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage(MessageFormat.format(TRANSLATOR.getTranslation("Connection_id_cannot_start_with"), "aips"));
            this.connectionNameField.requestFocus();
            isValid = false;
        } else {
            AIConnector selectedConnector = (AIConnector)this.connectorsCombo.getSelectedItem();
            if (selectedConnector == null) {
                PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage(TRANSLATOR.getTranslation("Please_select_connector_type"));
                this.connectorsCombo.requestFocus();
                isValid = false;
            }
        }
        return isValid;
    }

    private boolean isDuplicateName(String name, String id) {
        return this.existingConnections.stream().anyMatch(config -> name.equals(config.getName()) || id.equals(config.getConfigurationId()));
    }

    private Object getValueForParam(AIConnector connector, ConnectorParamBase param) {
        String stringValue = null;
        if (this.connectionConfiguration != null && connector.getConnectorId().equals(this.connectionConfiguration.getConnectorId())) {
            SerializableLinkedHashMap parameters = this.connectionConfiguration.getParameters();
            stringValue = parameters != null ? (String)parameters.get(param.getId()) : null;
        }
        return stringValue != null ? this.convertStringValueToObject(param, stringValue) : null;
    }

    Object convertStringValueToObject(ConnectorParamBase param, String stringValue) {
        if (stringValue == null) {
            return null;
        }
        switch (param.getType()) {
            case PASSWORD_TEXT_FIELD: {
                return SecurityHelper.getInstance().decryptText(stringValue);
            }
            case COMBO_BOX: 
            case MODEL_COMBO_BOX: 
            case TEXT_FIELD: {
                return stringValue;
            }
            case CHECK_BOX: {
                return Boolean.parseBoolean(stringValue);
            }
            case KEY_VALUE_TABLE: {
                return this.parseKeyValueString(stringValue);
            }
        }
        return stringValue;
    }

    private List<Pair<String, String>> parseKeyValueString(String stringValue) {
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        if (stringValue == null || stringValue.trim().isEmpty()) {
            return pairs;
        }
        Object value = JsonHelper.getInstance().toObject(stringValue, (JavaType)JsonHelper.getInstance().constructCollectionType(List.class, Pair.class));
        if (value instanceof List) {
            pairs.addAll((Collection)value);
        }
        return pairs;
    }

    private String getParameterKey(AIConnector connector, ConnectorParamBase param) {
        return connector.getConnectorId() + "_" + param.getId();
    }

    protected void doOK() {
        if (this.validateInput()) {
            super.doOK();
        }
    }

    public ConnectorConfigurationData getConnectionConfiguration() {
        ConnectorConfigurationData config = null;
        if (this.getResult() == 1) {
            String name = this.connectionNameField.getText().trim();
            AIConnector selectedConnector = (AIConnector)this.connectorsCombo.getSelectedItem();
            if (selectedConnector != null) {
                String configId = ModelIdentifierUtil.createConfigurationId((String)name);
                ConnectorConfigurationData finalConfig = new ConnectorConfigurationData(name, configId, selectedConnector.getConnectorId());
                List<ModelDescriptor> modelDescriptors = ((EnterpriseEnginesManager)this.enginesManager).getModelsFromConnector(selectedConnector);
                selectedConnector.getParametersList().forEach(param -> {
                    Object value;
                    String paramId = param.getId();
                    Supplier<Object> valueSupplier = this.paramsInputsMap.get(this.getParameterKey(selectedConnector, (ConnectorParamBase)param));
                    if (valueSupplier != null && (value = valueSupplier.get()) != null) {
                        String valueAsString = PositronOptionsUtil.toStringValue((Object)value);
                        finalConfig.setParameter(paramId, valueAsString);
                        if (param.getType() == ConnectorParamType.MODEL_COMBO_BOX) {
                            Optional<ModelDescriptor> builtInModel = modelDescriptors.stream().filter(modelDesc -> modelDesc.getId().equals(valueAsString)).findFirst();
                            if (valueAsString != null && !valueAsString.isBlank() && builtInModel.isEmpty()) {
                                finalConfig.setParameter("connector_last_custom_model", valueAsString);
                            }
                        }
                    }
                });
                config = finalConfig;
            } else {
                PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage("No connector type selected.");
            }
        }
        return config;
    }

    private void addTextFieldParam(AIConnector connector, TextFieldConnectorParam param, GridBagConstraints gbc) {
        this.addParamLabelIfNeeded(connector, (ConnectorParamBase)param, gbc);
        TextFieldWithPlaceHolder textField = new TextFieldWithPlaceHolder(param.getPlaceholderText());
        ((JComponent)((Object)textField)).setToolTipText("".equals(param.getTooltip()) ? null : param.getTooltip());
        ((JComponent)((Object)textField)).setPreferredSize(new Dimension(100, ((JTextField)((Object)textField)).getPreferredSize().height));
        String value = (String)this.getValueForParam(connector, (ConnectorParamBase)param);
        ((JTextComponent)((Object)textField)).setText(value != null ? value : param.getDefaultValue());
        ((JTextComponent)((Object)textField)).setEditable(param.isEditable());
        this.parametersPanel.add((Component)((Object)textField), gbc);
        this.connectorParamsComponents.get(connector.getConnectorId()).add((Component)((Object)textField));
        this.paramsInputsMap.put(this.getParameterKey(connector, (ConnectorParamBase)param), ((JTextField)((Object)textField))::getText);
    }

    private void addPasswordTextFieldParam(AIConnector connector, final PasswordTextFieldConnectorParam param, GridBagConstraints gbc) {
        this.addParamLabelIfNeeded(connector, (ConnectorParamBase)param, gbc);
        JPanel passwordPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JPasswordField passwordField = new JPasswordField();
        passwordField.setPreferredSize(new Dimension(100, passwordField.getPreferredSize().height));
        passwordField.setEditable(param.isEditable());
        passwordField.setToolTipText("".equals(param.getTooltip()) ? null : param.getTooltip());
        String passwordValue = (String)this.getValueForParam(connector, (ConnectorParamBase)param);
        if (passwordValue == null) {
            passwordValue = param.getDefaultValue();
        }
        passwordField.setText(passwordValue != null ? passwordValue : "");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        passwordPanel.add((Component)passwordField, constraints);
        if (param.getExtraInfo() != null) {
            JButton extraInfoButton = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction(null, IconsLoader.loadIcon("/images/InlineHelp16.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String message = param.getExtraInfo();
                    PluginWorkspaceProvider.getPluginWorkspace().showInformationMessage(message);
                }
            }, (boolean)false);
            extraInfoButton.setToolTipText(param.getExtraInfo());
            ++constraints.gridx;
            constraints.weightx = 0.0;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 5, 0, 0);
            passwordPanel.add((Component)extraInfoButton, constraints);
        }
        this.parametersPanel.add((Component)passwordPanel, gbc);
        this.connectorParamsComponents.get(connector.getConnectorId()).add(passwordPanel);
        this.paramsInputsMap.put(this.getParameterKey(connector, (ConnectorParamBase)param), () -> SecurityHelper.getInstance().encryptText(new String(passwordField.getPassword())));
    }

    private void addCheckBoxParam(AIConnector connector, CheckBoxConnectorParam param, GridBagConstraints gbc) {
        ++gbc.gridx;
        gbc.gridwidth = 2;
        gbc.insets.top = 5;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        JCheckBox checkBox = new JCheckBox();
        gbc.insets.left -= checkBox.getInsets().left;
        checkBox.setText(param.getLabel());
        checkBox.setToolTipText("".equals(param.getTooltip()) ? null : param.getTooltip());
        Boolean selected = (Boolean)this.getValueForParam(connector, (ConnectorParamBase)param);
        checkBox.setSelected(selected != null ? selected : param.getDefaultValue());
        this.connectorParamsComponents.get(connector.getConnectorId()).add(checkBox);
        this.parametersPanel.add((Component)checkBox, gbc);
        this.paramsInputsMap.put(this.getParameterKey(connector, (ConnectorParamBase)param), checkBox::isSelected);
    }

    private void addParamLabelIfNeeded(AIConnector connector, ConnectorParamBase param, GridBagConstraints gbc) {
        ++gbc.gridx;
        if (param.getLabel() != null) {
            gbc.gridwidth = 1;
            gbc.weightx = 0.0;
            gbc.fill = 0;
            gbc.anchor = 17;
            JLabel paramLabel = new JLabel(param.getType() == ConnectorParamType.PASSWORD_TEXT_FIELD ? param.getLabel().replace(":", "*:") : param.getLabel());
            this.parametersPanel.add((Component)paramLabel, gbc);
            this.connectorParamsComponents.get(connector.getConnectorId()).add(paramLabel);
            ++gbc.gridx;
            gbc.insets.left = 5;
        } else {
            gbc.gridwidth = 2;
            gbc.anchor = 17;
        }
        gbc.weightx = 1.0;
        gbc.fill = 2;
    }

    private void addComboBoxParam(AIConnector connector, ComboConnectorParam param, GridBagConstraints gbc) {
        this.addParamLabelIfNeeded(connector, (ConnectorParamBase)param, gbc);
        JComboBox comboBox = OxygenUIComponentsFactory.createComboBox(new JComboBox().getModel());
        for (String value : param.getValues()) {
            comboBox.addItem(value);
        }
        comboBox.setPreferredSize(new Dimension(100, comboBox.getPreferredSize().height));
        comboBox.setToolTipText("".equals(param.getTooltip()) ? null : param.getTooltip());
        comboBox.setEditable(param.isEditable());
        String selectedValue = (String)this.getValueForParam(connector, (ConnectorParamBase)param);
        if (selectedValue == null) {
            selectedValue = param.getDefaultValue();
        }
        if (selectedValue != null && !selectedValue.isEmpty()) {
            comboBox.setSelectedItem(selectedValue);
        }
        this.parametersPanel.add((Component)comboBox, gbc);
        this.connectorParamsComponents.get(connector.getConnectorId()).add(comboBox);
        this.paramsInputsMap.put(this.getParameterKey(connector, (ConnectorParamBase)param), () -> String.valueOf(comboBox.getSelectedItem()));
    }

    private void addModelsComboBoxParam(AIConnector connector, ModelsComboConnectorParam param, GridBagConstraints gbc) {
        SerializableLinkedHashMap parameters;
        String savedCustom;
        ComboBoxItem currentItem;
        this.addParamLabelIfNeeded(connector, (ConnectorParamBase)param, gbc);
        List<ModelDescriptor> modelDescriptors = this.enginesManager instanceof EnterpriseEnginesManager ? ((EnterpriseEnginesManager)this.enginesManager).getModelsFromConnector(connector) : (List<ModelDescriptor>)param.getModelSupplier().get();
        LinkedHashMap<String, List<ModelDescriptor>> groupedModels = new LinkedHashMap<String, List<ModelDescriptor>>();
        groupedModels.put(connector.getConnectorId(), modelDescriptors);
        JComboBox<ComboBoxItem> comboBox = ModelsUIUtil.createGroupedModelsComboBox(groupedModels);
        comboBox.setPreferredSize(new Dimension(100, comboBox.getPreferredSize().height));
        String currentValue = (String)this.getValueForParam(connector, (ConnectorParamBase)param);
        if (currentValue == null || "<Default>".equals(currentValue)) {
            currentValue = param.getDefaultValue();
        }
        GroupedComboBoxModel model = (GroupedComboBoxModel)comboBox.getModel();
        if (currentValue != null && !currentValue.isBlank()) {
            ComboBoxItem currentItem2 = model.getItemByModelValue(currentValue);
            if (currentItem2 == null) {
                ComboBoxItem newItem = new ComboBoxItem(null, new ModelDescriptor(currentValue, currentValue, null));
                model.insertElementAt(newItem, 0);
            }
            model.setSelectedModelValue(currentValue);
        }
        if (this.connectionConfiguration != null && connector.getConnectorId().equals(this.connectionConfiguration.getConnectorId()) && (currentItem = model.getItemByModelValue(savedCustom = (String)(parameters = this.connectionConfiguration.getParameters()).get("connector_last_custom_model"))) == null) {
            model.insertElementAt(new ComboBoxItem(null, new ModelDescriptor(savedCustom, savedCustom, null)), 0);
        }
        this.installAIModelsSupport(comboBox);
        comboBox.setToolTipText("".equals(param.getTooltip()) ? null : param.getTooltip());
        comboBox.setEditable(true);
        ++gbc.insets.bottom;
        ++gbc.insets.top;
        this.connectorParamsComponents.get(connector.getConnectorId()).add(comboBox);
        this.parametersPanel.add(comboBox, gbc);
        --gbc.insets.bottom;
        --gbc.insets.top;
        this.paramsInputsMap.put(this.getParameterKey(connector, (ConnectorParamBase)param), () -> ((GroupedComboBoxModel)comboBox.getModel()).getSelectedModelValue());
    }

    private void installAIModelsSupport(JComboBox<ComboBoxItem> comboBox) {
        comboBox.setEditor(new BasicComboBoxEditor(){
            private ComboBoxItem currentSelectedItem = null;
            private String currentSelectedLabel = null;

            @Override
            public void setItem(Object anObject) {
                super.setItem(anObject);
                if (anObject instanceof String) {
                    String item = (String)anObject;
                    this.currentSelectedItem = new ComboBoxItem(null, new ModelDescriptor(item, item, null));
                    this.currentSelectedLabel = item;
                    this.editor.setText(this.currentSelectedLabel);
                } else {
                    this.currentSelectedItem = (ComboBoxItem)anObject;
                    this.currentSelectedLabel = this.currentSelectedItem.getDisplayText();
                    this.editor.setText(this.currentSelectedLabel);
                }
            }

            @Override
            public Object getItem() {
                if (this.currentSelectedLabel != null && this.currentSelectedLabel.equals(this.editor.getText())) {
                    return this.currentSelectedItem;
                }
                return super.getItem();
            }
        });
    }

    private void addKeyValueTableParam(AIConnector connector, KeyValueTableConnectorParam param, GridBagConstraints gbc) {
        gbc.gridwidth = 2;
        if (param.getLabel() != null) {
            gbc.fill = 0;
            JLabel paramLabel = new JLabel(param.getLabel());
            this.parametersPanel.add((Component)paramLabel, gbc);
            this.connectorParamsComponents.get(connector.getConnectorId()).add(paramLabel);
            ++gbc.gridy;
            gbc.insets.right = 0;
            gbc.insets.top = 3;
        }
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.weighty = 0.0;
        List keyValuePairs = (ArrayList)this.getValueForParam(connector, (ConnectorParamBase)param);
        if (keyValuePairs == null) {
            List defaultValue = param.getDefaultValue();
            if (defaultValue instanceof List) {
                List defaultPairs = defaultValue;
                keyValuePairs = defaultPairs;
            } else {
                keyValuePairs = new ArrayList();
            }
        }
        KeyValueTablePanel keyTablePanel = new KeyValueTablePanel(keyValuePairs);
        keyTablePanel.setPreferredSize(new Dimension(300, 100));
        keyTablePanel.setMinimumSize(new Dimension(200, 100));
        this.parametersPanel.add((Component)keyTablePanel, gbc);
        this.connectorParamsComponents.get(connector.getConnectorId()).add(keyTablePanel);
        this.paramsInputsMap.put(this.getParameterKey(connector, (ConnectorParamBase)param), keyTablePanel::getItems);
    }

    private void addMultilineLabelParam(AIConnector connector, final InfoMultilineLabelParam param, GridBagConstraints gbc) {
        if (param.getLabel() != null) {
            gbc.gridwidth = 2;
            gbc.fill = 0;
            JLabel paramLabel = new JLabel(param.getLabel());
            paramLabel.setToolTipText(param.getTooltip());
            this.parametersPanel.add((Component)paramLabel, gbc);
            this.connectorParamsComponents.get(connector.getConnectorId()).add(paramLabel);
            ++gbc.gridy;
            gbc.insets.right = 0;
            gbc.insets.top = 3;
        }
        JPanel rowPanel = new JPanel(new GridBagLayout());
        rowPanel.setOpaque(false);
        GridBagConstraints rowGbc = new GridBagConstraints();
        MultilineLabel multilineLabel = new MultilineLabel(param.getInfo());
        multilineLabel.setToolTipText(param.getTooltip());
        rowGbc.gridx = 0;
        rowGbc.gridy = 0;
        rowGbc.weightx = 1.0;
        rowGbc.fill = 2;
        rowGbc.anchor = 10;
        rowPanel.add((Component)multilineLabel, rowGbc);
        this.connectorParamsComponents.get(connector.getConnectorId()).add(multilineLabel);
        if (param.getMoreInfoURL() != null && !param.getMoreInfoURL().isEmpty()) {
            JLabel iconLabel = new JLabel(IconsLoader.loadIcon("/images/Help18.png"));
            iconLabel.setCursor(Cursor.getPredefinedCursor(12));
            iconLabel.setToolTipText(param.getTooltip());
            iconLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    new BrowserOpener().openWebpage(param.getMoreInfoURL());
                }
            });
            rowGbc.gridx = 1;
            rowGbc.weightx = 0.0;
            rowGbc.fill = 0;
            rowGbc.anchor = 10;
            rowGbc.insets = new Insets(0, 10, 0, 0);
            rowPanel.add((Component)iconLabel, rowGbc);
            this.connectorParamsComponents.get(connector.getConnectorId()).add(iconLabel);
        }
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.fill = 2;
        this.parametersPanel.add((Component)rowPanel, gbc);
        this.connectorParamsComponents.get(connector.getConnectorId()).add(rowPanel);
        ++gbc.gridy;
    }
}

