/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.preferences;

import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.positron.actions.dialog.internal.DialogType;
import com.oxygenxml.positron.actions.dialog.internal.MessageDialogBuilder;
import com.oxygenxml.positron.core.actions.ExcludedPositronActions;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.AIPositronInfo;
import com.oxygenxml.positron.plugin.AIServerInfoProvider;
import com.oxygenxml.positron.plugin.preferences.DataDeletionManager;
import com.oxygenxml.positron.plugin.ui.TextFieldWithPlaceHolder;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.UIUtil;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ro.sync.exml.plugin.option.OptionPagePluginExtension;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.PopupMenu;
import ro.sync.exml.workspace.api.standalone.ui.TextField;

public class ActionsOptionPageExtension
extends OptionPagePluginExtension {
    private static final AIServerInfoProvider AI_ACTIONS_INFO_PROVIDER = AIServerInfoProvider.getInstance();
    private static final Translator TRANSLATOR = Translator.getInstance();
    public static final int TEXT_FIELD_DEFAULT_WIDTH_LIMIT = 200;
    private TextField customActionsFolderField;
    private JCheckBox loadDefaultActionsCheckBox;
    private JCheckBox embeddedWidgetCheckbox;
    private JCheckBox showActionsAsButtonsCheckbox;
    private TextField ignoredActionIDsField;
    private JButton addActionIDsToFilterButton;

    public JComponent init(PluginWorkspace pluginWorkspace) {
        JPanel optionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.addActionsSection(optionPanel, gbc);
        this.loadPageState(pluginWorkspace);
        return optionPanel;
    }

    private void addActionsSection(JPanel mainPanel, GridBagConstraints gbc) {
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = UIUtil.getNoInsets();
        this.loadDefaultActionsCheckBox = new JCheckBox(Translator.getInstance().getTranslation("Load_Default_Actions"));
        mainPanel.add((Component)this.loadDefaultActionsCheckBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets = UIUtil.getNoInsets();
        gbc.insets.top = 5;
        gbc.insets.left = 5;
        JLabel projectsFolderLabel = new JLabel(Translator.getInstance().getTranslation("Actions_Folder_Label") + ":");
        mainPanel.add((Component)projectsFolderLabel, gbc);
        JPanel actionPathAndButton = new JPanel(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 0;
        c1.gridwidth = 1;
        c1.weightx = 1.0;
        c1.fill = 2;
        c1.anchor = 17;
        this.customActionsFolderField = OxygenUIComponentsFactory.createTextField();
        this.customActionsFolderField.setWidthLimit(200);
        this.customActionsFolderField.setToolTipText(Translator.getInstance().getTranslation("Actions_Folder_Info"));
        actionPathAndButton.add((Component)this.customActionsFolderField, c1);
        ++c1.gridx;
        c1.weightx = 0.0;
        c1.fill = 0;
        c1.insets.left = 5;
        actionPathAndButton.add((Component)UIUtil.createBrowseForDirOrFileButton((JTextField)this.customActionsFolderField, true), c1);
        ++gbc.gridx;
        gbc.gridwidth = 2;
        gbc.insets.left = 5;
        gbc.insets.top = 5;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        mainPanel.add((Component)actionPathAndButton, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.insets.left = 5;
        gbc.insets.top = 5;
        gbc.weightx = 0.0;
        JLabel ignoreIDsLabel = new JLabel(Translator.getInstance().getTranslation("Exclude_Actions_Label"));
        mainPanel.add((Component)ignoreIDsLabel, gbc);
        JPanel actionFilterAndButtonPanel = this.createFilterAndButtonPanel();
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = UIUtil.getNoInsets();
        gbc.insets.top = 5;
        gbc.insets.left = 5;
        mainPanel.add((Component)actionFilterAndButtonPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.insets = UIUtil.getNoInsets();
        gbc.insets.top = 5;
        this.embeddedWidgetCheckbox = new JCheckBox(Translator.getInstance().getTranslation("Embed_Widget_Assistant"));
        mainPanel.add((Component)this.embeddedWidgetCheckbox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.insets = UIUtil.getNoInsets();
        gbc.insets.top = 5;
        this.showActionsAsButtonsCheckbox = new JCheckBox(Translator.getInstance().getTranslation("Show_Actions_As_Buttons"));
        mainPanel.add((Component)this.showActionsAsButtonsCheckbox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = UIUtil.getNoInsets();
        mainPanel.add((Component)new JPanel(), gbc);
    }

    JPanel createFilterAndButtonPanel() {
        JPanel actionFilterAndButton = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        this.ignoredActionIDsField = new TextFieldWithPlaceHolder("E.g.: action.translate.to.english, action.create.release.notes");
        this.ignoredActionIDsField.setWidthLimit(200);
        this.ignoredActionIDsField.setToolTipText(Translator.getInstance().getTranslation("Filter_Actions_By_ID_Tooltip"));
        actionFilterAndButton.add((Component)this.ignoredActionIDsField, c);
        AbstractAction createAndShowFilterPopupAction = new AbstractAction(TRANSLATOR.getTranslation("Filter_Actions_By_ID_Tooltip_Button"), IconsLoader.loadIcon("/images/More16.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AI_ACTIONS_INFO_PROVIDER.isUserConnectedToPositron()) {
                    PopupMenu actionsToExcludeMenu = OxygenUIComponentsFactory.createPopupMenu();
                    ActionsOptionPageExtension.this.populatePopupFilterMenu(actionsToExcludeMenu);
                    actionsToExcludeMenu.show((Component)ActionsOptionPageExtension.this.addActionIDsToFilterButton, 0, ActionsOptionPageExtension.this.addActionIDsToFilterButton.getHeight());
                } else {
                    ActionsOptionPageExtension.this.showNotConnectedMessage();
                }
            }
        };
        this.addActionIDsToFilterButton = OxygenUIComponentsFactory.createToolbarButton((Action)createAndShowFilterPopupAction, (boolean)false);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets.left = 5;
        actionFilterAndButton.add((Component)this.addActionIDsToFilterButton, c);
        return actionFilterAndButton;
    }

    private void showNotConnectedMessage() {
        MessageDialogBuilder dialogBuilder = new MessageDialogBuilder(TRANSLATOR.getTranslation("Unauthorized"), DialogType.INFO);
        dialogBuilder.setMessage(MessageFormat.format(TRANSLATOR.getTranslation("not_connected_message"), "Oxygen AI Positron", AIPositronInfo.PRODUCT_NAME));
        dialogBuilder.setCancelButtonVisible(false);
        dialogBuilder.buildAndShow();
    }

    void populatePopupFilterMenu(PopupMenu popupMenu) {
        ArrayList<JMenu> menus = new ArrayList<JMenu>();
        List<AIActionDetails> allCompletionActions = AI_ACTIONS_INFO_PROVIDER.getAllCompletionActionsDetails();
        ExcludedPositronActions textFieldExcludedActions = new ExcludedPositronActions(this.ignoredActionIDsField.getText(), false, null);
        for (AIActionDetails actionDetails : allCompletionActions) {
            JMenuItem menuItem = this.createFilterMenuItemForPositronAction(actionDetails, textFieldExcludedActions);
            JMenu menu = this.getMenuForCategory(menus, actionDetails.getCategoryId());
            menu.add(menuItem);
            boolean isNewlyCreatedMenu = menus.stream().noneMatch(m -> m.getText().equals(menu.getText()));
            if (!isNewlyCreatedMenu) continue;
            menus.add(menu);
        }
        for (JMenu menu : menus) {
            popupMenu.add((JMenuItem)menu);
        }
    }

    private JMenuItem createFilterMenuItemForPositronAction(AIActionDetails positronAIActionDetails, ExcludedPositronActions textFieldExcludedActions) {
        AbstractAction action = this.createFilterMenuAction(positronAIActionDetails, textFieldExcludedActions);
        if (textFieldExcludedActions.isExcludedAction(positronAIActionDetails.getId())) {
            action.putValue("SwingSelectedKey", true);
        }
        return new JCheckBoxMenuItem(action);
    }

    private AbstractAction createFilterMenuAction(final AIActionDetails positronAIActionDetails, final ExcludedPositronActions excludedActions) {
        AbstractAction action = new AbstractAction(positronAIActionDetails.getTitle()){

            @Override
            public void actionPerformed(ActionEvent e) {
                String actionID = positronAIActionDetails.getId();
                if (excludedActions.isExcludedAction(actionID)) {
                    excludedActions.removeActionID(actionID);
                } else {
                    excludedActions.addActionID(actionID);
                }
                ActionsOptionPageExtension.this.ignoredActionIDsField.setText(excludedActions.serializeIDsOfExcludedActions());
            }
        };
        action.putValue("ShortDescription", positronAIActionDetails.getDescription());
        return action;
    }

    private JMenu getMenuForCategory(List<JMenu> existingMenus, String categoryId) {
        Optional<JMenu> existingMenu = existingMenus.stream().filter(m -> m.getText().equals(this.getMenuTextForCategory(categoryId))).findFirst();
        return existingMenu.isPresent() ? existingMenu.get() : OxygenUIComponentsFactory.createMenu((String)this.getMenuTextForCategory(categoryId));
    }

    private String getMenuTextForCategory(String categoryId) {
        return categoryId != null ? categoryId : "Other";
    }

    public void apply(PluginWorkspace pluginWorkspace) {
        if (DataDeletionManager.getInstance().wasDataDeleted()) {
            return;
        }
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        if (optionsStorage != null) {
            optionsStorage.setOption("oxygen.positron.plugin.actions.folder", this.customActionsFolderField.getText());
            optionsStorage.setOption("oxygen.positron.plugin.load.default.actions", String.valueOf(this.loadDefaultActionsCheckBox.isSelected()));
            optionsStorage.setOption("oxygen.positron.plugin.ignore.actions", String.valueOf(this.ignoredActionIDsField.getText()));
            optionsStorage.setOption("oxygen.positron.plugin.enable.embedded.widget", String.valueOf(this.embeddedWidgetCheckbox.isSelected()));
            optionsStorage.setOption("oxygen.positron.plugin.show.actions.as.buttons.chat", String.valueOf(this.showActionsAsButtonsCheckbox.isSelected()));
        }
    }

    private void loadPageState(PluginWorkspace pluginWorkspace) {
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        if (optionsStorage != null) {
            this.customActionsFolderField.setText(optionsStorage.getOption("oxygen.positron.plugin.actions.folder", "${pd}/positron-ai-actions"));
            this.loadDefaultActionsCheckBox.setSelected(Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.load.default.actions", String.valueOf(Boolean.TRUE))));
            this.embeddedWidgetCheckbox.setSelected(Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.enable.embedded.widget", String.valueOf(Boolean.TRUE))));
            this.ignoredActionIDsField.setText(optionsStorage.getOption("oxygen.positron.plugin.ignore.actions", ""));
            this.showActionsAsButtonsCheckbox.setSelected(Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.show.actions.as.buttons.chat", String.valueOf(Boolean.FALSE))));
        }
    }

    public void restoreDefaults() {
        this.customActionsFolderField.setText("${pd}/positron-ai-actions");
        this.loadDefaultActionsCheckBox.setSelected(true);
        this.ignoredActionIDsField.setText("");
        this.embeddedWidgetCheckbox.setSelected(true);
        this.showActionsAsButtonsCheckbox.setSelected(false);
    }

    public String getTitle() {
        return TRANSLATOR.getTranslation("Actions");
    }

    public String[] getProjectLevelOptionKeys() {
        return new String[]{"oxygen.positron.plugin.actions.folder", "oxygen.positron.plugin.load.default.actions", "oxygen.positron.plugin.ignore.actions"};
    }

    public String getKey() {
        return "actions_preferences_page";
    }

    @VisibleForTesting
    TextField getIgnoreActionIDs() {
        return this.ignoredActionIDsField;
    }

    public String getHelpPageURL() {
        return "https://www.oxygenxml.com/doc/ug-positron-desktop/ai/actions_preferences.html";
    }
}

