/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.preferences;

import com.oxygenxml.positron.api.connector.AIConnector;
import com.oxygenxml.positron.api.connector.param.ConnectorParamBase;
import com.oxygenxml.positron.api.connector.param.ConnectorParamType;
import com.oxygenxml.positron.api.connector.param.ModelsComboConnectorParam;
import com.oxygenxml.positron.connector.AIConnectorConfigsManager;
import com.oxygenxml.positron.connector.AIConnectorConfiguration;
import com.oxygenxml.positron.connector.ConnectorConfigurationData;
import com.oxygenxml.positron.connector.ConnectorConfigurationsPO;
import com.oxygenxml.positron.core.api.PositronServiceModelsManager;
import com.oxygenxml.positron.core.auth.BrowserOpener;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.AIModelsUtil;
import com.oxygenxml.positron.plugin.AIPositronInfo;
import com.oxygenxml.positron.plugin.AIServerInfoProvider;
import com.oxygenxml.positron.plugin.ConnectionConfigUtil;
import com.oxygenxml.positron.plugin.ModelsUIUtil;
import com.oxygenxml.positron.plugin.engine.SaasEnginesManager;
import com.oxygenxml.positron.plugin.license.DirectConnectionLicenseManager;
import com.oxygenxml.positron.plugin.preferences.AddEditConnectionDialog;
import com.oxygenxml.positron.plugin.preferences.ConnectionTableModel;
import com.oxygenxml.positron.plugin.preferences.ConnectionTablePanel;
import com.oxygenxml.positron.plugin.preferences.DataDeletionManager;
import com.oxygenxml.positron.plugin.ui.ComboBoxItem;
import com.oxygenxml.positron.plugin.ui.GroupedComboBoxModel;
import com.oxygenxml.positron.plugin.ui.MultilineLabel;
import com.oxygenxml.positron.plugin.ui.SectionPane;
import com.oxygenxml.positron.plugin.util.AiPositronServiceAccess;
import com.oxygenxml.positron.plugin.util.AiPositronServiceConnectionInfoHelper;
import com.oxygenxml.positron.plugin.util.DirectConnectionConfigurationHelper;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.UIUtil;
import com.oxygenxml.positron.utilities.ModelIdentifierUtil;
import com.oxygenxml.positron.utilities.json.Engine;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import ro.sync.exml.plugin.option.OptionPagePluginExtension;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.ExternalPersistentObject;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.TextField;

public class AIServiceConfigurationPage
extends OptionPagePluginExtension {
    private static final Translator I18N = Translator.getInstance();
    private static final int DEFAULT_INSET = 7;
    private static final int SPACE_BETWEEN_GROUPED_ELEMENTS_INSET = 3;
    private static final JRadioButton DEFAULT_RADIO_BUTTON = new JRadioButton();
    private MultilineLabel engineInfoLabel;
    private JLabel warningLabelWithIcon;
    private TextField serviceAddressField;
    private JComboBox<ComboBoxItem> defaultModelCombo;
    private ConnectionTablePanel connectionTablePanel;
    private JLabel directConnectionsLabel;
    private JPanel optionPanel;
    public static final int TEXT_FIELD_DEFAULT_WIDTH_LIMIT = 200;
    private static final String CREDITS_EXPLANATION_LINK = "https://aipositron.oxygenxml.com/#credits";
    private String lastProcessedConfigurationId;
    private static final JCheckBox DUMMY_CHECKBOX = new JCheckBox();
    private static final int JCHECKBOX_WIDTH = AIServiceConfigurationPage.DUMMY_CHECKBOX.getPreferredSize().width;
    private JCheckBox enableAiPositronServiceConnections;
    private static final String CREATED_NEW_CONNECTION = "created-new-connection";
    private PositronServiceModelsManager.ModelsChangedListener modelsChangedListener;

    private static String getDefaultPositronServiceModel() {
        return AiPositronServiceAccess.getInstance().buildPositronServiceDefaultModelIdentifier();
    }

    public void apply(PluginWorkspace pluginWorkspace) {
        if (DataDeletionManager.getInstance().wasDataDeleted()) {
            return;
        }
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        if (optionsStorage != null) {
            this.applyDirectOptions(optionsStorage);
            this.applyPositronServiceOptions(optionsStorage);
        }
    }

    private void applyPositronServiceOptions(WSOptionsStorage optionsStorage) {
        boolean isNotConnectedPlaceholder;
        optionsStorage.setOption("oxygen.positron.plugin.positron.address", this.serviceAddressField.getText());
        boolean oldOptionValue = Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.enable.positron.service", String.valueOf(Boolean.TRUE)));
        boolean isPositronServiceConnectionEnabled = this.enableAiPositronServiceConnections.isSelected();
        optionsStorage.setOption("oxygen.positron.plugin.enable.positron.service", String.valueOf(isPositronServiceConnectionEnabled));
        if (oldOptionValue != isPositronServiceConnectionEnabled) {
            if (isPositronServiceConnectionEnabled) {
                AiPositronServiceConnectionInfoHelper.getInstance().connectToPositronService();
            } else {
                AiPositronServiceConnectionInfoHelper.getInstance().disconnectFromPositronService();
            }
        }
        String selEngine = null;
        if (this.defaultModelCombo.getModel() instanceof GroupedComboBoxModel) {
            selEngine = ((GroupedComboBoxModel)this.defaultModelCombo.getModel()).getSelectedModelValue();
        }
        if (!(isNotConnectedPlaceholder = SaasEnginesManager.isNotConnectedPlaceholderModel(selEngine)) && selEngine != null) {
            String[] splitModelIdentifier = ModelIdentifierUtil.splitModelIdentifier((String)selEngine);
            String modelId = splitModelIdentifier[1];
            Engine defaultEngine = AIServerInfoProvider.getInstance().getModelsManager().getDefaultEngine();
            if (modelId != null && modelId.equals(defaultEngine.getId())) {
                selEngine = null;
            }
            optionsStorage.setOption("default.engine.model", selEngine == null || selEngine.isEmpty() ? null : selEngine);
        }
    }

    void applyDirectOptions(WSOptionsStorage optionsStorage) {
        this.saveConnectionsFromTable(optionsStorage);
    }

    private void saveConnectionsFromTable(WSOptionsStorage optionsStorage) {
        if (this.connectionTablePanel != null) {
            List<ConnectorConfigurationData> connections = this.connectionTablePanel.getModel().getConnections();
            ConnectorConfigurationsPO connectorConfigurations = (ConnectorConfigurationsPO)optionsStorage.getPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)new ConnectorConfigurationsPO());
            ConnectionConfigUtil.deletePasswordOptionsForConfigurations(optionsStorage, connectorConfigurations);
            connectorConfigurations.getConfigurations().clear();
            for (ConnectorConfigurationData connection : connections) {
                ConnectorConfigurationData configForPO = connection.clone();
                Optional<AIConnector> connectorOpt = AIConnectorConfigsManager.getInstance().getConnectorTypes().stream().filter(c -> c.getConnectorId().equals(connection.getConnectorId())).findFirst();
                if (connectorOpt.isPresent()) {
                    AIConnector connector = connectorOpt.get();
                    connector.getParametersList().forEach(param -> {
                        String paramValue;
                        if (param.getType() == ConnectorParamType.PASSWORD_TEXT_FIELD && (paramValue = (String)connection.getParameters().get((Object)param.getId())) != null) {
                            configForPO.getParameters().remove((Object)param.getId());
                            String paramOptionId = DirectConnectionConfigurationHelper.computeOptionIdentifier(connection.getConfigurationId(), connector.getConnectorId(), param.getId());
                            optionsStorage.setOption(paramOptionId, paramValue);
                        }
                    });
                }
                connectorConfigurations.getConfigurations().put(connection.getConfigurationId(), configForPO);
            }
            if (!connections.isEmpty() && this.lastProcessedConfigurationId != null) {
                connections.stream().filter(c -> c.getConfigurationId().equals(this.lastProcessedConfigurationId)).findFirst().ifPresent(c -> connectorConfigurations.setCurrentConfigurationId(this.lastProcessedConfigurationId));
            }
            connectorConfigurations.updateConfigurationsOrder();
            optionsStorage.setPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)connectorConfigurations);
            this.updateAutocompletionConfiguration(optionsStorage, connections);
        }
    }

    private void updateAutocompletionConfiguration(WSOptionsStorage optionsStorage, List<ConnectorConfigurationData> connections) {
        String selectedModelId;
        Optional<ConnectorConfigurationData> lastProcessedConn;
        String modelSelectedFromConnector = optionsStorage.getOption("oxygen.positron.plugin.autocompletion.connector", null);
        if (modelSelectedFromConnector == CREATED_NEW_CONNECTION && this.lastProcessedConfigurationId != null && (lastProcessedConn = connections.stream().filter(c -> c.getConfigurationId().equals(this.lastProcessedConfigurationId)).findFirst()).isPresent() && (selectedModelId = this.getSelectedModelForConfiguration(this.lastProcessedConfigurationId, lastProcessedConn.get())) != null) {
            optionsStorage.setOption("oxygen.positron.plugin.autocompletion.configurations", selectedModelId);
            return;
        }
    }

    private String getSelectedModelForConfiguration(String configurationId, ConnectorConfigurationData configData) {
        ConnectorParamBase modelParam;
        AIConnector connector;
        if (configData != null && (connector = (AIConnector)AIConnectorConfigsManager.getInstance().getConnectorTypes().stream().filter(c -> c.getConnectorId().equals(configData.getConnectorId())).findFirst().orElse(null)) != null && (modelParam = (ConnectorParamBase)connector.getParametersList().stream().filter(param -> param.getType() == ConnectorParamType.MODEL_COMBO_BOX).findFirst().orElse(null)) != null) {
            String selectedModel = (String)configData.getParameters().get((Object)modelParam.getId());
            if (selectedModel == null && modelParam instanceof ModelsComboConnectorParam) {
                selectedModel = ((ModelsComboConnectorParam)modelParam).getDefaultValue();
            }
            if (selectedModel != null) {
                return ModelIdentifierUtil.buildModelIdentifier((String)configurationId, (String)selectedModel);
            }
        }
        return null;
    }

    public void restoreDefaults() {
        this.restoreDirectConnectionDefaults();
        this.restorePositronServiceDefaults();
    }

    private void restoreDirectConnectionDefaults() {
        if (this.connectionTablePanel != null) {
            this.connectionTablePanel.getModel().setConnections(new ArrayList<ConnectorConfigurationData>());
        }
    }

    private void restorePositronServiceDefaults() {
        this.enableAiPositronServiceConnections.setSelected(true);
        this.serviceAddressField.setText("https://aipositron.oxygenxml.com");
        if (this.defaultModelCombo.getModel() instanceof GroupedComboBoxModel) {
            String desired = AIServiceConfigurationPage.getDefaultPositronServiceModel();
            ((GroupedComboBoxModel)this.defaultModelCombo.getModel()).setSelectedModelValue(desired);
        }
    }

    public String getTitle() {
        return I18N.getTranslation("AI_Service_Configuration");
    }

    public JComponent init(PluginWorkspace pluginWorkspace) {
        this.optionPanel = new JPanel(new GridBagLayout());
        this.initializeDirectConnectionElements(pluginWorkspace);
        this.initializePositronServiceElements();
        this.loadPageState(pluginWorkspace);
        this.computeUILayout();
        this.optionPanel.setPreferredSize(new Dimension(300, this.optionPanel.getPreferredSize().height));
        return this.optionPanel;
    }

    private void initializeDirectConnectionElements(PluginWorkspace pluginWorkspace) {
        this.directConnectionsLabel = new JLabel(I18N.getTranslation("Configure_Direct_Connections_Label"));
        List<ConnectorConfigurationData> existingConnections = this.loadExistingConnections();
        this.connectionTablePanel = new ConnectionTablePanel(existingConnections);
        this.connectionTablePanel.setAddConnectionListener(() -> this.showAddConnectionDialog(pluginWorkspace));
        this.connectionTablePanel.setEditConnectionListener(this::showEditConnectionDialog);
    }

    private void initializePositronServiceElements() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        this.enableAiPositronServiceConnections = new JCheckBox(I18N.getTranslation("Enable_connections_to_AI_Positron_Service"));
        this.enableAiPositronServiceConnections.addItemListener(e -> {
            this.updatePositronAiServiceComponentsEnabledState();
            if (e.getStateChange() == 1) {
                GroupedComboBoxModel model = ModelsUIUtil.createGroupedModelsComboBoxModel(new SaasEnginesManager().getAvailableEngines(), false);
                this.defaultModelCombo.setModel(model);
                String desired = AIServiceConfigurationPage.getDefaultPositronServiceModel();
                model.setSelectedModelValue(desired);
            }
        });
        this.serviceAddressField = OxygenUIComponentsFactory.createTextField();
        this.serviceAddressField.setWidthLimit(200);
        this.defaultModelCombo = ModelsUIUtil.createGroupedModelsComboBox(ModelsUIUtil.collectPositronServiceModels(), false);
        this.engineInfoLabel = new MultilineLabel(this.computeCurrentSelectedEngineInfoLabel());
        this.warningLabelWithIcon = new JLabel(IconsLoader.loadIcon("/images/Warning16.png"));
        this.warningLabelWithIcon.setVisible(SaasEnginesManager.isNotConnectedPlaceholderModel(this.getSelectedModelCombo()));
        this.defaultModelCombo.addItemListener(e -> {
            ComboBoxItem selectedItem;
            if (e.getStateChange() == 1 && (selectedItem = (ComboBoxItem)this.defaultModelCombo.getSelectedItem()) != null && selectedItem.getValue() != null) {
                this.engineInfoLabel.setText(selectedItem.getDescription());
            }
        });
        optionsStorage.addOptionListener(new WSOptionListener("default.engine.model"){

            public void optionValueChanged(WSOptionChangedEvent arg0) {
                String modelValue = AIModelsUtil.getAIModelFromOptions((String)"default.engine.model");
                if (AIServiceConfigurationPage.this.defaultModelCombo.getModel() instanceof GroupedComboBoxModel) {
                    ((GroupedComboBoxModel)AIServiceConfigurationPage.this.defaultModelCombo.getModel()).setSelectedModelValue(modelValue);
                }
            }
        });
        if (this.modelsChangedListener == null) {
            this.modelsChangedListener = () -> SwingUtilities.invokeLater(() -> {
                WSOptionsStorage wsOptionStorage;
                if (this.defaultModelCombo != null) {
                    GroupedComboBoxModel model = ModelsUIUtil.createGroupedModelsComboBoxModel(ModelsUIUtil.collectPositronServiceModels(), false);
                    this.defaultModelCombo.setModel(model);
                }
                WSOptionsStorage wSOptionsStorage = wsOptionStorage = PluginWorkspaceProvider.getPluginWorkspace() != null ? PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage() : null;
                if (wsOptionStorage != null) {
                    this.loadPositronServiceOptionValues(wsOptionStorage);
                }
            });
            PositronServiceModelsManager modelsManager = AIServerInfoProvider.getInstance().getModelsManager();
            if (modelsManager != null) {
                modelsManager.addModelsChangedListener(this.modelsChangedListener);
            }
        }
    }

    private String computeCurrentSelectedEngineInfoLabel() {
        String translation = I18N.getTranslation("Default_model_explanation");
        boolean notConnectedPlaceholderModel = SaasEnginesManager.isNotConnectedPlaceholderModel(this.getSelectedModelCombo());
        if (notConnectedPlaceholderModel) {
            translation = MessageFormat.format(I18N.getTranslation("not_connected_message"), "Oxygen AI Positron", AIPositronInfo.PRODUCT_NAME);
        }
        return translation;
    }

    private String getSelectedModelCombo() {
        if (this.defaultModelCombo.getModel() instanceof GroupedComboBoxModel) {
            return ((GroupedComboBoxModel)this.defaultModelCombo.getModel()).getSelectedModelValue();
        }
        return null;
    }

    private void computeUILayout() {
        this.optionPanel.removeAll();
        this.optionPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.optionPanel.add((Component)new SectionPane(I18N.getTranslation("Connections"), true), gbc);
        if (!DirectConnectionLicenseManager.getInstance().isCoveredByOxygenEnterpriseLicense()) {
            ++gbc.gridy;
            gbc.fill = 2;
            gbc.insets.left = 0;
            gbc.anchor = 17;
            String hintMessage = MessageFormat.format(I18N.getTranslation("To_connect_to_other_ai_services_you_need_Positron_Enterprise_license"), PluginWorkspaceProvider.getPluginWorkspace().getApplicationName());
            JComponent hintLabel = OxygenUIComponentsFactory.createMultilineLabel((String)hintMessage, (boolean)false);
            this.optionPanel.add((Component)hintLabel, gbc);
            JButton configureDirectConnectionLicenseBtn = OxygenUIComponentsFactory.createButton((Action)new AbstractAction(I18N.getTranslation("Configure_license_key_sentence_cap") + "..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DirectConnectionLicenseManager.getInstance().askForLicense();
                }
            });
            DirectConnectionLicenseManager.getInstance().addDirectConnectionLicenseListener(() -> {
                boolean isLicenseForDirectConnectionValid = DirectConnectionConfigurationHelper.isLicenseForDirectConnectionValid();
                hintLabel.setVisible(!isLicenseForDirectConnectionValid);
                configureDirectConnectionLicenseBtn.setVisible(!isLicenseForDirectConnectionValid);
                this.directConnectionsLabel.setVisible(isLicenseForDirectConnectionValid);
                this.connectionTablePanel.setVisible(isLicenseForDirectConnectionValid);
            });
            ++gbc.gridy;
            gbc.insets.bottom = 0;
            gbc.fill = 0;
            this.optionPanel.add((Component)configureDirectConnectionLicenseBtn, gbc);
            boolean isValidLicense = DirectConnectionConfigurationHelper.isLicenseForDirectConnectionValid();
            hintLabel.setVisible(!isValidLicense);
            configureDirectConnectionLicenseBtn.setVisible(!isValidLicense);
            this.directConnectionsLabel.setVisible(isValidLicense);
            this.connectionTablePanel.setVisible(isValidLicense);
        }
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.insets = UIUtil.getNoInsets();
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.insets.top = 3;
        this.optionPanel.add((Component)this.directConnectionsLabel, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weighty = 0.5;
        gbc.weightx = 1.0;
        gbc.insets.top = 5;
        this.optionPanel.add((Component)this.connectionTablePanel, gbc);
        if (AiPositronServiceAccess.getInstance().hasAccessToAiPositronService()) {
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 3;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.insets.top = 10;
            this.optionPanel.add((Component)new SectionPane(I18N.getTranslation("AI_Positron_Service"), true), gbc);
            ++gbc.gridy;
            this.addAIPositronServiceElements(this.optionPanel, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = UIUtil.getNoInsets();
        this.optionPanel.add((Component)new JPanel(), gbc);
        this.optionPanel.revalidate();
        this.optionPanel.repaint();
    }

    private List<ConnectorConfigurationData> loadExistingConnections() {
        ArrayList<ConnectorConfigurationData> connections = new ArrayList<ConnectorConfigurationData>();
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        if (optionsStorage != null) {
            ConnectorConfigurationsPO config = (ConnectorConfigurationsPO)optionsStorage.getPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)new ConnectorConfigurationsPO());
            for (ConnectorConfigurationData configData : config.getConfigurations().values()) {
                ConnectorConfigurationData loadedConfig = configData.clone();
                Optional<AIConnector> connectorOpt = AIConnectorConfigsManager.getInstance().getConnectorTypes().stream().filter(c -> c.getConnectorId().equals(configData.getConnectorId())).findFirst();
                if (connectorOpt.isPresent()) {
                    AIConnector connector = connectorOpt.get();
                    connector.getParametersList().forEach(param -> {
                        AIConnectorConfiguration tempConfig;
                        String paramOptionId;
                        String passwordValue;
                        if (param.getType() == ConnectorParamType.PASSWORD_TEXT_FIELD && !(passwordValue = optionsStorage.getOption(paramOptionId = DirectConnectionConfigurationHelper.computeOptionIdentifier(tempConfig = new AIConnectorConfiguration(configData.getName(), connector), param), "")).isEmpty()) {
                            loadedConfig.setParameter(param.getId(), passwordValue);
                        }
                    });
                }
                connections.add(loadedConfig);
            }
        }
        return connections;
    }

    private ConnectorConfigurationData loadPasswordsForConnection(ConnectorConfigurationData connectionData) {
        ConnectorConfigurationData result = connectionData.clone();
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        AIConnectorConfiguration configuration = AIConnectorConfigsManager.getInstance().getConfigurationById(connectionData.getConfigurationId());
        if (configuration != null) {
            AIConnector connector = configuration.getConnector();
            connector.getParametersList().forEach(param -> {
                String paramOptionId;
                String passwordValue;
                if (param.getType() == ConnectorParamType.PASSWORD_TEXT_FIELD && !(passwordValue = optionsStorage.getOption(paramOptionId = DirectConnectionConfigurationHelper.computeOptionIdentifier(configuration, param), "")).isEmpty()) {
                    result.setParameter(param.getId(), passwordValue);
                }
            });
        }
        return result;
    }

    private void showAddConnectionDialog(PluginWorkspace pluginWorkspace) {
        List<ConnectorConfigurationData> existingConnections = this.connectionTablePanel.getModel().getConnections();
        AddEditConnectionDialog dialog = new AddEditConnectionDialog(this.optionPanel, existingConnections);
        dialog.setVisible(true);
        ConnectorConfigurationData newConnection = dialog.getConnectionConfiguration();
        if (newConnection != null) {
            this.lastProcessedConfigurationId = newConnection.getConfigurationId();
            this.connectionTablePanel.addConnection(newConnection);
            pluginWorkspace.getOptionsStorage().setOption("oxygen.positron.plugin.autocompletion.connector", CREATED_NEW_CONNECTION);
        }
    }

    private void showEditConnectionDialog(ConnectorConfigurationData connectionData) {
        ConnectorConfigurationData connectionWithPasswords = this.loadPasswordsForConnection(connectionData);
        List<ConnectorConfigurationData> existingConnections = this.connectionTablePanel.getModel().getConnections();
        AddEditConnectionDialog dialog = new AddEditConnectionDialog(this.optionPanel, connectionWithPasswords, existingConnections);
        dialog.setVisible(true);
        ConnectorConfigurationData editedConnection = dialog.getConnectionConfiguration();
        if (editedConnection != null) {
            ConnectionTableModel model = this.connectionTablePanel.getModel();
            boolean updated = false;
            for (int i = 0; i < model.getRowCount(); ++i) {
                ConnectorConfigurationData existing = model.getConnectionAt(i);
                if (!existing.getConfigurationId().equals(connectionData.getConfigurationId())) continue;
                model.updateConnection(i, editedConnection);
                updated = true;
                break;
            }
            this.lastProcessedConfigurationId = editedConnection.getConfigurationId();
            if (!updated) {
                String message = "Could not find connection to update in table.";
                PluginWorkspaceProvider.getPluginWorkspace().showWarningMessage(message);
            }
        }
    }

    private void addAIPositronServiceElements(JPanel optionPanel, GridBagConstraints gbc) {
        int leftInset;
        gbc.insets.top = 7 - AIServiceConfigurationPage.DEFAULT_RADIO_BUTTON.getInsets().bottom;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        optionPanel.add((Component)this.enableAiPositronServiceConnections, gbc);
        gbc.insets.left = leftInset = JCHECKBOX_WIDTH - AIServiceConfigurationPage.DUMMY_CHECKBOX.getInsets().left;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets.left = leftInset;
        optionPanel.add((Component)new JLabel(I18N.getTranslation("Address") + ":"), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 256;
        gbc.insets.left = 5;
        optionPanel.add((Component)this.serviceAddressField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets.top = 7;
        gbc.insets.left = leftInset;
        optionPanel.add((Component)new JLabel(I18N.getTranslation("Default_model") + ":"), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 256;
        gbc.insets.left = 5;
        optionPanel.add((Component)this.createEngineModelComboPanel(), gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.insets.top = 3;
        gbc.anchor = 17;
        gbc.insets.left = 5;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(null);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 0;
        c.anchor = 17;
        c.insets.right = 5;
        jPanel.add((Component)this.warningLabelWithIcon, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.insets.right = 0;
        c.fill = 1;
        jPanel.add((Component)this.engineInfoLabel, c);
        optionPanel.add((Component)jPanel, gbc);
    }

    private JPanel createEngineModelComboPanel() {
        JPanel enginePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 256;
        enginePanel.add(this.defaultModelCombo, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets.left = 3;
        JButton linkButon = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction(I18N.getTranslation("More_details"), IconsLoader.loadIcon("/images/Help12.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                new BrowserOpener().openWebpage(AIServiceConfigurationPage.CREDITS_EXPLANATION_LINK);
            }
        }, (boolean)false);
        linkButon.setMargin(new Insets(1, 1, 1, 1));
        enginePanel.add((Component)linkButon, gbc);
        return enginePanel;
    }

    private void loadPageState(PluginWorkspace pluginWorkspace) {
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        if (optionsStorage != null) {
            this.loadDirectConectionState(optionsStorage);
            this.loadPositronServiceOptionValues(optionsStorage);
        }
    }

    private void loadPositronServiceOptionValues(WSOptionsStorage optionsStorage) {
        String aiServiceURL = optionsStorage.getOption("oxygen.positron.plugin.positron.address", "https://aipositron.oxygenxml.com");
        this.serviceAddressField.setText(aiServiceURL);
        this.enableAiPositronServiceConnections.setSelected(Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.enable.positron.service", String.valueOf(Boolean.TRUE))));
        this.updatePositronAiServiceComponentsEnabledState();
        String savedModel = Optional.ofNullable(AIModelsUtil.getAIModelFromOptions((String)"default.engine.model")).orElse(AIServiceConfigurationPage.getDefaultPositronServiceModel());
        if (this.defaultModelCombo.getModel() instanceof GroupedComboBoxModel) {
            if (AiPositronServiceConnectionInfoHelper.getInstance().isConnectedToPositronService()) {
                ((GroupedComboBoxModel)this.defaultModelCombo.getModel()).setSelectedModelValue(savedModel);
            } else {
                ((GroupedComboBoxModel)this.defaultModelCombo.getModel()).setSelectedModelValue(ModelIdentifierUtil.buildModelIdentifier((String)"aips", (String)SaasEnginesManager.notConnectedModelDescriptor.getId()));
            }
        }
    }

    private void updatePositronAiServiceComponentsEnabledState() {
        boolean isPositronServicePlatforAccessEnabledFromCheckbox = this.enableAiPositronServiceConnections.isSelected();
        this.serviceAddressField.setEnabled(isPositronServicePlatforAccessEnabledFromCheckbox);
        boolean isDefaultModelComboEnabled = isPositronServicePlatforAccessEnabledFromCheckbox && AiPositronServiceConnectionInfoHelper.getInstance().isConnectedToPositronService();
        this.defaultModelCombo.setEnabled(isDefaultModelComboEnabled);
        if (!isDefaultModelComboEnabled) {
            this.engineInfoLabel.setText(this.computeCurrentSelectedEngineInfoLabel());
        }
        this.warningLabelWithIcon.setVisible(!isDefaultModelComboEnabled);
    }

    private void loadDirectConectionState(WSOptionsStorage optionsStorage) {
        if (this.connectionTablePanel != null) {
            List<ConnectorConfigurationData> existingConnections = this.loadExistingConnections();
            this.connectionTablePanel.getModel().setConnections(existingConnections);
        }
    }

    public String[] getProjectLevelOptionKeys() {
        return new String[]{"oxygen.positron.plugin.connector.configurations", "default.engine.model", "oxygen.positron.plugin.positron.address", "oxygen.positron.plugin.enable.positron.service"};
    }

    public String getKey() {
        return "Positron_addon_preferences_engine_page";
    }

    public String getHelpPageURL() {
        return "https://www.oxygenxml.com/doc/ug-positron-desktop/ai/service_configuration.html";
    }
}

