/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.preferences;

import com.oxygenxml.positron.core.actions.types.AIAutocompletionEditorTypesEntryTable;
import com.oxygenxml.positron.core.actions.types.AIAutocompletionEditorTypesEntryTablePO;
import com.oxygenxml.positron.core.actions.types.AIAutocompletionProvider;
import com.oxygenxml.positron.core.actions.types.AIAutocompletionUtil;
import com.oxygenxml.positron.core.api.PositronServiceModelsManager;
import com.oxygenxml.positron.core.engines.EnginesManagerProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.AIServerInfoProvider;
import com.oxygenxml.positron.plugin.ModelsUIUtil;
import com.oxygenxml.positron.plugin.engine.SaasEnginesManager;
import com.oxygenxml.positron.plugin.preferences.AIAutocompletionEditorTypesTablePanel;
import com.oxygenxml.positron.plugin.preferences.DataDeletionManager;
import com.oxygenxml.positron.plugin.ui.ComboBoxItem;
import com.oxygenxml.positron.plugin.ui.GroupedComboBoxModel;
import com.oxygenxml.positron.plugin.ui.SectionPane;
import com.oxygenxml.positron.plugin.util.AiPositronServiceAccess;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ro.sync.exml.plugin.option.OptionPagePluginExtension;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.options.ExternalPersistentObject;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class AIAutocompletionOptionPageExtension
extends OptionPagePluginExtension {
    private static final String SELECTED_FROM_AI_AUTOCOMPLETION = "selected-from-ai-autocompletion";
    private static final Translator TRANSLATOR = Translator.getInstance();
    private JCheckBox enableAIAutocompletion;
    private JCheckBox includeAssociatedInstanceInPrompt;
    private JComboBox<ComboBoxItem> defaultModelCombo;
    private SectionPane editorTypesSectionPane;
    private JLabel editorTableDescription;
    private AIAutocompletionEditorTypesTablePanel editorTypesTablePanel;
    private JLabel defaultModelLabel;
    private PluginWorkspace pluginWorkspace;
    private WSOptionListener connectionConfigurationListener;
    private PositronServiceModelsManager.ModelsChangedListener modelsChangedListener;
    private static final JCheckBox DUMMY_CHECKBOX = new JCheckBox();
    private static final int DEFAULT_LEFT_INSETS = AIAutocompletionOptionPageExtension.DUMMY_CHECKBOX.getPreferredSize().width;

    private static String getDefaultModel() {
        return AiPositronServiceAccess.getInstance().buildPositronServiceDefaultModelIdentifier();
    }

    public JComponent init(PluginWorkspace pluginWorkspace) {
        this.pluginWorkspace = pluginWorkspace;
        JPanel optionPanel = new JPanel(new GridBagLayout());
        this.initializeModelCombobox();
        this.addAutocompletionOptions(optionPanel, new GridBagConstraints());
        this.loadPageState();
        return optionPanel;
    }

    private void initializeModelCombobox() {
        final WSOptionsStorage optionsStorage = this.pluginWorkspace.getOptionsStorage();
        this.defaultModelCombo = ModelsUIUtil.createGroupedModelsComboBox(EnginesManagerProvider.getInstance().getEnginesManager().getAvailableEngines());
        this.defaultModelCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ComboBoxItem selectedItem;
                if (e.getStateChange() == 1 && (selectedItem = (ComboBoxItem)AIAutocompletionOptionPageExtension.this.defaultModelCombo.getSelectedItem()) != null && selectedItem.getValue() != null) {
                    optionsStorage.setOption("oxygen.positron.plugin.autocompletion.configurations", selectedItem.getValue());
                    optionsStorage.setOption("oxygen.positron.plugin.autocompletion.connector", AIAutocompletionOptionPageExtension.SELECTED_FROM_AI_AUTOCOMPLETION);
                }
            }
        });
        this.connectionConfigurationListener = new WSOptionListener("oxygen.positron.plugin.connector.configurations"){

            public void optionValueChanged(WSOptionChangedEvent event) {
                AIAutocompletionOptionPageExtension.this.refreshModelComboBox();
            }
        };
        optionsStorage.addOptionListener(this.connectionConfigurationListener);
        optionsStorage.addOptionListener(new WSOptionListener("oxygen.positron.plugin.enable.positron.service"){

            public void optionValueChanged(WSOptionChangedEvent event) {
                AIAutocompletionOptionPageExtension.this.refreshModelComboBox();
            }
        });
        if (this.modelsChangedListener == null) {
            this.modelsChangedListener = () -> SwingUtilities.invokeLater(() -> {
                if (this.defaultModelCombo != null) {
                    this.refreshModelComboBox();
                }
            });
            PositronServiceModelsManager modelsManager = AIServerInfoProvider.getInstance().getModelsManager();
            if (modelsManager != null) {
                modelsManager.addModelsChangedListener(this.modelsChangedListener);
            }
        }
    }

    private void addAutocompletionOptions(JPanel mainPanel, GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = UIUtil.getNoInsets();
        gbc.fill = 0;
        this.enableAIAutocompletion = new JCheckBox(TRANSLATOR.getTranslation("Enable_AI_Autocompletion_In_Text_Page"));
        mainPanel.add((Component)this.enableAIAutocompletion, gbc);
        this.addModelCombobox(mainPanel, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.insets.left = DEFAULT_LEFT_INSETS - AIAutocompletionOptionPageExtension.DUMMY_CHECKBOX.getInsets().left;
        this.includeAssociatedInstanceInPrompt = new JCheckBox(TRANSLATOR.getTranslation("Include_associated_instance_in_autocompletion_prompt"));
        mainPanel.add((Component)this.includeAssociatedInstanceInPrompt, gbc);
        this.addEditorTypesTable(mainPanel, gbc);
        this.enableAIAutocompletion.addActionListener(event -> {
            boolean isSelected = ((JCheckBox)event.getSource()).isSelected();
            this.defaultModelCombo.setEnabled(isSelected);
            this.defaultModelLabel.setEnabled(isSelected);
            this.editorTypesSectionPane.setEnabled(isSelected);
            this.editorTableDescription.setEnabled(isSelected);
            this.editorTypesTablePanel.setEnabled(isSelected);
            this.includeAssociatedInstanceInPrompt.setEnabled(isSelected);
        });
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = UIUtil.getNoInsets();
        mainPanel.add((Component)new JPanel(), gbc);
    }

    private void addModelCombobox(JPanel mainPanel, GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = UIUtil.getNoInsets();
        gbc.insets.left = DEFAULT_LEFT_INSETS;
        gbc.insets.top = 5;
        this.defaultModelLabel = new JLabel(TRANSLATOR.getTranslation("Model") + ":");
        mainPanel.add((Component)this.defaultModelLabel, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.left = 5;
        mainPanel.add(this.defaultModelCombo, gbc);
    }

    public void apply(PluginWorkspace pluginWorkspace) {
        if (DataDeletionManager.getInstance().wasDataDeleted()) {
            return;
        }
        pluginWorkspace.getOptionsStorage().setOption("oxygen.positron.plugin.enable.ai.autocompletion.in.text.page", String.valueOf(this.enableAIAutocompletion.isSelected()));
        pluginWorkspace.getOptionsStorage().setOption("oxygen.positron.plugin.include.associated.instance.in.autocompletion.prompt", String.valueOf(this.includeAssociatedInstanceInPrompt.isSelected()));
        this.saveDefaultModelComboBoxValue();
        this.updateEditorTypesState();
    }

    private void loadPageState() {
        this.enableAIAutocompletion.setSelected(Boolean.parseBoolean(this.pluginWorkspace.getOptionsStorage().getOption("oxygen.positron.plugin.enable.ai.autocompletion.in.text.page", String.valueOf(Boolean.FALSE))));
        this.includeAssociatedInstanceInPrompt.setSelected(Boolean.parseBoolean(this.pluginWorkspace.getOptionsStorage().getOption("oxygen.positron.plugin.include.associated.instance.in.autocompletion.prompt", String.valueOf(Boolean.TRUE))));
        this.loadModelComboBoxForService();
        this.loadEnabledEditors();
        boolean isSmartAutocompletionEnabled = this.enableAIAutocompletion.isSelected();
        if (this.editorTypesTablePanel != null) {
            this.defaultModelCombo.setEnabled(isSmartAutocompletionEnabled);
            this.defaultModelLabel.setEnabled(isSmartAutocompletionEnabled);
            this.editorTypesSectionPane.setEnabled(isSmartAutocompletionEnabled);
            this.editorTableDescription.setEnabled(isSmartAutocompletionEnabled);
            this.editorTypesTablePanel.setEnabled(isSmartAutocompletionEnabled);
            this.includeAssociatedInstanceInPrompt.setEnabled(isSmartAutocompletionEnabled);
        }
    }

    private void loadModelComboBoxForService() {
        if (this.defaultModelCombo == null) {
            return;
        }
        String savedModelId = this.pluginWorkspace.getOptionsStorage().getOption("oxygen.positron.plugin.autocompletion.configurations", AIAutocompletionOptionPageExtension.getDefaultModel());
        for (int i = 0; i < this.defaultModelCombo.getItemCount(); ++i) {
            ComboBoxItem item = this.defaultModelCombo.getItemAt(i);
            if (item == null || !savedModelId.equals(item.getValue())) continue;
            this.defaultModelCombo.setSelectedIndex(i);
            return;
        }
        ((GroupedComboBoxModel)this.defaultModelCombo.getModel()).setSelectedModelValue(AIAutocompletionOptionPageExtension.getDefaultModel());
    }

    public void restoreDefaults() {
        this.enableAIAutocompletion.setSelected(true);
        this.includeAssociatedInstanceInPrompt.setSelected(true);
        this.defaultModelLabel.setEnabled(true);
        this.defaultModelCombo.setEnabled(true);
        this.editorTypesTablePanel.setEnabled(true);
        if (this.defaultModelCombo.getModel() instanceof GroupedComboBoxModel) {
            ((GroupedComboBoxModel)this.defaultModelCombo.getModel()).setSelectedModelValue(AIAutocompletionOptionPageExtension.getDefaultModel());
        }
        this.editorTypesSectionPane.setEnabled(true);
        this.editorTableDescription.setEnabled(true);
        this.editorTypesTablePanel.getModel().getEntries().forEach(model -> model.setActive(AIAutocompletionUtil.isContentTypeActiveByDefault((String)model.getContentType())));
        this.editorTypesTablePanel.getModel().fireTableDataChanged();
    }

    private void saveDefaultModelComboBoxValue() {
        String modelSelectedFromConnector;
        boolean isNotConnectedPlaceholder;
        ComboBoxItem selectedItem = (ComboBoxItem)this.defaultModelCombo.getSelectedItem();
        if (selectedItem != null && selectedItem.getValue() != null && !(isNotConnectedPlaceholder = SaasEnginesManager.isNotConnectedPlaceholderModel(selectedItem.getModelDescriptor().getId())) && (modelSelectedFromConnector = this.pluginWorkspace.getOptionsStorage().getOption("oxygen.positron.plugin.autocompletion.connector", null)) == SELECTED_FROM_AI_AUTOCOMPLETION) {
            this.pluginWorkspace.getOptionsStorage().setOption("oxygen.positron.plugin.autocompletion.configurations", selectedItem.getValue());
        }
    }

    private void addEditorTypesTable(JPanel mainPanel, GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets.left = DEFAULT_LEFT_INSETS;
        this.editorTypesSectionPane = new SectionPane(TRANSLATOR.getTranslation("AI_autocompletion_editor_types"), true);
        mainPanel.add((Component)this.editorTypesSectionPane, gbc);
        this.editorTableDescription = new JLabel(TRANSLATOR.getTranslation("select_editor_types_for_ai_autocompletion"));
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets.left = DEFAULT_LEFT_INSETS;
        gbc.insets.top = 5;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        mainPanel.add((Component)this.editorTableDescription, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets.top = 5;
        gbc.insets.left = DEFAULT_LEFT_INSETS;
        this.editorTypesTablePanel = new AIAutocompletionEditorTypesTablePanel(this.buildSupportedAutocompletionEditorEntries());
        mainPanel.add((Component)this.editorTypesTablePanel, gbc);
    }

    private List<AIAutocompletionEditorTypesEntryTable> buildSupportedAutocompletionEditorEntries() {
        ArrayList<AIAutocompletionEditorTypesEntryTable> aiAutocompletionEditorEntries = new ArrayList<AIAutocompletionEditorTypesEntryTable>();
        List supportedContentTypes = AIAutocompletionProvider.getAllSupportedContentTypes();
        for (String contentType : supportedContentTypes) {
            String displayName = AIAutocompletionProvider.getEditorNameForContentType((String)contentType);
            aiAutocompletionEditorEntries.add(new AIAutocompletionEditorTypesEntryTable(displayName, contentType, AIAutocompletionUtil.isContentTypeActiveByDefault((String)contentType)));
        }
        aiAutocompletionEditorEntries.sort((a, b) -> a.getDisplayName().compareToIgnoreCase(b.getDisplayName()));
        return aiAutocompletionEditorEntries;
    }

    private void updateEditorTypesState() {
        AIAutocompletionEditorTypesEntryTablePO persistentObject = new AIAutocompletionEditorTypesEntryTablePO();
        for (AIAutocompletionEditorTypesEntryTable entry : this.editorTypesTablePanel.getModel().getEntries()) {
            AIAutocompletionEditorTypesEntryTable persistentEntry = new AIAutocompletionEditorTypesEntryTable(entry.getDisplayName(), entry.getContentType(), entry.isActive());
            persistentObject.addContentType(persistentEntry);
        }
        this.pluginWorkspace.getOptionsStorage().setPersistentObjectOption("oxygen.positron.plugin.enabled.ai.autocompletion.editors.types", (ExternalPersistentObject)persistentObject);
    }

    private void loadEnabledEditors() {
        AIAutocompletionEditorTypesEntryTablePO aiAutocompletionEditorEntryPO = (AIAutocompletionEditorTypesEntryTablePO)this.pluginWorkspace.getOptionsStorage().getPersistentObjectOption("oxygen.positron.plugin.enabled.ai.autocompletion.editors.types", null);
        if (aiAutocompletionEditorEntryPO != null) {
            Map savedEntries = aiAutocompletionEditorEntryPO.getContentTypesMap();
            List<AIAutocompletionEditorTypesEntryTable> entries = this.editorTypesTablePanel.getModel().getEntries();
            for (AIAutocompletionEditorTypesEntryTable entry : entries) {
                AIAutocompletionEditorTypesEntryTable savedEntry = (AIAutocompletionEditorTypesEntryTable)savedEntries.get(entry.getContentType());
                if (savedEntry == null) continue;
                entry.setActive(savedEntry.isActive());
            }
            this.editorTypesTablePanel.getModel().fireTableDataChanged();
        }
    }

    private void refreshModelComboBox() {
        String currentSelection = null;
        currentSelection = this.pluginWorkspace.getOptionsStorage().getOption("oxygen.positron.plugin.autocompletion.configurations", AIAutocompletionOptionPageExtension.getDefaultModel());
        GroupedComboBoxModel updatedComboBoxModel = ModelsUIUtil.createGroupedModelsComboBoxModel(EnginesManagerProvider.getInstance().getEnginesManager().getAvailableEngines(), true);
        this.defaultModelCombo.setModel(updatedComboBoxModel);
        if (currentSelection != null) {
            for (int i = 0; i < updatedComboBoxModel.getSize(); ++i) {
                ComboBoxItem item = (ComboBoxItem)updatedComboBoxModel.getElementAt(i);
                if (item == null || !currentSelection.equals(item.getValue())) continue;
                this.defaultModelCombo.setSelectedIndex(i);
                return;
            }
        }
        updatedComboBoxModel.setSelectedModelValue(AIAutocompletionOptionPageExtension.getDefaultModel());
    }

    public String getTitle() {
        return TRANSLATOR.getTranslation("AI_Autocompletion");
    }

    public String[] getProjectLevelOptionKeys() {
        return new String[]{"oxygen.positron.plugin.enable.ai.autocompletion.in.text.page", "oxygen.positron.plugin.enabled.ai.autocompletion.editors.types", "oxygen.positron.plugin.autocompletion.configurations"};
    }

    public String getKey() {
        return "ai_autocompletion_preferences_page";
    }

    public String getHelpPageURL() {
        return "https://www.oxygenxml.com/doc/ug-positron-desktop/ai/autocompletion_preferences.html";
    }
}

