/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.oauth;

import com.oxygenxml.positron.connector.auth.OAuthAuthorizationCodeManager;
import com.oxygenxml.positron.connector.auth.OAuthAuthorizationListener;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.ui.MultilineLabel;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.OKCancelDialog;

public class DesktopOAuthAuthorizationDialog
extends OKCancelDialog
implements OAuthAuthorizationListener {
    private OAuthAuthorizationCodeManager manager;
    private JLabel statusLabel;
    private static final Translator TRANSLATOR = Translator.getInstance();

    public DesktopOAuthAuthorizationDialog(String title, String description, OAuthAuthorizationCodeManager manager) {
        super(PluginWorkspaceProvider.getPluginWorkspace() != null ? (JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame() : null, title, true);
        this.manager = manager;
        this.initializeUI(description);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void initializeUI(String description) {
        this.setLayout(new BorderLayout());
        this.setOkButtonText(TRANSLATOR.getTranslation("Authenticate"));
        JPanel contentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel iconLabel = new JLabel(IconsLoader.loadIcon("/images/Connect24.png"));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.anchor = 18;
        gbc.insets = UIUtil.getSpacingInsets();
        gbc.insets.top += 3;
        contentPanel.add((Component)iconLabel, gbc);
        MultilineLabel descriptionArea = new MultilineLabel(description);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = UIUtil.getSpacingInsets();
        contentPanel.add((Component)descriptionArea, gbc);
        this.statusLabel = new JLabel("");
        ++gbc.gridy;
        gbc.insets.top *= 2;
        contentPanel.add((Component)this.statusLabel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        contentPanel.add((Component)new JPanel(), gbc);
        this.add(contentPanel, "Center");
        this.setMinimumSize(new Dimension(430, 200));
        this.setPreferredSize(new Dimension(430, 200));
        this.setResizable(false);
    }

    protected void doOK() {
        this.getOkButton().setEnabled(false);
        if (this.manager != null) {
            this.manager.startBrowserAuthorization();
        }
    }

    protected void doCancel() {
        this.manager.cancelAuthorization();
        super.doCancel();
    }

    public void showDialog() {
        SwingUtilities.invokeLater(() -> this.setVisible(true));
    }

    public void onAuthorizationStarted(String message) {
        SwingUtilities.invokeLater(() -> {
            this.statusLabel.setText(message);
            this.getOkButton().setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
        });
    }

    public void onAuthorizationProgress(String message) {
        SwingUtilities.invokeLater(() -> this.statusLabel.setText(message));
    }

    public void onAuthorizationSuccess(String message) {
        SwingUtilities.invokeLater(() -> {
            this.statusLabel.setText(message);
            this.setCursor(Cursor.getDefaultCursor());
            Timer timer = new Timer(2000, e -> this.dispose());
            timer.setRepeats(false);
            timer.start();
        });
    }

    public void onAuthorizationError(String userMessage) {
        SwingUtilities.invokeLater(() -> {
            this.statusLabel.setText(userMessage);
            this.getOkButton().setEnabled(true);
            this.setOkButtonText(TRANSLATOR.getTranslation("Retry"));
            this.setCursor(Cursor.getDefaultCursor());
        });
    }

    public void onAuthorizationCancelled(String message) {
        SwingUtilities.invokeLater(() -> {
            this.statusLabel.setText(message);
            this.getOkButton().setEnabled(true);
            this.setOkButtonText(TRANSLATOR.getTranslation("Authenticate"));
            this.setCursor(Cursor.getDefaultCursor());
        });
    }

    public void dispose() {
        this.setCursor(Cursor.getDefaultCursor());
        this.manager.shutdown();
        super.dispose();
    }
}

