/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.license;

import com.oxygenxml.positron.actions.dialog.internal.DialogType;
import com.oxygenxml.positron.actions.dialog.internal.MessageDialogBuilder;
import com.oxygenxml.positron.core.auth.BrowserOpener;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.license.AskForLicenseDialogInterface;
import com.oxygenxml.positron.plugin.license.LicenseInfoProvider;
import com.oxygenxml.positron.plugin.license.LicenseRemovedCallback;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.OKCancelDialog;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.PopupMenu;

public class AskForLicenseDialog
extends OKCancelDialog
implements AskForLicenseDialogInterface {
    private final BrowserOpener browserOpener = new BrowserOpener();
    private static final Dimension PREFERRED_LICENSE_AREA_DIM = new Dimension(520, 200);
    private static final Dimension MINIMUM_DIALOG_SIZE = new Dimension(450, 400);
    private static final Translator I18N = Translator.getInstance();
    private JTextArea licenseTextArea = OxygenUIComponentsFactory.createTextArea(null);
    private final AbstractAction pasteAction = new AbstractAction(I18N.getTranslation("Paste")){

        @Override
        public void actionPerformed(ActionEvent e) {
            AskForLicenseDialog.this.licenseTextArea.paste();
        }
    };
    private JButton removeButton;
    private final JTextField sgnField = OxygenUIComponentsFactory.createTextField();
    private LicenseRemovedCallback callback;

    public AskForLicenseDialog() {
        super(PluginWorkspaceProvider.getPluginWorkspace() != null ? (JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame() : null, I18N.getTranslation("Positron_AI_License_Dialog_Title"), true);
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel obtainLicenseKeyPanel = this.createObtainLicenseKeyPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 15, 0);
        c.anchor = 17;
        c.fill = 2;
        this.getContentPane().add((Component)obtainLicenseKeyPanel, c);
        JPanel licenseTextPanel = this.createLicenseTextPanel();
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)licenseTextPanel, c);
        this.setMinimumSize(MINIMUM_DIALOG_SIZE);
        this.setOkButtonText(I18N.getTranslation("Register"));
        this.setResizable(true);
        this.pack();
        this.repaint();
    }

    @Override
    public boolean show(LicenseInfoProvider licenseInfoProvider, LicenseRemovedCallback callback) {
        this.callback = callback;
        String licenseSignature = licenseInfoProvider.getLicenseSignature();
        this.sgnField.setText(licenseSignature);
        this.removeButton.setEnabled(!licenseSignature.isBlank());
        this.setVisible(true);
        return this.getResult() == 1;
    }

    private JPanel createLicenseTextPanel() {
        JPanel licenseTextPanel = new JPanel(new GridBagLayout());
        licenseTextPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.getOkButton().setEnabled(false);
        this.addLicenseTextAreaDocumentListener();
        JLabel pasteLabel = new JLabel(I18N.getTranslation("Positron_AI_License_Info"));
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.anchor = 17;
        constr.insets.bottom = 3;
        licenseTextPanel.add((Component)pasteLabel, constr);
        JButton pasteButton = OxygenUIComponentsFactory.createButton((Action)this.pasteAction);
        ++constr.gridx;
        constr.anchor = 13;
        licenseTextPanel.add((Component)pasteButton, constr);
        JScrollPane licenseTextScrollPane = new JScrollPane(this.licenseTextArea, 20, 30);
        licenseTextScrollPane.setPreferredSize(PREFERRED_LICENSE_AREA_DIM);
        licenseTextScrollPane.setMinimumSize(PREFERRED_LICENSE_AREA_DIM);
        constr.gridx = 0;
        ++constr.gridy;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.fill = 1;
        constr.gridwidth = 2;
        constr.anchor = 17;
        constr.insets.left = 0;
        constr.insets.right = 0;
        constr.insets.bottom = 7;
        licenseTextPanel.add((Component)licenseTextScrollPane, constr);
        JPanel sgnPanel = this.createLicenseSgnPanel();
        constr.gridx = 0;
        ++constr.gridy;
        constr.weighty = 0.0;
        constr.insets.top = 7;
        constr.fill = 2;
        constr.anchor = 15;
        licenseTextPanel.add((Component)sgnPanel, constr);
        this.addPopupMenu();
        return licenseTextPanel;
    }

    private JPanel createLicenseSgnPanel() {
        JPanel sgnPanel = new JPanel(new GridBagLayout());
        JLabel currentSGNLabel = new JLabel(I18N.getTranslation("License_Signature_Label") + ":");
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.weightx = 1.0;
        constr.insets.bottom = 3;
        constr.anchor = 17;
        sgnPanel.add((Component)currentSGNLabel, constr);
        this.sgnField.setEditable(false);
        this.sgnField.setForeground(currentSGNLabel.getForeground());
        ++constr.gridy;
        constr.fill = 2;
        constr.weightx = 1.0;
        constr.insets.bottom = 0;
        sgnPanel.add((Component)this.sgnField, constr);
        this.removeButton = this.createRemoveLicenseButton();
        ++constr.gridx;
        constr.weightx = 0.0;
        constr.insets.left = 7;
        constr.anchor = 13;
        constr.fill = 0;
        sgnPanel.add((Component)this.removeButton, constr);
        return sgnPanel;
    }

    private void addPopupMenu() {
        PopupMenu popupMenu = OxygenUIComponentsFactory.createPopupMenu();
        popupMenu.add(this.pasteAction);
        this.licenseTextArea.addMouseListener(new MouseAdapter((JPopupMenu)popupMenu){
            final /* synthetic */ JPopupMenu val$popupMenu;
            {
                this.val$popupMenu = jPopupMenu;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.val$popupMenu.show(AskForLicenseDialog.this.licenseTextArea, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.val$popupMenu.show(AskForLicenseDialog.this.licenseTextArea, e.getX(), e.getY());
                }
            }
        });
    }

    private void addLicenseTextAreaDocumentListener() {
        this.licenseTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkOKButton();
            }

            private void checkOKButton() {
                AskForLicenseDialog.this.getOkButton().setEnabled(!AskForLicenseDialog.this.licenseTextArea.getText().isEmpty());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkOKButton();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkOKButton();
            }
        });
    }

    private JButton createRemoveLicenseButton() {
        JButton btn = OxygenUIComponentsFactory.createButton((Action)new AbstractAction(I18N.getTranslation("Remove")){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean wasRemoveOperationConfirmed;
                boolean bl = wasRemoveOperationConfirmed = new MessageDialogBuilder(I18N.getTranslation("Remove_License_Dialog_Title"), DialogType.WARNING).setMessage(I18N.getTranslation("Remove_License_Dialog_Question")).setOkButtonName(I18N.getTranslation("Yes")).setCancelButtonName(I18N.getTranslation("No")).buildAndShow().getResult() == 1;
                if (wasRemoveOperationConfirmed) {
                    AskForLicenseDialog.this.sgnField.setText("");
                    AskForLicenseDialog.this.removeButton.setEnabled(false);
                    AskForLicenseDialog.this.callback.licenseRemoved();
                }
            }
        });
        btn.setPreferredSize(this.getOkButton().getPreferredSize());
        return btn;
    }

    @Override
    public String getLicenseText() {
        return this.licenseTextArea != null ? this.licenseTextArea.getText() : null;
    }

    private JPanel createObtainLicenseKeyPanel() {
        JPanel obtainLicenseKeyPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.fill = 2;
        constr.weightx = 1.0;
        constr.weighty = 0.0;
        constr.gridwidth = 2;
        constr.anchor = 17;
        constr.insets.bottom = 5;
        obtainLicenseKeyPanel.add((Component)new JLabel(I18N.getTranslation("Obtain_license_key_in_following_ways") + ":"), constr);
        constr.gridx = 0;
        ++constr.gridy;
        constr.gridwidth = 1;
        obtainLicenseKeyPanel.add((Component)new JLabel("- " + I18N.getTranslation("Request_free_trial_license_key")), constr);
        AbstractAction requestTrialAction = new AbstractAction(I18N.getTranslation("Request_trial") + "..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                AskForLicenseDialog.this.browserOpener.openWebpage("https://www.oxygenxml.com/ai_positron/register.html#trial-ai-positron-enterprise");
            }
        };
        JButton trialButton = OxygenUIComponentsFactory.createButton((Action)requestTrialAction);
        ++constr.gridx;
        obtainLicenseKeyPanel.add((Component)trialButton, constr);
        constr.gridx = 0;
        ++constr.gridy;
        obtainLicenseKeyPanel.add((Component)new JLabel("- " + I18N.getTranslation("Purchase_12_Months_Subscription")), constr);
        AbstractAction buyNowAction = new AbstractAction(I18N.getTranslation("Buy_now") + "..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                AskForLicenseDialog.this.browserOpener.openWebpage("https://www.oxygenxml.com/ai_positron/buy.html?licenseType=enterprise");
            }
        };
        JButton buyButton = OxygenUIComponentsFactory.createButton((Action)buyNowAction);
        ++constr.gridx;
        obtainLicenseKeyPanel.add((Component)buyButton, constr);
        return obtainLicenseKeyPanel;
    }
}

