/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.ghosttext;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GhostTextProxyFactory {
    private static final Logger log = LoggerFactory.getLogger(GhostTextProxyFactory.class);
    private static final String GHOST_TEXT_PROVIDER_CLASS_NAME = "ro.sync.document.GhostTextProvider";
    private static final String GHOST_TEXT_SUGGESTION_CLASS_NAME = "ro.sync.document.GhostTextSuggestion";
    private static boolean isAPIAvailable = true;

    public static Object createGhostTextProviderProxy(InvocationHandler invocationHandler) {
        try {
            Class<?> providerInterface = Class.forName(GHOST_TEXT_PROVIDER_CLASS_NAME);
            return Proxy.newProxyInstance(providerInterface.getClassLoader(), new Class[]{providerInterface}, invocationHandler);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e, (Throwable)e);
            }
            return null;
        }
    }

    public static boolean isGhostTextProviderInterfaceAvailable() {
        return GhostTextProxyFactory.tryLoadingClass(GHOST_TEXT_PROVIDER_CLASS_NAME) != null ? isAPIAvailable : false;
    }

    public static Class<?> getGhostTextProviderInterface() {
        return GhostTextProxyFactory.tryLoadingClass(GHOST_TEXT_PROVIDER_CLASS_NAME);
    }

    public static Class<?> getGhostTextSuggestionClass() {
        return GhostTextProxyFactory.tryLoadingClass(GHOST_TEXT_SUGGESTION_CLASS_NAME);
    }

    public static Object createGhostTextSuggestion(String suggestionText, int caretPosition) {
        block3: {
            Class<?> suggestionClass = GhostTextProxyFactory.getGhostTextSuggestionClass();
            if (suggestionClass != null) {
                try {
                    Constructor<?> constructor = suggestionClass.getConstructor(String.class, Integer.TYPE);
                    return constructor.newInstance(suggestionText, caretPosition);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)e, (Throwable)e);
                }
            }
        }
        return null;
    }

    public static void setAPINotAvailable() {
        if (isAPIAvailable) {
            log.warn("Ghost Text API is not available. Disabling related features.");
            isAPIAvailable = false;
        }
    }

    private static Class<?> tryLoadingClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

