/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.ghosttext;

import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.ghosttext.FollowInstructionProvider;
import com.oxygenxml.positron.plugin.ghosttext.GhostTextProxyFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.WSEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class AIGhostTextProvider
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(AIGhostTextProvider.class);
    private static final int INVALID_CARET_POSITION = -1;
    private static final char NEWLINE_CHAR = '\n';
    private static final String PROVIDER_ID = "ai-ghost-text-provider";
    private WSOptionListener aiAutocompletionOptionListener;
    private FollowInstructionProvider followInstructionProvider;
    private PluginWorkspace pluginWorkspace;
    private boolean isGhostTextApiAvailable;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        switch (methodName = method.getName()) {
            case "getSuggestion": {
                return this.getGhostTextSuggestion();
            }
            case "isActive": {
                return this.isActive();
            }
            case "isSuggestionVisible": {
                return this.isSuggestionVisible();
            }
            case "getProviderId": {
                return PROVIDER_ID;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Unsupported method called on GhostTextProvider: {}. API may have changed.", (Object)methodName);
        }
        GhostTextProxyFactory.setAPINotAvailable();
        return this.getDefaultReturnValue(method.getReturnType());
    }

    private Object getDefaultReturnValue(Class<?> returnType) {
        if (returnType == Boolean.TYPE) {
            return false;
        }
        if (returnType == Integer.TYPE) {
            return 0;
        }
        if (returnType == Long.TYPE) {
            return 0L;
        }
        if (returnType == Double.TYPE) {
            return 0.0;
        }
        if (returnType == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (returnType == Byte.TYPE) {
            return (byte)0;
        }
        if (returnType == Short.TYPE) {
            return (short)0;
        }
        if (returnType == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    private boolean isSuggestionVisible() {
        return this.followInstructionProvider.isSuggestionVisible();
    }

    public AIGhostTextProvider(PluginWorkspace pluginWorkspace, CompletionActionsManager actionsManager) {
        this.pluginWorkspace = pluginWorkspace;
        this.followInstructionProvider = new FollowInstructionProvider(pluginWorkspace, actionsManager);
        this.isGhostTextApiAvailable = GhostTextProxyFactory.isGhostTextProviderInterfaceAvailable();
    }

    public void cleanup() {
        if (this.aiAutocompletionOptionListener != null) {
            this.pluginWorkspace.getOptionsStorage().removeOptionListener(this.aiAutocompletionOptionListener);
            this.aiAutocompletionOptionListener = null;
        }
    }

    public void installOnDocument(WSTextEditorPage textEditorPage) {
        this.installProviderOnDocument(textEditorPage.getDocument());
        this.followInstructionProvider.registerListeners(textEditorPage);
        this.setupOptionListener();
    }

    private Object getGhostTextSuggestion() {
        if (!this.isActive()) {
            return null;
        }
        String suggestionText = this.getAiSuggestionFromAction();
        int caretPosition = suggestionText != null ? this.followInstructionProvider.getCaretPosition() : -1;
        return GhostTextProxyFactory.createGhostTextSuggestion(suggestionText, caretPosition);
    }

    private String getAiSuggestionFromAction() {
        WSEditorPage currentPage;
        int currentCaretPosition = this.followInstructionProvider.getCaretPosition();
        WSEditor editorAccess = this.pluginWorkspace.getCurrentEditorAccess(0);
        WSEditorPage wSEditorPage = currentPage = editorAccess != null ? editorAccess.getCurrentPage() : null;
        if (currentPage instanceof WSTextEditorPage) {
            WSTextEditorPage editorPage = (WSTextEditorPage)currentPage;
            try {
                if (currentCaretPosition != -1) {
                    int currentDocumentLength = editorPage.getDocument().getLength();
                    if (currentCaretPosition >= 0 && currentCaretPosition <= currentDocumentLength) {
                        String charAtPosition;
                        String currentSystemId = editorAccess.getEditorLocation().toString();
                        if (!currentSystemId.equals(this.followInstructionProvider.getSystemIdGeneratedSuggestion())) {
                            this.followInstructionProvider.hideSuggestion();
                        }
                        if ((charAtPosition = editorPage.getDocument().getText(currentCaretPosition, 1)).charAt(0) == '\n') {
                            return this.followInstructionProvider.getLatestAiSuggestion();
                        }
                    }
                }
            }
            catch (BadLocationException e) {
                this.followInstructionProvider.clearLatestAiSuggestion();
            }
        }
        return null;
    }

    private boolean isActive() {
        return this.isGhostTextApiAvailable;
    }

    private void installProviderOnDocument(Document document) {
        block3: {
            try {
                Object proxy = GhostTextProxyFactory.createGhostTextProviderProxy(this);
                Class<?> providerInterface = GhostTextProxyFactory.getGhostTextProviderInterface();
                if (providerInterface == null) {
                    log.debug("GhostTextProvider interface not available");
                    return;
                }
                document.getClass().getMethod("setGhostTextProvider", providerInterface).invoke((Object)document, proxy);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Error installing provider on document: " + e.getMessage());
            }
        }
    }

    public void uninstallProviderOnDocument(WSTextEditorPage textEditorPage) {
        block3: {
            Document document = textEditorPage.getDocument();
            this.followInstructionProvider.unregisterGhostTextForEditor(textEditorPage);
            try {
                Class<?> providerInterface = GhostTextProxyFactory.getGhostTextProviderInterface();
                if (providerInterface == null) {
                    log.debug("GhostTextProvider interface not available");
                    return;
                }
                document.getClass().getMethod("setGhostTextProvider", providerInterface).invoke((Object)document, new Object[]{null});
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Error installing provider on document: " + e.getMessage());
            }
        }
    }

    private void setupOptionListener() {
        if (this.aiAutocompletionOptionListener != null) {
            return;
        }
        WSOptionsStorage optionsStorage = this.pluginWorkspace.getOptionsStorage();
        if (optionsStorage != null) {
            this.aiAutocompletionOptionListener = new WSOptionListener(){

                public void optionValueChanged(WSOptionChangedEvent event) {
                    Object val = event.getNewValueObject();
                    boolean smartAutocompletionEnabled = Boolean.parseBoolean((String)val);
                    AIGhostTextProvider.this.updateGhostTextAvailability(smartAutocompletionEnabled);
                }
            };
            this.aiAutocompletionOptionListener.setKey("oxygen.positron.plugin.enable.ai.autocompletion.in.text.page");
            optionsStorage.addOptionListener(this.aiAutocompletionOptionListener);
        }
    }

    private void updateGhostTextAvailability(boolean enabled) {
        this.isGhostTextApiAvailable = enabled;
        if (!enabled) {
            this.followInstructionProvider.clearLatestAiSuggestion();
        } else {
            log.debug("Reinstalling ghost text provider on document");
        }
    }

    public void uninstall() {
        this.followInstructionProvider.cleanupAllListeners();
    }

    public boolean isGhostTextApiAvailable() {
        return this.isGhostTextApiAvailable;
    }
}

