/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.framework;

import java.io.File;
import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.DocumentTypeCustomRuleMatcher;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public abstract class BaseActionDefinitionJSONCustomRuleMatcher
implements DocumentTypeCustomRuleMatcher {
    private static final Logger logger = LoggerFactory.getLogger((String)BaseActionDefinitionJSONCustomRuleMatcher.class.getName());

    public String getDescription() {
        return "Action definitions (JSON format)";
    }

    public boolean matches(String systemID, String rootNamespace, String rootLocalName, String doctypePublicID, Attributes rootAttributes) {
        boolean matches = false;
        if (logger.isDebugEnabled()) {
            logger.debug("test matches {} sys {} root {}", new Object[]{this, systemID, rootLocalName});
            if (rootAttributes != null) {
                int len = rootAttributes.getLength();
                for (int i = 0; i < len; ++i) {
                    logger.debug("Attr {} = {}", (Object)rootAttributes.getQName(i), (Object)rootAttributes.getValue(i));
                }
            }
        }
        if (systemID != null && systemID.endsWith(".json")) {
            boolean isActionDefinedOnServer;
            boolean bl = isActionDefinedOnServer = systemID.contains("/resources/actions") && systemID.endsWith("-actions.json");
            if (isActionDefinedOnServer) {
                matches = true;
            } else {
                PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
                if (pw != null) {
                    matches = this.isLocalAction(systemID, pw);
                }
            }
            boolean isObject = "JSON".equals(rootLocalName);
            boolean isArray = "array".equals(rootLocalName);
            if (isObject || isArray) {
                matches = rootAttributes == null || rootAttributes.getLength() == 0 ? this.matchJSONArray() : this.matchTopProps(rootAttributes, isArray);
                if (systemID.contains("/Untitled") && rootAttributes != null) {
                    matches = this.matchTopProps(rootAttributes, isArray);
                }
            } else {
                matches = false;
            }
        }
        logger.debug("Matches {}", (Object)matches);
        return matches;
    }

    private boolean isLocalAction(String systemID, PluginWorkspace pw) {
        boolean matches = false;
        String actionsFolderPath = pw.getOptionsStorage().getOption("oxygen.positron.plugin.actions.folder", "${pd}/positron-ai-actions");
        logger.debug("Actions folder path from options: {}", (Object)actionsFolderPath);
        if (actionsFolderPath != null && !actionsFolderPath.isEmpty()) {
            actionsFolderPath = actionsFolderPath.replace('\\', '/');
            actionsFolderPath = pw.getUtilAccess().expandEditorVariables(actionsFolderPath, null);
            try {
                actionsFolderPath = URLUtil.correct((File)new File(actionsFolderPath)).toExternalForm();
            }
            catch (MalformedURLException e) {
                logger.warn("Could not correct action folder path!", (Throwable)e);
            }
            logger.debug("Actions folder path expanded: {}", (Object)actionsFolderPath);
            if (systemID.contains(actionsFolderPath)) {
                matches = true;
            }
        }
        return matches;
    }

    private boolean matchTopProps(Attributes rootAttributes, boolean isArray) {
        boolean matches = false;
        String topProps = rootAttributes.getValue("topProperties");
        if (topProps != null && topProps.contains("id") && topProps.contains("title") && (topProps.contains("type") || topProps.contains("output-action")) && (topProps.contains("prompt") || topProps.contains("prompt_ref") || topProps.contains("context"))) {
            matches = isArray ? this.matchJSONArray() : !this.matchJSONArray();
        }
        return matches;
    }

    protected abstract boolean matchJSONArray();
}

