/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.fix;

import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.ActionMatcherUtil;
import com.oxygenxml.positron.plugin.assist.AuthorSelectionUtil;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.InputContext;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.editor.page.WSTextBasedEditorPage;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;

public class QuickFixInstaller {
    private final Logger logger = LoggerFactory.getLogger(QuickFixInstaller.class);
    private final Map<URL, Object> urlToAddedProcessorMap = new HashMap<URL, Object>();

    public void addQuickAssistProcessor(final WSTextBasedEditorPage editorPage, final CompletionActionsManager completionActionsManager) {
        block3: {
            try {
                Class<?> grClazz = Class.forName("ro.sync.exml.editor.quickassist.QuickAssistProposalGroup");
                Constructor<?> grConstr = grClazz.getConstructor(String.class, String.class, Boolean.TYPE);
                final Object gr = grConstr.newInstance(Translator.getInstance().getTranslation("AI_Assistant"), "/images/DockableFramePositron16.png", true);
                Class<?> processorClass = Class.forName("ro.sync.exml.editor.quickassist.SimpleQuickAssistProcessor");
                Method addProcessor = editorPage.getClass().getMethod("addQuickAssistProcessor", processorClass);
                addProcessor.setAccessible(true);
                Object processorImpl = Proxy.newProxyInstance(QuickFixInstaller.class.getClassLoader(), new Class[]{processorClass}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if ("canAssist".equals(method.getName())) {
                            return Boolean.TRUE;
                        }
                        if ("hashCode".equals(method.getName())) {
                            return 0;
                        }
                        if ("equals".equals(method.getName())) {
                            return proxy == args[0];
                        }
                        if ("getPriority".equals(method.getName())) {
                            return (short)1;
                        }
                        if ("computeQuickAssistProposals".equals(method.getName())) {
                            return QuickFixInstaller.this.computeQuickFixProposals(editorPage, completionActionsManager, gr);
                        }
                        return null;
                    }
                });
                addProcessor.invoke((Object)editorPage, processorImpl);
                if (editorPage.getParentEditor() != null) {
                    this.urlToAddedProcessorMap.put(editorPage.getParentEditor().getEditorLocation(), processorImpl);
                }
            }
            catch (Throwable e) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)e, e);
            }
        }
    }

    public void removeQuickAssistProcessor(WSTextBasedEditorPage hookedPage) {
        block3: {
            Object processor;
            if (hookedPage != null && hookedPage.getParentEditor() != null && (processor = this.urlToAddedProcessorMap.remove(hookedPage.getParentEditor().getEditorLocation())) != null) {
                try {
                    Class<?> processorClass = Class.forName("ro.sync.exml.editor.quickassist.SimpleQuickAssistProcessor");
                    Method removeProcessor = hookedPage.getClass().getMethod("removeQuickAssistProcessor", processorClass);
                    removeProcessor.setAccessible(true);
                    removeProcessor.invoke((Object)hookedPage, processor);
                }
                catch (Throwable e) {
                    if (!this.logger.isDebugEnabled()) break block3;
                    this.logger.debug((Object)e, e);
                }
            }
        }
    }

    private Object computeQuickFixProposals(WSTextBasedEditorPage editorPage, CompletionActionsManager completionActionsManager, Object parentGroup) throws ClassNotFoundException {
        Class<?> proposalInterface = Class.forName("ro.sync.exml.editor.quickassist.IQuickAssistProposal");
        ArrayList<Object> proposals = new ArrayList<Object>();
        List<PositronAIActionBase> complActions = completionActionsManager.getCompletionActions();
        if (complActions != null) {
            String dt = null;
            if (editorPage.getParentEditor().getDocumentTypeInformation() != null) {
                dt = editorPage.getParentEditor().getDocumentTypeInformation().getName();
            }
            Optional<String> currenContentType = Optional.ofNullable(editorPage.getParentEditor().getContentType());
            Optional<String> currentDocumentType = Optional.ofNullable(dt);
            for (PositronAIActionBase positionAction : complActions) {
                if (!positionAction.getActionDetails().isQuickAssist() || !QuickFixInstaller.actionMatchesDocumentType(currenContentType, currentDocumentType, positionAction)) continue;
                Object adapter = Proxy.newProxyInstance(QuickFixInstaller.class.getClassLoader(), new Class[]{proposalInterface}, QuickFixInstaller.createQuickFixInvocationHandler(editorPage, parentGroup, positionAction, positionAction.getActionDetails().getInputContext()));
                proposals.add(adapter);
            }
        }
        return proposals.toArray((Object[])Array.newInstance(proposalInterface, 0));
    }

    private static boolean actionMatchesDocumentType(Optional<String> currenContentType, Optional<String> currentDocumentType, PositronAIActionBase positionAction) {
        return ActionMatcherUtil.shouldAddAction(currentDocumentType, (AIActionDetails)positionAction.getActionDetails()) || ActionMatcherUtil.shouldAddAction(currenContentType, (AIActionDetails)positionAction.getActionDetails());
    }

    private static InvocationHandler createQuickFixInvocationHandler(final WSTextBasedEditorPage editorPage, final Object parentGroup, final PositronAIActionBase positionAction, final InputContext inputContext) {
        return new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                if ("isQuickFix".equals(methodName)) {
                    return Boolean.FALSE;
                }
                if ("apply".equals(methodName)) {
                    if (inputContext == InputContext.AUTO_SELECTION_DOCUMENT) {
                        AuthorSelectionUtil.selectRelevantContent(editorPage);
                    }
                    positionAction.actionPerformed(null);
                } else {
                    if ("getStringForFilter".equals(methodName) || "getRenderString".equals(methodName) || "toString".equals(methodName)) {
                        return positionAction.getValue("Name");
                    }
                    if ("getDocumentation".equals(methodName)) {
                        String description = Translator.getInstance().getTranslation("AI_Assistant") + "\n" + positionAction.getValue("ShortDescription");
                        if (inputContext == InputContext.AUTO_SELECTION_DOCUMENT && editorPage instanceof WSAuthorEditorPage) {
                            description = description + "\n\n" + Translator.getInstance().getTranslation("No_selection_current_para");
                        }
                        return description;
                    }
                    if ("getImportance".equals(methodName)) {
                        return 2;
                    }
                    if ("getPresentPosition".equals(methodName)) {
                        return 0;
                    }
                    if ("compareTo".equals(methodName)) {
                        return 1;
                    }
                    if ("getImage".equals(methodName)) {
                        return null;
                    }
                    if ("getParentGroup".equals(methodName)) {
                        return parentGroup;
                    }
                }
                return null;
            }
        };
    }
}

