/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.engine;

import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.core.api.PositronServiceModelsManager;
import com.oxygenxml.positron.core.engines.IEnginesManager;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.AIModelsUtil;
import com.oxygenxml.positron.plugin.AIServerInfoProvider;
import com.oxygenxml.positron.plugin.preferences.DataDeletionManager;
import com.oxygenxml.positron.plugin.util.AiPositronServiceConnectionInfoHelper;
import com.oxygenxml.positron.utilities.ModelIdentifierUtil;
import com.oxygenxml.positron.utilities.json.Engine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class SaasEnginesManager
implements IEnginesManager {
    private static final Logger log = LoggerFactory.getLogger(SaasEnginesManager.class);
    private static final Translator TRANSLATOR = Translator.getInstance();
    public static final ModelDescriptor notConnectedModelDescriptor = new ModelDescriptor("NOT_CONNECTED", TRANSLATOR.getTranslation("Not_Connected_Model_Label"), TRANSLATOR.getTranslation("Not_Connected_Model_Description"));

    public static boolean isNotConnectedPlaceholderModel(String modelIdentifier) {
        if (modelIdentifier == null || modelIdentifier.isEmpty()) {
            return false;
        }
        String[] split = ModelIdentifierUtil.splitModelIdentifier((String)modelIdentifier);
        return "aips".equals(split[0]) && notConnectedModelDescriptor.getId().equals(split[1]);
    }

    public Map<String, List<ModelDescriptor>> getAvailableEngines() {
        HashMap<String, List<ModelDescriptor>> groupedModelsForUI = new HashMap<String, List<ModelDescriptor>>();
        PositronServiceModelsManager modelsManager = AIServerInfoProvider.getInstance().getModelsManager();
        if (modelsManager != null) {
            Map serverModels = modelsManager.getGroupedModelsForUI();
            if (serverModels != null && !serverModels.isEmpty()) {
                log.debug("Using models from Positron service");
                groupedModelsForUI = serverModels;
            } else {
                log.debug("Server models empty or unavailable, falling back");
                groupedModelsForUI.put(TRANSLATOR.getTranslation("AI_Positron_Service"), Arrays.asList(notConnectedModelDescriptor));
            }
        } else {
            log.debug("PositronServiceModelsManager not available, returning not-connected placeholder");
            groupedModelsForUI.put(TRANSLATOR.getTranslation("AI_Positron_Service"), Arrays.asList(notConnectedModelDescriptor));
        }
        return this.addNamespaceToModels(groupedModelsForUI);
    }

    private Map<String, List<ModelDescriptor>> addNamespaceToModels(Map<String, List<ModelDescriptor>> groupedModels) {
        LinkedHashMap<String, List<ModelDescriptor>> enginesMappings = new LinkedHashMap<String, List<ModelDescriptor>>();
        for (Map.Entry<String, List<ModelDescriptor>> entry : groupedModels.entrySet()) {
            String key = entry.getKey();
            List<ModelDescriptor> modelDescriptors = entry.getValue();
            ArrayList<ModelDescriptor> modelsWithNamespace = new ArrayList<ModelDescriptor>();
            for (ModelDescriptor m : modelDescriptors) {
                ModelDescriptor md = new ModelDescriptor(ModelIdentifierUtil.buildModelIdentifier((String)"aips", (String)m.getId()), m.getUiLabel(), m.getDescription(), m.getContextWindow(), m.getMaxOutputTokens(), m.isReasoningModel());
                modelsWithNamespace.add(md);
            }
            enginesMappings.put("AI Positron Service / " + key, modelsWithNamespace);
        }
        return enginesMappings;
    }

    public void saveEngine(String selectedEngineId) {
        String[] splitModelIdentifier = ModelIdentifierUtil.splitModelIdentifier((String)selectedEngineId);
        String modelId = splitModelIdentifier[1];
        Engine defaultEngine = AIServerInfoProvider.getInstance().getModelsManager().getDefaultEngine();
        if (selectedEngineId != null && modelId.equals(defaultEngine.getId())) {
            selectedEngineId = null;
        }
        if (modelId != null && !notConnectedModelDescriptor.getId().equals(modelId) && !DataDeletionManager.getInstance().wasDataDeleted()) {
            PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().setOption("default.engine.model", selectedEngineId);
        }
    }

    public ModelDescriptor getCurrentEngineDescriptor() {
        if (!AiPositronServiceConnectionInfoHelper.getInstance().isConnectedToPositronService()) {
            return notConnectedModelDescriptor;
        }
        String selectedModelId = AIModelsUtil.getAIModelFromOptions((String)"default.engine.model");
        PositronServiceModelsManager modelsManager = AIServerInfoProvider.getInstance().getModelsManager();
        String defaultModelId = ModelIdentifierUtil.buildModelIdentifier((String)"aips", (String)modelsManager.getDefaultEngine().getId());
        if (selectedModelId == null || "<Default>".equals(selectedModelId)) {
            selectedModelId = defaultModelId;
        }
        Map<String, List<ModelDescriptor>> availableEngines = this.getAvailableEngines();
        String modelIdToFind = selectedModelId;
        return this.findModelById(availableEngines, modelIdToFind).or(() -> {
            log.info("The selected engine was not found in available models: {}", (Object)modelIdToFind);
            return this.findModelById(availableEngines, defaultModelId);
        }).orElseGet(() -> new ModelDescriptor(modelIdToFind, modelIdToFind, null));
    }

    private Optional<ModelDescriptor> findModelById(Map<String, List<ModelDescriptor>> engines, String modelId) {
        return engines.values().stream().flatMap(Collection::stream).filter(model -> model.getId().equals(modelId)).findFirst();
    }

    public String getModelsComboTooltip() {
        return TRANSLATOR.getTranslation("Default_model_explanation");
    }
}

