/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.engine;

import com.oxygenxml.positron.api.connector.AIConnector;
import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.api.connector.param.ConnectorParamType;
import com.oxygenxml.positron.api.connector.param.ModelsComboConnectorParam;
import com.oxygenxml.positron.connector.AIConnectorConfigsManager;
import com.oxygenxml.positron.connector.AIConnectorConfiguration;
import com.oxygenxml.positron.connector.ConnectorConfigurationsPO;
import com.oxygenxml.positron.core.engines.IEnginesManager;
import com.oxygenxml.positron.plugin.EnterpriseConnectorLoader;
import com.oxygenxml.positron.plugin.engine.SaasEnginesManager;
import com.oxygenxml.positron.plugin.util.AiPositronServiceAccess;
import com.oxygenxml.positron.plugin.util.DirectConnectionConfigurationHelper;
import com.oxygenxml.positron.utilities.ModelIdentifierUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.ExternalPersistentObject;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class EnterpriseEnginesManager
implements IEnginesManager {
    private static final Logger log = LoggerFactory.getLogger(EnterpriseEnginesManager.class);
    protected Map<String, List<ModelDescriptor>> connectorToModelsCache = new HashMap<String, List<ModelDescriptor>>();
    private SaasEnginesManager saasEnginesManager;

    public EnterpriseEnginesManager() {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (pluginWorkspace != null) {
            WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
            optionsStorage.addOptionListener(new WSOptionListener("oxygen.positron.plugin.connector.configurations"){

                public void optionValueChanged(WSOptionChangedEvent event) {
                    EnterpriseEnginesManager.this.connectorToModelsCache.clear();
                }
            });
            if (AiPositronServiceAccess.getInstance().hasAccessToAiPositronService()) {
                if (AiPositronServiceAccess.getInstance().isAiPositronServiceConnectionEnabledFromAiServicePreferences()) {
                    this.saasEnginesManager = new SaasEnginesManager();
                }
                if (optionsStorage != null) {
                    optionsStorage.addOptionListener(new WSOptionListener("oxygen.positron.plugin.enable.positron.service"){

                        public void optionValueChanged(WSOptionChangedEvent event) {
                            EnterpriseEnginesManager.this.saasEnginesManager = Boolean.parseBoolean((String)event.getNewValueObject()) ? new SaasEnginesManager() : null;
                        }
                    });
                }
            }
        }
    }

    public boolean isChoosingEngineAllowed() {
        if (EnterpriseConnectorLoader.getInstance().isConnectorFilePresent()) {
            return false;
        }
        Map<String, List<ModelDescriptor>> availableModels = this.getAvailableEngines();
        if (availableModels == null || availableModels.isEmpty()) {
            return false;
        }
        int totalModels = 0;
        for (List<ModelDescriptor> groupModels : availableModels.values()) {
            if (groupModels == null || (totalModels += groupModels.size()) <= 1) continue;
            return true;
        }
        return false;
    }

    public Map<String, List<ModelDescriptor>> getAvailableEngines() {
        LinkedHashMap<String, List<ModelDescriptor>> toRet = new LinkedHashMap<String, List<ModelDescriptor>>();
        if (this.saasEnginesManager != null && !EnterpriseConnectorLoader.getInstance().isConnectorFilePresent()) {
            toRet.putAll(this.saasEnginesManager.getAvailableEngines());
        }
        AIConnectorConfigsManager.getInstance().getConfigurations().stream().forEach(connectorConfig -> {
            boolean isCurrentModelACustomModel;
            AIConnector selConnector = connectorConfig.getConnector();
            List<ModelDescriptor> models = this.getModelsFromConnector(selConnector);
            String currentModel = this.getSelectedEngineForConfiguration((AIConnectorConfiguration)connectorConfig);
            boolean bl = isCurrentModelACustomModel = currentModel != null && !currentModel.isBlank() && models.stream().noneMatch(model -> Objects.equals(model.getId(), currentModel));
            if (isCurrentModelACustomModel) {
                if (models.stream().noneMatch(model -> Objects.equals(model.getId(), currentModel))) {
                    models.add(0, new ModelDescriptor(currentModel, currentModel, null));
                }
            } else {
                String savedCustom;
                ModelsComboConnectorParam modelParam = selConnector.getParametersList().stream().filter(p -> p.getType() == ConnectorParamType.MODEL_COMBO_BOX).findFirst().orElse(null);
                if (modelParam != null && (savedCustom = DirectConnectionConfigurationHelper.getOptionValueForPseudoParam(connectorConfig, "connector_last_custom_model")) != null && !savedCustom.isBlank() && models.stream().noneMatch(model -> Objects.equals(model.getId(), savedCustom))) {
                    models.add(0, new ModelDescriptor(savedCustom, savedCustom, null));
                }
            }
            ArrayList<ModelDescriptor> modelsWithNamespace = new ArrayList<ModelDescriptor>();
            for (ModelDescriptor model2 : models) {
                modelsWithNamespace.add(new ModelDescriptor(ModelIdentifierUtil.buildModelIdentifier((String)connectorConfig.getConfigurationId(), (String)model2.getId()), model2.getUiLabel(), model2.getDescription(), model2.getContextWindow(), model2.getMaxOutputTokens(), model2.isReasoningModel()));
            }
            if (modelsWithNamespace.isEmpty()) {
                modelsWithNamespace.add(new ModelDescriptor(ModelIdentifierUtil.buildModelIdentifier((String)connectorConfig.getConfigurationId(), (String)""), connectorConfig.getName(), null));
            }
            toRet.put(connectorConfig.getName(), modelsWithNamespace);
        });
        return toRet;
    }

    public List<ModelDescriptor> getModelsFromConnector(AIConnector connector) {
        ArrayList<ModelDescriptor> models = new ArrayList<ModelDescriptor>();
        if (this.connectorToModelsCache.containsKey(connector.getConnectorId())) {
            models.addAll((Collection)this.connectorToModelsCache.get(connector.getConnectorId()));
        } else {
            connector.getParametersList().stream().filter(param -> param.getType() == ConnectorParamType.MODEL_COMBO_BOX).findFirst().ifPresent(param -> {
                ModelsComboConnectorParam modelParam = (ModelsComboConnectorParam)param;
                List modelsToAdd = (List)modelParam.getModelSupplier().get();
                if (modelsToAdd != null) {
                    models.addAll(modelsToAdd);
                }
            });
            this.connectorToModelsCache.put(connector.getConnectorId(), new ArrayList<ModelDescriptor>(models));
        }
        return models;
    }

    public void saveEngine(String modelIdentifier) {
        String[] splitModelIdentifier = ModelIdentifierUtil.splitModelIdentifier((String)modelIdentifier);
        String configurationId = splitModelIdentifier[0];
        String modelId = splitModelIdentifier[1];
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        if (configurationId != null && AIConnectorConfigsManager.getInstance().getConfigurationById(configurationId) != null && AIConnectorConfigsManager.getInstance().getConfigurationById(configurationId).getConnector() instanceof AIConnector) {
            AIConnectorConfiguration config = AIConnectorConfigsManager.getInstance().getConfigurationById(configurationId);
            if (config != null) {
                if (config.getConnector() instanceof AIConnector) {
                    ConnectorConfigurationsPO connectorConfigurations = (ConnectorConfigurationsPO)optionsStorage.getPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)new ConnectorConfigurationsPO());
                    connectorConfigurations.setCurrentConfigurationId(configurationId);
                    config.getConnector().getParametersList().stream().filter(param -> param.getType() == ConnectorParamType.MODEL_COMBO_BOX).findFirst().ifPresentOrElse(param -> {
                        String engineToSet = modelId;
                        if (engineToSet != null && engineToSet.equals(((ModelsComboConnectorParam)param).getDefaultValue())) {
                            engineToSet = null;
                        }
                        connectorConfigurations.setConfigurationParameter(config.getConfigurationId(), param.getId(), engineToSet);
                    }, () -> log.debug("Cannot find model param to save"));
                    optionsStorage.setPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)connectorConfigurations);
                    if (this.saasEnginesManager != null) {
                        this.saasEnginesManager.saveEngine(null);
                    }
                }
            } else {
                log.debug("Cannot find configuration '{}' to save model for.", (Object)configurationId);
            }
        } else if (this.saasEnginesManager != null) {
            this.saasEnginesManager.saveEngine(modelIdentifier);
            ConnectorConfigurationsPO connectorConfigurations = (ConnectorConfigurationsPO)optionsStorage.getPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)new ConnectorConfigurationsPO());
            connectorConfigurations.setCurrentConfigurationId(null);
            optionsStorage.setPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)connectorConfigurations);
        }
    }

    public ModelDescriptor getCurrentEngineDescriptor() {
        ModelDescriptor toRet = null;
        Optional<AIConnectorConfiguration> selectedConnectorConfigOpt = DirectConnectionConfigurationHelper.getSelectedConnectorConfiguration();
        if (selectedConnectorConfigOpt.isPresent()) {
            List<ModelDescriptor> models;
            AIConnectorConfiguration currentConfig = selectedConnectorConfigOpt.get();
            String currentEngine = this.getSelectedEngineForConfiguration(currentConfig);
            if (currentEngine == null) {
                currentEngine = "";
            }
            if ((models = this.getAvailableEngines().get(currentConfig.getName())) != null) {
                for (ModelDescriptor modelDescriptor : models) {
                    if (!modelDescriptor.getId().equals(ModelIdentifierUtil.buildModelIdentifier((String)currentConfig.getConfigurationId(), (String)currentEngine))) continue;
                    toRet = modelDescriptor;
                    break;
                }
            }
        } else if (this.saasEnginesManager != null) {
            toRet = this.saasEnginesManager.getCurrentEngineDescriptor();
        }
        return toRet;
    }

    public String getSelectedEngineForConfiguration(AIConnectorConfiguration selConnectorConfig) {
        String[] selectedEngine = new String[1];
        if (selConnectorConfig != null) {
            AIConnector selConnector = selConnectorConfig.getConnector();
            selConnector.getParametersList().stream().filter(param -> param.getType() == ConnectorParamType.MODEL_COMBO_BOX).findFirst().ifPresent(param -> {
                selectedEngine[0] = String.valueOf(DirectConnectionConfigurationHelper.getOptionValueForParam(selConnectorConfig, param, false));
                if (selectedEngine[0] == null) {
                    selectedEngine[0] = ((ModelsComboConnectorParam)param).getDefaultValue();
                }
                if (selectedEngine[0] != null && "<Default>".equals(selectedEngine[0])) {
                    selectedEngine[0] = ((ModelsComboConnectorParam)param).getDefaultValue();
                }
            });
        }
        return selectedEngine[0];
    }

    public String getModelsComboTooltip() {
        String tooltip = null;
        Optional<AIConnectorConfiguration> selectedConnectorConfigOpt = DirectConnectionConfigurationHelper.getSelectedConnectorConfiguration();
        if (selectedConnectorConfigOpt.isPresent()) {
            AIConnector selConnector = selectedConnectorConfigOpt.get().getConnector();
            tooltip = selConnector.getParametersList().stream().filter(param -> param.getType() == ConnectorParamType.MODEL_COMBO_BOX).findFirst().map(param -> param.getTooltip()).orElse(null);
        } else if (this.saasEnginesManager != null) {
            tooltip = this.saasEnginesManager.getModelsComboTooltip();
        }
        return tooltip;
    }

    public Set<String> getBuiltinModelIds(String connectorId) {
        List<ModelDescriptor> builtinModels = this.connectorToModelsCache.get(connectorId);
        return builtinModels != null ? builtinModels.stream().map(ModelDescriptor::getId).collect(Collectors.toSet()) : Collections.emptySet();
    }
}

