/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.diff;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.function.Function;
import javax.swing.text.BadLocationException;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.Anchor;
import ro.sync.exml.workspace.api.editor.page.WSEditorPage;
import ro.sync.exml.workspace.api.editor.page.WSTextBasedEditorPage;

public class PreviewURLHandler
extends URLStreamHandler {
    public static final String PREVIEW_PROTOCOL_PREFIX = "preview-";
    private static WSEditor leftEditor;
    private static WSEditor rightEditor;
    private static boolean changesAppliedDuringPreview;
    private static Function<URL, URL> beforeChangeSupplier;
    private static Function<URL, URL> afterChangeSupplier;

    public static String unwrapURL(URL url) throws IOException {
        String urlString = url.toString();
        String protocol = url.getProtocol();
        String afterProtocol = urlString.substring(protocol.length());
        int indexColon = (protocol = protocol.substring(PREVIEW_PROTOCOL_PREFIX.length())).indexOf(45);
        if (indexColon != -1) {
            return protocol.substring(indexColon + 1) + afterProtocol;
        }
        throw new IOException("Could not identify embedded protocol " + url);
    }

    @Override
    public int hashCode(URL u) {
        String file;
        String host;
        int h = 0;
        String protocol = u.getProtocol();
        if (protocol != null) {
            h += protocol.hashCode();
        }
        if ((host = u.getHost()) != null) {
            h += host.toLowerCase().hashCode();
        }
        if ((file = u.getFile()) != null) {
            h += file.hashCode();
        }
        h = u.getPort() == -1 ? (h += this.getDefaultPort()) : (h += u.getPort());
        String ref = u.getRef();
        if (ref != null) {
            h += ref.hashCode();
        }
        return h;
    }

    @Override
    public boolean hostsEqual(URL u1, URL u2) {
        if (u1.getHost() != null && u2.getHost() != null) {
            return u1.getHost().equalsIgnoreCase(u2.getHost());
        }
        return u1.getHost() == null && u2.getHost() == null;
    }

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        return new PreviewConnection(u);
    }

    public static void setPreviewDetails(WSEditor leftEditor, WSEditor rightEditor) {
        PreviewURLHandler.leftEditor = leftEditor;
        PreviewURLHandler.rightEditor = rightEditor;
        changesAppliedDuringPreview = false;
    }

    public static URL encodeURL(String locationHint, String urlLocation) throws MalformedURLException {
        return new URL(PREVIEW_PROTOCOL_PREFIX + locationHint + "-" + urlLocation);
    }

    public static void setBeforeAfterSuppliers(Function<URL, URL> beforeChangeSupplier, Function<URL, URL> afterChangeSupplier) {
        PreviewURLHandler.beforeChangeSupplier = beforeChangeSupplier;
        PreviewURLHandler.afterChangeSupplier = afterChangeSupplier;
    }

    public static boolean changesAppliedDuringPreview() {
        return changesAppliedDuringPreview;
    }

    private static Anchor[] createSelectionAnchors(WSEditorPage ep) {
        if (ep instanceof WSTextBasedEditorPage) {
            try {
                WSTextBasedEditorPage page = (WSTextBasedEditorPage)ep;
                if (page.hasSelection()) {
                    int selStart = page.getSelectionStart();
                    int selEnd = page.getSelectionEnd();
                    return new Anchor[]{page.createAnchor(selStart), page.createAnchor(selEnd)};
                }
                return new Anchor[]{page.createAnchor(page.getCaretOffset())};
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void restoreAnchors(WSEditorPage ep, Anchor[] anchors) {
        if (anchors != null && anchors.length > 0 && anchors[0] != null && ep instanceof WSTextBasedEditorPage) {
            WSTextBasedEditorPage page = (WSTextBasedEditorPage)ep;
            try {
                int ao = page.getOffsetForAnchor(anchors[0]);
                if (ao > 0) {
                    int secondOffset;
                    page.setCaretPosition(ao);
                    if (anchors.length > 1 && (secondOffset = page.getOffsetForAnchor(anchors[1])) > 0) {
                        page.select(ao, secondOffset);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            page.scrollCaretToVisible();
        }
    }

    public static URL resolveToTempFileBeforeChangeURL(URL url) {
        return beforeChangeSupplier.apply(url);
    }

    static {
        changesAppliedDuringPreview = false;
    }

    private static class PreviewConnection
    extends URLConnection {
        protected PreviewConnection(URL url) throws IOException {
            super(url);
            this.setDoOutput(true);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            InputStream is = null;
            String protocol = this.url.getProtocol();
            if (protocol.contains("-before-")) {
                URL beforeURL;
                if (beforeChangeSupplier != null && (beforeURL = beforeChangeSupplier.apply(this.url)) != null) {
                    is = beforeURL.openStream();
                }
            } else if (protocol.contains("-after-")) {
                URL afterURL;
                if (afterChangeSupplier != null && (afterURL = afterChangeSupplier.apply(this.url)) != null) {
                    is = afterURL.openStream();
                }
            } else if (protocol.contains("-current-")) {
                if (leftEditor != null) {
                    String leftEditorLocation = leftEditor.getEditorLocation().toString();
                    String leftPreviewURL = PreviewURLHandler.encodeURL("current", leftEditorLocation).toString();
                    if (this.url.toString().equals(leftPreviewURL)) {
                        is = leftEditor.createContentInputStream();
                    }
                }
            } else if (rightEditor != null) {
                String rightEditorLocation = rightEditor.getEditorLocation().toString();
                if (this.url.toString().equals(PreviewURLHandler.encodeURL("modified", rightEditorLocation).toString()) || this.url.toString().equals(PreviewURLHandler.encodeURL("modifiededitable", rightEditorLocation).toString())) {
                    is = rightEditor.createContentInputStream();
                }
            }
            if (is == null) {
                is = new URL(PreviewURLHandler.unwrapURL(this.url)).openStream();
            }
            return is;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            String protocol = this.url.getProtocol();
            if (protocol.contains("-current-") || protocol.contains("-modifiededitable-")) {
                final File temp = File.createTempFile("test" + this.url.toString().hashCode(), ".xml");
                temp.deleteOnExit();
                return new FileOutputStream(temp){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void close() throws IOException {
                        super.close();
                        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
                        if (pluginWorkspace == null || pluginWorkspace.getUtilAccess() == null) throw new IOException("No plugin workspace available");
                        try (Reader reader = null;){
                            reader = pluginWorkspace.getUtilAccess().createReader(URLUtil.correct((File)temp), "UTF8");
                            if (leftEditor == null) return;
                            WSEditorPage ep = leftEditor.getCurrentPage();
                            Anchor[] anchors = PreviewURLHandler.createSelectionAnchors(ep);
                            leftEditor.reloadContent(reader, false);
                            PreviewURLHandler.restoreAnchors(ep, anchors);
                            changesAppliedDuringPreview = true;
                            return;
                        }
                    }
                };
            }
            throw new IOException("Only the current content can be modified and saved.");
        }

        @Override
        public void connect() throws IOException {
        }
    }
}

