/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.diff;

import com.oxygenxml.positron.plugin.diff.PreviewURLHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import ro.sync.exml.view.HostComponentBase;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;

public class PreviewQuitHandler {
    private static final String CLOSE_ACTION_MAP_KEY = "ESC_CLOSE_DIFF";
    private static final String FILE_CLOSE_ACTION_ID = "File/File_Close";
    private static final KeyStroke ESC_KS = KeyStroke.getKeyStroke(27, 0);

    public static void installQuitHandlers(JFrame diffFrame) {
        final AbstractButton fileCloseAction = PreviewQuitHandler.findCloseMenuItem(diffFrame);
        Container contentPane = diffFrame.getContentPane();
        if (fileCloseAction != null) {
            if (contentPane instanceof JComponent) {
                JComponent comp = (JComponent)contentPane;
                comp.getInputMap(1).put(ESC_KS, CLOSE_ACTION_MAP_KEY);
                comp.getActionMap().put(CLOSE_ACTION_MAP_KEY, new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        fileCloseAction.doClick();
                    }
                });
            }
            SwingUtilities.invokeLater(() -> PreviewQuitHandler.installKeyListenerForAuthorComps(fileCloseAction, contentPane));
        }
        diffFrame.addWindowListener(new DiffCloseListener(diffFrame));
    }

    private static void installKeyListenerForAuthorComps(AbstractButton fileCloseAction, Container contentPane) {
        ArrayList<Component> authorHosts = new ArrayList<Component>();
        PreviewQuitHandler.findAllAuthorPages(contentPane, authorHosts);
        for (Component component : authorHosts) {
            PreviewQuitHandler.removeInstalledCloseListeners(component);
            component.addKeyListener(new CloseKeyListener(fileCloseAction));
        }
    }

    private static void findAllAuthorPages(Component comp, List<Component> authorHosts) {
        if (comp instanceof HostComponentBase) {
            authorHosts.add(comp);
        } else if (comp instanceof Container) {
            int componentCount = ((Container)comp).getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                PreviewQuitHandler.findAllAuthorPages(((Container)comp).getComponent(i), authorHosts);
            }
        }
    }

    private static void removeInstalledCloseListeners(Component component) {
        int i;
        KeyListener[] keyListeners = component.getKeyListeners();
        ArrayList<KeyListener> toRemove = new ArrayList<KeyListener>();
        for (i = 0; i < keyListeners.length; ++i) {
            if (!(keyListeners[i] instanceof CloseKeyListener)) continue;
            toRemove.add(keyListeners[i]);
        }
        for (i = 0; i < toRemove.size(); ++i) {
            component.removeKeyListener((KeyListener)toRemove.get(i));
        }
    }

    private static AbstractButton findCloseMenuItem(JFrame diffFrame) {
        JMenuBar menuBar;
        AbstractButton closeMenuItem = null;
        StandalonePluginWorkspace pluginWS = (StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
        if (pluginWS != null && (menuBar = diffFrame.getJMenuBar()) != null) {
            int menuCount = menuBar.getMenuCount();
            block0: for (int i = 0; i < menuCount; ++i) {
                JMenu menu = menuBar.getMenu(i);
                int menuComponentCount = menu.getMenuComponentCount();
                for (int j = 0; j < menuComponentCount; ++j) {
                    boolean foundCloseMenuItem;
                    Component menuComponent = menu.getMenuComponent(j);
                    boolean bl = foundCloseMenuItem = menuComponent instanceof AbstractButton && FILE_CLOSE_ACTION_ID.equals(pluginWS.getActionsProvider().getActionID((Object)menuComponent));
                    if (!foundCloseMenuItem) continue;
                    closeMenuItem = (AbstractButton)menuComponent;
                    break block0;
                }
            }
        }
        return closeMenuItem;
    }

    private static class DiffCloseListener
    extends WindowAdapter {
        private JFrame diffFrame;

        public DiffCloseListener(JFrame diffFrame) {
            this.diffFrame = diffFrame;
        }

        @Override
        public void windowClosed(WindowEvent e) {
            PreviewURLHandler.setPreviewDetails(null, null);
            ArrayList<Component> authorHosts = new ArrayList<Component>();
            Container contentPane = this.diffFrame.getContentPane();
            if (contentPane instanceof JComponent) {
                JComponent comp = (JComponent)contentPane;
                comp.getActionMap().remove(PreviewQuitHandler.CLOSE_ACTION_MAP_KEY);
                comp.getInputMap(1).remove(ESC_KS);
                PreviewQuitHandler.findAllAuthorPages(contentPane, authorHosts);
                for (Component component : authorHosts) {
                    PreviewQuitHandler.removeInstalledCloseListeners(component);
                }
            }
            this.diffFrame.removeWindowListener(this);
        }
    }

    private static class CloseKeyListener
    extends KeyAdapter {
        private AbstractButton fileCloseAction;

        public CloseKeyListener(AbstractButton fileCloseAction) {
            this.fileCloseAction = fileCloseAction;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                this.fileCloseAction.doClick();
            }
        }
    }
}

