/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.customizer;

import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.auth.requests.AuthenticationInfoManager;
import com.oxygenxml.positron.core.util.PositronOptionsUtil;
import com.oxygenxml.positron.plugin.AIPositronInfo;
import com.oxygenxml.positron.plugin.MenusActionsManager;
import com.oxygenxml.positron.plugin.PositronAssistantPanel;
import com.oxygenxml.positron.plugin.chat.ChatPanel;
import com.oxygenxml.positron.plugin.chat.ChatUserInputInteractor;
import com.oxygenxml.positron.plugin.completion.AICompletionProvidersManager;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.customizer.DitaMapManagerAndProjectPopupMenuCustomizerUtil;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.exml.workspace.api.editor.page.ditamap.WSDITAMapEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.standalone.actions.MenusAndToolbarsContributorCustomizer;
import ro.sync.exml.workspace.api.standalone.ui.Menu;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class PositronPopupMenuCustomizer
extends MenusAndToolbarsContributorCustomizer {
    private static final String AUTHOR_REFACTORING_DMM = "Author/Refactoring";
    private StandalonePluginWorkspace pluginWorkspaceAccess;
    private AuthenticationInfoManager authenticationInfoManager;
    private CompletionActionsManager completionActionsManager;
    private AICompletionProvidersManager aiCompletionProviderManager;
    private PositronAssistantPanel positronAssistantPanel;
    private ChatUserInputInteractor chatInteractor;

    public PositronPopupMenuCustomizer(StandalonePluginWorkspace pluginWorkspaceAccess, AuthenticationInfoManager authenticationInfoManager, CompletionActionsManager completionActionsManager, AICompletionProvidersManager aiCompletionProviderManager, PositronAssistantPanel positronAssistantPanel, ChatPanel chatInteractor) {
        this.pluginWorkspaceAccess = pluginWorkspaceAccess;
        this.authenticationInfoManager = authenticationInfoManager;
        this.completionActionsManager = completionActionsManager;
        this.aiCompletionProviderManager = aiCompletionProviderManager;
        this.positronAssistantPanel = positronAssistantPanel;
        this.chatInteractor = chatInteractor;
    }

    public void customizeAuthorPopUpMenu(JPopupMenu popUp, AuthorAccess authorAccess) {
        if (PositronOptionsUtil.isPositronEnabled()) {
            this.addAiAssistantMenu(this.positronAssistantPanel, popUp);
        }
    }

    public void customizeTextPopUpMenu(JPopupMenu popUp, WSTextEditorPage textPage) {
        if (PositronOptionsUtil.isPositronEnabled()) {
            this.addAiAssistantMenu(this.positronAssistantPanel, popUp);
        }
    }

    private void addAiAssistantMenu(PositronAssistantPanel positronAssistantPanel, JPopupMenu popUp) {
        popUp.addSeparator();
        JMenuItem menuItem = popUp.add((JMenuItem)PositronPopupMenuCustomizer.createAIAssistMenu(positronAssistantPanel.getCompletionActions(), AIPositronInfo.PRODUCT_NAME, this.aiCompletionProviderManager, this.completionActionsManager, this.chatInteractor));
        menuItem.setIcon(IconsLoader.loadIcon("/images/DockableFramePositron16.png"));
    }

    private static Menu createAIAssistMenu(Map<String, List<PositronAIActionBase>> categActions, String menuName, AICompletionProvidersManager aiCompletionProvidersManager, CompletionActionsManager completionActionsManager, ChatUserInputInteractor chatInteractor) {
        Menu aiMenu = OxygenUIComponentsFactory.createMenu((String)menuName);
        MenusActionsManager.populateAiMenu(aiMenu, categActions, aiCompletionProvidersManager, completionActionsManager, chatInteractor);
        return aiMenu;
    }

    public void customizeDITAMapPopUpMenu(JPopupMenu popUp, WSDITAMapEditorPage ditaMapEditorPage) {
        if (PositronOptionsUtil.isPositronEnabled()) {
            Supplier<List<URL>> dmmSelectedFilesSupplier = PositronPopupMenuCustomizer.getDMMSelectedFilesSupplier(ditaMapEditorPage);
            DitaMapManagerAndProjectPopupMenuCustomizerUtil.customizePopUpWithRefactoringAction(this.pluginWorkspaceAccess, this.authenticationInfoManager, this.completionActionsManager, this.aiCompletionProviderManager.getCurrentCompletionProvider(), popUp, AUTHOR_REFACTORING_DMM, dmmSelectedFilesSupplier);
            DitaMapManagerAndProjectPopupMenuCustomizerUtil.customizePopUpWithAiIgnoreAction(popUp, dmmSelectedFilesSupplier, null);
        }
    }

    private static Supplier<List<URL>> getDMMSelectedFilesSupplier(WSDITAMapEditorPage ditaMapEditorPage) {
        return () -> Arrays.stream(ditaMapEditorPage.getCurrentSelectedURLs(true, false)).collect(Collectors.toList());
    }
}

