/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.customizer;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.PositronOptionsUtil;
import com.oxygenxml.positron.plugin.PositronAssistantPanel;
import java.awt.Component;
import javax.swing.JMenuBar;
import ro.sync.exml.workspace.api.standalone.MenuBarCustomizer;
import ro.sync.exml.workspace.api.standalone.ui.Menu;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class PositronMenuBarCustomizer
implements MenuBarCustomizer {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private Menu aiMenu;
    private PositronAssistantPanel positronAssistantPanel;

    public PositronMenuBarCustomizer(Menu aiMenu) {
        this.aiMenu = aiMenu;
    }

    public void setPositronAssistantPanel(PositronAssistantPanel positronAssistantPanel) {
        this.positronAssistantPanel = positronAssistantPanel;
        this.addPositronActionsToMenuBar();
    }

    public void customizeMainMenu(JMenuBar mainMenu) {
        this.aiMenu = OxygenUIComponentsFactory.createMenu((String)TRANSLATOR.getTranslation("AI"));
        PositronMenuBarCustomizer.addAiAssistMenuToApplicationMenu(this.aiMenu, mainMenu);
        this.addPositronActionsToMenuBar();
    }

    private void addPositronActionsToMenuBar() {
        if (this.positronAssistantPanel != null && this.aiMenu != null) {
            this.positronAssistantPanel.setAiActionsMenuBar(this.aiMenu);
            if (PositronOptionsUtil.isPositronEnabled()) {
                this.positronAssistantPanel.getAssistantController().forceLoadAllAiActions();
            }
        }
    }

    private static void addAiAssistMenuToApplicationMenu(Menu aiAssistMenu, JMenuBar mainMenu) {
        int noOfMenuItems = mainMenu.getMenuCount();
        for (int i = 0; i < noOfMenuItems; ++i) {
            if (!TRANSLATOR.getTranslation("Tools").equals(mainMenu.getMenu(i).getText())) continue;
            mainMenu.add((Component)aiAssistMenu, i + 1);
        }
    }
}

