/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.credits;

import com.oxygenxml.positron.actions.dialog.internal.DialogType;
import com.oxygenxml.positron.actions.dialog.internal.MessageDialogBuilder;
import com.oxygenxml.positron.core.auth.requests.ServerUrlProvider;
import com.oxygenxml.positron.core.interactions.CreditsUsageNotifier;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.UserNotifierHelper;
import java.text.MessageFormat;
import java.util.Map;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class CreditsNotifierImpl
implements CreditsUsageNotifier {
    private final WSOptionsStorage optionsManager;
    private final ServerUrlProvider urlProvider;
    private static final Translator TRANSLATOR = Translator.getInstance();

    public CreditsNotifierImpl(WSOptionsStorage optionsManager, ServerUrlProvider urlProvider) {
        this.optionsManager = optionsManager;
        this.urlProvider = urlProvider;
    }

    public void checkCreditsAndNotifyIfNecessary(int usedCredits, int totalCredits) {
        int newStatus;
        String lastStatus = this.optionsManager.getOption("oxygen.positron.plugin.credits.usage.notify", String.valueOf(0));
        if (!lastStatus.equals(String.valueOf(newStatus = UserNotifierHelper.getCreditsUsageNotificationStatus((int)totalCredits, (int)usedCredits, (String)lastStatus)))) {
            this.optionsManager.setOption("oxygen.positron.plugin.credits.usage.notify", String.valueOf(newStatus));
            if (newStatus != 0) {
                this.showNotification(newStatus);
            }
        }
    }

    protected void showNotification(int newStatus) {
        new MessageDialogBuilder(TRANSLATOR.getTranslation("Positron_Credits_Info"), DialogType.INFO).setMessage(MessageFormat.format(TRANSLATOR.getTranslation("Credits_Usage_Info_Message"), String.valueOf(newStatus))).setLinks(Map.of(TRANSLATOR.getTranslation("Manage_subscription") + "...", this.urlProvider.getServerUrl() + "/subscriptions")).setCancelButtonVisible(false).buildAndShow();
    }
}

