/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.completion.text;

import com.oxygenxml.positron.core.interactions.BaseDocumentDetailsProvider;
import com.oxygenxml.positron.core.interactions.ContentInserter;
import com.oxygenxml.positron.core.interactions.ReadOnlyController;
import com.oxygenxml.positron.core.interactions.textpage.NodeOffset;
import com.oxygenxml.positron.core.interactions.textpage.TextPageHighlighter;
import com.oxygenxml.positron.core.interactions.textpage.TextXPathEffector;
import com.oxygenxml.positron.core.util.SelectionUtil;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.plugin.completion.text.TextDocumentControllerReflectionUtil;
import com.oxygenxml.positron.plugin.diff.PreviewUtil;
import com.oxygenxml.positron.utilities.json.InsertMode;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.editor.xmleditor.operations.context.RelativeInsertPosition;
import ro.sync.exml.workspace.api.editor.documenttype.DocumentTypeInformation;
import ro.sync.exml.workspace.api.editor.page.WSTextBasedEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.xml.TextDocumentController;
import ro.sync.exml.workspace.api.editor.page.text.xml.TextOperationException;
import ro.sync.exml.workspace.api.editor.page.text.xml.WSXMLTextEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.xml.XPathException;

public class ContentInserterForTextPage
extends BaseDocumentDetailsProvider
implements ContentInserter {
    private static final Logger logger = LoggerFactory.getLogger(ContentInserterForTextPage.class);
    private Document document;
    private JTextComponent textComponent;
    private String contentType;
    private ReadOnlyController readOnlyController;
    private DocumentTypeInformation dtInfo;
    private TextPageHighlighter highlighter;
    private URL editorLocation;
    private TextXPathEffector textXPathEffector;
    private TextDocumentController documentController;
    private WSTextEditorPage textEditorPage;

    public ContentInserterForTextPage(WSTextEditorPage textEditorPage, ReadOnlyController readOnlyController, TextXPathEffector textXPathEffector) {
        this.textEditorPage = textEditorPage;
        this.document = textEditorPage.getDocument();
        this.textComponent = (JTextComponent)textEditorPage.getTextComponent();
        this.dtInfo = textEditorPage.getParentEditor().getDocumentTypeInformation();
        this.contentType = textEditorPage.getParentEditor().getContentType();
        this.editorLocation = textEditorPage.getParentEditor().getEditorLocation();
        if (textEditorPage instanceof WSXMLTextEditorPage) {
            this.documentController = ((WSXMLTextEditorPage)textEditorPage).getDocumentController();
        }
        this.readOnlyController = readOnlyController;
        this.textXPathEffector = textXPathEffector;
        this.highlighter = new TextPageHighlighter(this.textComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] insert(int startOffset, int endOffset, String suggestion, List<InsertMode> insertModes, boolean asMarkup, boolean deleteSelection, boolean isCopilotInsertion) {
        int[] result = new int[]{-1, -1};
        if (suggestion != null) {
            this.textEditorPage.beginCompoundUndoableEdit();
            try {
                if (!suggestion.isEmpty()) {
                    if (deleteSelection) {
                        try {
                            this.clearSelection(startOffset, endOffset);
                        }
                        catch (BadLocationException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    if ((result = this.insertAsXML(suggestion, insertModes, asMarkup, startOffset))[0] == -1) {
                        result = this.insertAsText(startOffset, suggestion);
                    }
                }
                this.textComponent.requestFocus();
            }
            finally {
                this.textEditorPage.endCompoundUndoableEdit();
            }
        }
        return result;
    }

    private int[] insertAsXML(String suggestion, List<InsertMode> insertModes, boolean asMarkup, int insertOffset) {
        int[] toRet;
        block7: {
            toRet = new int[]{-1, -1};
            try {
                if (!asMarkup || this.documentController == null) break block7;
                if (insertModes != null && !insertModes.isEmpty()) {
                    this.setCaretPositionOnFirstElemWhenSelection();
                    for (InsertMode insertMode : insertModes) {
                        boolean isValidCondition;
                        boolean bl = isValidCondition = insertMode.getXPathCondition() == null;
                        if (!isValidCondition) {
                            Object[] result = this.textXPathEffector.evaluateXPath("boolean(" + insertMode.getXPathCondition() + ")");
                            boolean bl2 = isValidCondition = result.length > 0 && Boolean.parseBoolean(result[0].toString());
                        }
                        if (!isValidCondition || TextUtils.isNullOrBlank((String)insertMode.getTargetLocation())) continue;
                        Position startSel = null;
                        Position start = null;
                        Position end = null;
                        List nodeOffsets = this.textXPathEffector.findNodeOffsetsByXPath(insertMode.getTargetLocation());
                        if (!nodeOffsets.isEmpty()) {
                            NodeOffset nodeOffset = (NodeOffset)nodeOffsets.get(0);
                            startSel = this.document.createPosition(nodeOffset.getStart() - 1);
                            start = this.document.createPosition(nodeOffset.getStart());
                            end = this.document.createPosition(nodeOffset.getEnd());
                        }
                        this.documentController.insertXMLFragment(suggestion, insertMode.getTargetLocation(), this.getRelativeInsertLocation(insertMode));
                        if (start == null || end == null) break block7;
                        toRet = new int[]{startSel.getOffset(), end.getOffset()};
                        this.highlighter.addHighlight(startSel.getOffset(), start.getOffset());
                        if (insertMode.getAction() == "replace") {
                            this.document.remove(start.getOffset(), end.getOffset() - start.getOffset());
                        }
                        break block7;
                    }
                    break block7;
                }
                Position startPosition = this.document.createPosition(insertOffset - 1);
                Position endPosition = this.document.createPosition(insertOffset);
                this.documentController.insertXMLFragment(suggestion, insertOffset);
                this.highlighter.addHighlight(startPosition.getOffset(), endPosition.getOffset());
                toRet = new int[]{startPosition.getOffset(), endPosition.getOffset()};
            }
            catch (BadLocationException | TextOperationException | XPathException e) {
                logger.debug("Cannot insert fragment. Fallback to the document insert text method.", e);
            }
        }
        return toRet;
    }

    private void setCaretPositionOnFirstElemWhenSelection() throws BadLocationException, XPathException {
        int selectionEnd;
        int selectionStart = this.textComponent.getSelectionStart();
        if (selectionStart != (selectionEnd = this.textComponent.getSelectionEnd())) {
            int position = selectionEnd < selectionStart ? selectionEnd : selectionStart;
            this.textComponent.setCaretPosition(position);
            List nodeOffsets = this.textXPathEffector.findNodeOffsetsByXPath("descendant-or-self::*");
            for (NodeOffset nodeOffset : nodeOffsets) {
                if (position > nodeOffset.getStart()) continue;
                this.textComponent.setCaretPosition(nodeOffset.getStart() + 1);
                break;
            }
        }
    }

    private RelativeInsertPosition getRelativeInsertLocation(InsertMode insertMode) {
        RelativeInsertPosition relativeInsertLocation = RelativeInsertPosition.INSERT_LOCATION_AS_FIRST_CHILD;
        switch (insertMode.getAction()) {
            case "insert-after": {
                relativeInsertLocation = RelativeInsertPosition.INSERT_LOCATION_AFTER;
                break;
            }
            case "insert-before": {
                relativeInsertLocation = RelativeInsertPosition.INSERT_LOCATION_BEFORE;
                break;
            }
            case "replace": {
                relativeInsertLocation = RelativeInsertPosition.INSERT_LOCATION_AFTER;
                break;
            }
            default: {
                logger.error("Action not implemented for text page: {} ", (Object)insertMode.getAction());
            }
        }
        return relativeInsertLocation;
    }

    private int[] insertAsText(int startOffset, String toInsert) {
        logger.debug("Insert as text {}", (Object)toInsert);
        int[] result = new int[]{-1, -1};
        if (toInsert != null && !toInsert.isEmpty()) {
            try {
                this.document.insertString(startOffset, toInsert, null);
                int endOffset = startOffset + toInsert.length();
                Position startPosition = this.document.createPosition(startOffset);
                Position endPosition = this.document.createPosition(endOffset);
                TextDocumentControllerReflectionUtil.indentSection(this.documentController, startOffset, endOffset);
                this.textComponent.setCaretPosition(endPosition.getOffset());
                this.highlighter.addHighlight(startPosition.getOffset(), endPosition.getOffset());
                result = new int[]{startOffset, endOffset};
            }
            catch (BadLocationException | TextOperationException e) {
                logger.error(e.getMessage(), e);
            }
        }
        logger.debug("Inserted!");
        return result;
    }

    private void clearSelection(int startOffset, int endOffset) throws BadLocationException {
        if (startOffset != endOffset) {
            if (endOffset < startOffset) {
                int tmp = endOffset;
                endOffset = startOffset;
                startOffset = tmp;
            }
            this.document.remove(startOffset, endOffset - startOffset);
        }
    }

    public int[] replaceSelectionWithSuggestion(String suggestion, boolean asMarkup, int startOffset, int endOffset, boolean isCopilotReplace) {
        return this.insert(startOffset, endOffset, suggestion, null, true, true, isCopilotReplace);
    }

    public Optional<String> getContentType() {
        return Optional.ofNullable(this.contentType);
    }

    public ReadOnlyController getReadOnlyController() {
        return this.readOnlyController;
    }

    public Optional<String> getDocumentTypeName() {
        Optional<String> toRet = Optional.empty();
        if (this.dtInfo != null) {
            toRet = Optional.ofNullable(this.dtInfo.getName());
        }
        return toRet;
    }

    public void cleanUp() {
        this.highlighter.cleanUp();
    }

    public Position createPosition(int offset) throws BadLocationException {
        return this.document.createPosition(offset);
    }

    public String getEntireDocumentContent() {
        try {
            return this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public boolean previewInsert(int startOffset, int endOffset, String suggestion, List<InsertMode> insertModes, boolean asMarkup, boolean deleteSelection) {
        return PreviewUtil.previewInsert((WSTextBasedEditorPage)this.textEditorPage, startOffset, endOffset, suggestion, insertModes, asMarkup, deleteSelection);
    }

    public boolean previewReplaceSelectionWithSuggestion(String suggestion, boolean interpretingCompletionAsMarkup, int startOffset, int endOffset) {
        return PreviewUtil.previewReplaceSelectionWithSuggestion((WSTextBasedEditorPage)this.textEditorPage, suggestion, interpretingCompletionAsMarkup, startOffset, endOffset);
    }

    public String getEditorLocation() {
        return this.editorLocation != null ? this.editorLocation.toString() : null;
    }

    public int getSelectionStart() {
        return this.textComponent.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.textComponent.getSelectionEnd();
    }

    public int getRootEnd() {
        return this.findRoot().getEnd();
    }

    public int getRootStart() {
        return this.findRoot().getStart();
    }

    private NodeOffset findRoot() {
        block4: {
            if (this.textXPathEffector != null) {
                try {
                    List findNodeOffsetsByXPath = this.textXPathEffector.findNodeOffsetsByXPath("/*");
                    if (findNodeOffsetsByXPath.size() == 1) {
                        return (NodeOffset)findNodeOffsetsByXPath.get(0);
                    }
                }
                catch (BadLocationException | XPathException e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)e, e);
                }
            }
        }
        return new NodeOffset(0, this.textComponent.getDocument().getLength());
    }

    public Reader createDocumentReader() {
        return new StringReader(this.getEntireDocumentContent());
    }

    public String getCaretSelectionInfo() {
        return SelectionUtil.getCaretSelectioInfo((WSTextBasedEditorPage)this.textEditorPage);
    }
}

