/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.completion;

import com.oxygenxml.positron.api.connector.AIConnector;
import com.oxygenxml.positron.api.connector.param.ConnectorParamBase;
import com.oxygenxml.positron.api.connector.param.ConnectorParamType;
import com.oxygenxml.positron.connector.AIConnectorConfigsManager;
import com.oxygenxml.positron.connector.AIConnectorConfiguration;
import com.oxygenxml.positron.connector.ConnectorConfigurationsPO;
import com.oxygenxml.positron.connector.SystemEnvUtil;
import com.oxygenxml.positron.core.AICompletionDetailsProvider;
import com.oxygenxml.positron.core.AICompletionProviderResolver;
import com.oxygenxml.positron.core.AIConnectorConfigurationProvider;
import com.oxygenxml.positron.core.ExternalAICompletionDetailsProvider;
import com.oxygenxml.positron.core.PositronAICompletionDetailsProvider;
import com.oxygenxml.positron.core.auth.requests.AuthenticationInfoManager;
import com.oxygenxml.positron.core.auth.requests.BearerTokenProvider;
import com.oxygenxml.positron.core.auth.requests.ServerUrlProvider;
import com.oxygenxml.positron.core.engines.EnginesManagerProvider;
import com.oxygenxml.positron.core.engines.IEnginesManager;
import com.oxygenxml.positron.core.filter.SensitiveContentFilter;
import com.oxygenxml.positron.core.interactions.CreditsUsageNotifier;
import com.oxygenxml.positron.core.responses.ResponseFormatsRepository;
import com.oxygenxml.positron.core.service.config.UserAgentInfo;
import com.oxygenxml.positron.core.tools.ToolsExecutionHandler;
import com.oxygenxml.positron.core.util.PositronOptionsUtil;
import com.oxygenxml.positron.plugin.PositronPlugin;
import com.oxygenxml.positron.plugin.completion.AIConfigurationChangeListener;
import com.oxygenxml.positron.plugin.util.AiPositronServiceAccess;
import com.oxygenxml.positron.plugin.util.DirectConnectionConfigurationHelper;
import com.oxygenxml.positron.plugin.util.SecurityHelper;
import com.oxygenxml.positron.utilities.ModelIdentifierUtil;
import com.oxygenxml.positron.utilities.functions.IFunctionSignaturesRepository;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.plugin.PluginDescriptor;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.ExternalPersistentObject;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyDetailsProvider;

public class AICompletionProvidersManager
implements AICompletionProviderResolver,
AIConnectorConfigurationProvider {
    private static final Logger log = LoggerFactory.getLogger(AICompletionProvidersManager.class);
    static final String VERTEX_PROJECT_ID_PARAM = "project_id_param";
    static final String CUSTOM_AI_SERVICE_CONNECTOR_ID = "custom-ai-service";
    static final String POSITRON_CONNECTOR_AUTH_CLIENT_SECRET_ENV = "POSITRON_CONNECTOR_AUTH_CLIENT_SECRET";
    static final String OLD_CONNECTOR_LAST_CUSTOM_MODEL = "oxygen.positron.plugin.direct.connector.last.custom.model";
    private PositronAICompletionDetailsProvider positronCompletionProvider;
    private ExternalAICompletionDetailsProvider externalAiCompletionDetailsProvider;
    private AIConnectorConfigsManager connectorsManager;
    private List<WSOptionListener> connectorParamsChangedListeners = new ArrayList<WSOptionListener>();
    private final List<AIConfigurationChangeListener> configurationChangeListeners = new ArrayList<AIConfigurationChangeListener>();
    private final SensitiveContentFilter sensitiveContentFilter;

    public AICompletionProvidersManager(AuthenticationInfoManager authenticationInfoManager, ProxyDetailsProvider proxyDetailsProvider, CreditsUsageNotifier creditsNotifier, ToolsExecutionHandler toolsExecutor) {
        this.connectorsManager = AIConnectorConfigsManager.getInstance();
        this.connectorsManager.setProxyProvider(proxyDetailsProvider);
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        PluginDescriptor pluginDescriptor = null;
        if (PositronPlugin.getInstance() != null) {
            pluginDescriptor = PositronPlugin.getInstance().getDescriptor();
        }
        UserAgentInfo userAgentDescriptor = new UserAgentInfo(pluginDescriptor != null ? pluginDescriptor.getName() : "Oxygen AI Positron", pluginDescriptor != null ? pluginDescriptor.getVersion() : "", PluginWorkspaceProvider.getPluginWorkspace().getApplicationName(), PluginWorkspaceProvider.getPluginWorkspace().getVersion());
        ResponseFormatsRepository responseFormatsRepository = new ResponseFormatsRepository();
        this.sensitiveContentFilter = new SensitiveContentFilter(() -> optionsStorage.getOption("oxygen.positron.plugin.sensitive.content.patterns", ""), () -> Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.enable.default.sensitive.patterns", Boolean.TRUE.toString())));
        this.positronCompletionProvider = new PositronAICompletionDetailsProvider((ServerUrlProvider)authenticationInfoManager, (BearerTokenProvider)authenticationInfoManager, proxyDetailsProvider, userAgentDescriptor, creditsNotifier);
        this.positronCompletionProvider.setToolsExecutionHandler(toolsExecutor);
        this.positronCompletionProvider.setFunctionSignaturesRepository((IFunctionSignaturesRepository)toolsExecutor.getToolsExecutor());
        this.positronCompletionProvider.setResponseFormatsRepository(responseFormatsRepository);
        this.positronCompletionProvider.setSensitiveContentFilter(this.sensitiveContentFilter);
        this.performBackwardCompatibilityMigration(optionsStorage);
        this.connectorsManager.loadConnectorConfigurations((ConnectorConfigurationsPO)optionsStorage.getPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)new ConnectorConfigurationsPO()));
        this.connectorConfigurationsListChanged();
        this.updateConnectorPasswordParamsListeners();
        this.fireConfigurationChangedEvent();
        this.externalAiCompletionDetailsProvider = new ExternalAICompletionDetailsProvider((AIConnectorConfigurationProvider)this);
        this.externalAiCompletionDetailsProvider.setToolsExecutionHandler(toolsExecutor);
        this.externalAiCompletionDetailsProvider.setFunctionSignaturesRepository((IFunctionSignaturesRepository)toolsExecutor.getToolsExecutor());
        this.externalAiCompletionDetailsProvider.setResponseFormatsRepository(responseFormatsRepository);
        this.externalAiCompletionDetailsProvider.setSensitiveContentFilter(this.sensitiveContentFilter);
        optionsStorage.addOptionListener(new WSOptionListener("oxygen.positron.plugin.connector.configurations"){

            public void optionValueChanged(WSOptionChangedEvent arg0) {
                AICompletionProvidersManager.this.connectorsManager.loadConnectorConfigurations((ConnectorConfigurationsPO)arg0.getNewValueObject());
                AICompletionProvidersManager.this.connectorConfigurationsListChanged();
                AICompletionProvidersManager.this.updateConnectorPasswordParamsListeners();
                AICompletionProvidersManager.this.fireConfigurationChangedEvent();
            }
        });
    }

    private void connectorConfigurationsListChanged() {
        this.connectorsManager.getConfigurations().forEach(connectorConfig -> this.updateConectorConfiguration((AIConnectorConfiguration)connectorConfig));
    }

    private void updateConectorConfiguration(AIConnectorConfiguration connectorConfig) {
        Map<String, Object> resolvedParams = this.getResolvedParametersForConnector(connectorConfig);
        connectorConfig.updateResolvedParameters(resolvedParams);
    }

    private void updateConnectorPasswordParamsListeners() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        for (WSOptionListener listener : this.connectorParamsChangedListeners) {
            optionsStorage.removeOptionListener(listener);
        }
        this.connectorsManager.getConfigurations().forEach(connectorConfig -> {
            AIConnector connector = connectorConfig.getConnector();
            connector.getParametersList().stream().filter(param -> ConnectorParamType.PASSWORD_TEXT_FIELD == param.getType()).forEach(param -> {
                String paramOptionId = DirectConnectionConfigurationHelper.computeOptionIdentifier(connectorConfig, param);
                WSOptionListener newListener = new WSOptionListener(paramOptionId, (AIConnectorConfiguration)connectorConfig){
                    final /* synthetic */ AIConnectorConfiguration val$connectorConfig;
                    {
                        this.val$connectorConfig = aIConnectorConfiguration;
                        super(arg0);
                    }

                    public void optionValueChanged(WSOptionChangedEvent event) {
                        AICompletionProvidersManager.this.updateConectorConfiguration(this.val$connectorConfig);
                        AICompletionProvidersManager.this.fireConfigurationChangedEvent();
                    }
                };
                optionsStorage.addOptionListener(newListener);
                this.connectorParamsChangedListeners.add(newListener);
            });
        });
    }

    public void addConfigurationChangeListener(AIConfigurationChangeListener listener) {
        if (listener != null) {
            this.configurationChangeListeners.add(listener);
        }
    }

    public void removeConfigurationChangeListener(AIConfigurationChangeListener listener) {
        this.configurationChangeListeners.remove(listener);
    }

    private void fireConfigurationChangedEvent() {
        for (AIConfigurationChangeListener listener : this.configurationChangeListeners) {
            try {
                listener.onConfigurationChanged();
            }
            catch (Throwable throwable) {}
        }
    }

    public AICompletionDetailsProvider getCompletionProviderForModel(AIActionDetails action, String imposedModel) {
        boolean isPositronServiceAvailable;
        Object toRet = this.getCurrentCompletionProvider();
        String model = null;
        if (imposedModel != null) {
            model = imposedModel;
        } else if (action != null && action.getParameters() != null && action.getParameters().getEngine() != null && action.getParameters().getEngine().getId() != null) {
            model = action.getParameters().getEngine().getId();
        }
        boolean bl = isPositronServiceAvailable = AiPositronServiceAccess.getInstance().hasAccessToAiPositronService() && AiPositronServiceAccess.getInstance().isAiPositronServiceConnectionEnabledFromAiServicePreferences();
        if (!isPositronServiceAvailable) {
            toRet = this.externalAiCompletionDetailsProvider;
        } else if (model != null) {
            String[] modelIdentifierParts = ModelIdentifierUtil.splitModelIdentifier((String)model);
            if (modelIdentifierParts[0] != null) {
                toRet = "aips".equals(modelIdentifierParts[0]) ? this.positronCompletionProvider : this.externalAiCompletionDetailsProvider;
            } else {
                String modelId = modelIdentifierParts[1];
                List<String> availableModelIdentifiers = this.getAllAvailableConfigurationForModel(modelId);
                Optional<String> availableExternalModelIdentifier = availableModelIdentifiers.stream().filter(currentIdentifier -> !currentIdentifier.equals("aips")).findFirst();
                if (availableExternalModelIdentifier.isPresent()) {
                    toRet = this.externalAiCompletionDetailsProvider;
                } else {
                    Optional<String> positronServiceModelIdentifier = availableModelIdentifiers.stream().filter(currentIdentifier -> currentIdentifier.equals("aips")).findFirst();
                    if (positronServiceModelIdentifier.isPresent()) {
                        toRet = this.positronCompletionProvider;
                    }
                }
            }
        }
        return toRet;
    }

    private List<String> getAllAvailableConfigurationForModel(String modelIdPart) {
        IEnginesManager enginesManager = EnginesManagerProvider.getInstance().getEnginesManager();
        Map availableEngines = enginesManager.getAvailableEngines();
        ArrayList<String> availableConfigurationIds = new ArrayList<String>();
        availableEngines.values().stream().forEach(modelDescriptors -> modelDescriptors.forEach(modelDescriptor -> {
            String[] splitModelIdentifier = ModelIdentifierUtil.splitModelIdentifier((String)modelDescriptor.getId());
            if (splitModelIdentifier[1] != null && splitModelIdentifier[1].equals(modelIdPart)) {
                availableConfigurationIds.add(splitModelIdentifier[0]);
            }
        }));
        return availableConfigurationIds;
    }

    public AICompletionDetailsProvider getCurrentCompletionProvider() {
        return DirectConnectionConfigurationHelper.isDirectConnection() ? this.externalAiCompletionDetailsProvider : this.positronCompletionProvider;
    }

    private Map<String, Object> getResolvedParametersForConnector(AIConnectorConfiguration connectorConfig) {
        HashMap<String, Object> resolvedParams = new HashMap<String, Object>();
        connectorConfig.getConnector().getParametersList().forEach(param -> resolvedParams.put(param.getId(), DirectConnectionConfigurationHelper.getValueForParam(connectorConfig, param, false, true)));
        return resolvedParams;
    }

    private void performBackwardCompatibilityMigration(WSOptionsStorage optionsStorage) {
        ConnectorConfigurationsPO connectorConfigurations = (ConnectorConfigurationsPO)optionsStorage.getPersistentObjectOption("oxygen.positron.plugin.connector.configurations", null);
        if (connectorConfigurations != null) {
            return;
        }
        connectorConfigurations = new ConnectorConfigurationsPO();
        connectorConfigurations.setCurrentConfigurationId(optionsStorage.getOption("oxygen.positron.plugin.direct.connector", null));
        List connectorTypes = this.connectorsManager.getConnectorTypes();
        boolean hasOldStyleConfigurations = false;
        for (AIConnector connectorType : connectorTypes) {
            Set<String> oldStyleConfiguredParams;
            String connectorId = connectorType.getConnectorId();
            if (!this.isConfiguredConnector(connectorId, oldStyleConfiguredParams = this.getOldStyleConfiguredParametersForConnector(optionsStorage, connectorType))) continue;
            String configurationName = connectorType.getConnectorName();
            AIConnectorConfiguration aiConnectorConfiguration = new AIConnectorConfiguration(configurationName, connectorType);
            connectorConfigurations.addConfiguration(aiConnectorConfiguration, connectorId);
            this.migrateOldStyleParametersToNewStyle(optionsStorage, connectorType, aiConnectorConfiguration.getConfigurationId(), connectorConfigurations);
            hasOldStyleConfigurations = true;
        }
        if (hasOldStyleConfigurations) {
            optionsStorage.setPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)connectorConfigurations);
            optionsStorage.setOption("oxygen.positron.plugin.direct.connector", null);
        }
    }

    private Set<String> getOldStyleConfiguredParametersForConnector(WSOptionsStorage optionsStorage, AIConnector connectorType) {
        HashSet<String> configuredParams = new HashSet<String>();
        String connectorId = connectorType.getConnectorId();
        for (ConnectorParamBase param : connectorType.getParametersList()) {
            String paramId = param.getId();
            String oldOptionId = PositronOptionsUtil.computeOldOptionIdentifier((String)"oxygen.positron.plugin.direct.connector.param", (String)connectorId, (String)paramId);
            String optionValue = optionsStorage.getOption(oldOptionId, null);
            if (param.getType() == ConnectorParamType.PASSWORD_TEXT_FIELD && optionValue != null && !optionValue.trim().isEmpty()) {
                optionValue = SecurityHelper.getInstance().decryptText(optionValue);
            }
            if (optionValue == null || optionValue.trim().isEmpty()) continue;
            configuredParams.add(paramId);
        }
        return configuredParams;
    }

    private boolean isConfiguredConnector(String connectorId, Set<String> configuredParams) {
        boolean isConfigured;
        boolean bl = isConfigured = configuredParams.contains("ai_key_param") || configuredParams.contains("deployment_param") || configuredParams.contains(VERTEX_PROJECT_ID_PARAM);
        if (!isConfigured && connectorId.equals(CUSTOM_AI_SERVICE_CONNECTOR_ID)) {
            isConfigured = SystemEnvUtil.getenv((String)POSITRON_CONNECTOR_AUTH_CLIENT_SECRET_ENV) != null;
        }
        return isConfigured;
    }

    private void migrateOldStyleParametersToNewStyle(WSOptionsStorage optionsStorage, AIConnector connectorType, String configurationId, ConnectorConfigurationsPO connectorConfigurations) {
        String connectorId = connectorType.getConnectorId();
        for (ConnectorParamBase param : connectorType.getParametersList()) {
            String paramId = param.getId();
            String oldOptionId = PositronOptionsUtil.computeOldOptionIdentifier((String)"oxygen.positron.plugin.direct.connector.param", (String)connectorId, (String)paramId);
            String paramValue = optionsStorage.getOption(oldOptionId, null);
            if (paramValue != null) {
                if (param.getType() == ConnectorParamType.PASSWORD_TEXT_FIELD) {
                    String newOptionId = PositronOptionsUtil.computeOptionIdentifier((String)"oxygen.positron.plugin.direct.connector.param", (String)configurationId, (String)connectorId, (String)paramId);
                    optionsStorage.setOption(newOptionId, paramValue);
                } else {
                    connectorConfigurations.setConfigurationParameter(configurationId, paramId, paramValue);
                }
                optionsStorage.setOption(oldOptionId, null);
            }
            if (param.getType() != ConnectorParamType.MODEL_COMBO_BOX) continue;
            String customModelId = PositronOptionsUtil.computeOldOptionIdentifier((String)OLD_CONNECTOR_LAST_CUSTOM_MODEL, (String)connectorId, (String)param.getId());
            String customModel = optionsStorage.getOption(customModelId, null);
            if (customModel != null && !customModel.isBlank()) {
                connectorConfigurations.setConfigurationParameter(configurationId, "connector_last_custom_model", customModel);
            }
            optionsStorage.setOption(customModelId, null);
        }
    }

    public AIConnectorConfiguration getCurrentConfiguration() {
        return this.connectorsManager.getCurrentConfiguration();
    }

    public AIConnectorConfiguration getConfigurationById(String configurationId) {
        return this.connectorsManager.getConfigurationById(configurationId);
    }

    public AIConnectorConfiguration getFirstConfigurationWithModel(String modelId) {
        AIConnectorConfiguration toRet = null;
        List<String> availableConfigurationIds = this.getAllAvailableConfigurationForModel(modelId);
        for (String currentConfig : availableConfigurationIds) {
            if (!currentConfig.isBlank() && !"aips".equals(currentConfig) && (toRet = this.connectorsManager.getConfigurationById(currentConfig)) != null) break;
        }
        return toRet;
    }

    public SensitiveContentFilter getSensitiveContentFilter() {
        return this.sensitiveContentFilter;
    }
}

