/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.utils;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JComponent;

public class ScreenLocationUtil {
    private ScreenLocationUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static Point adjustPopupLocationToFitScreen(int xPosition, int yPosition, JComponent parent) {
        Point location = new Point(xPosition, yPosition);
        if (GraphicsEnvironment.isHeadless()) {
            return location;
        }
        GraphicsConfiguration gc = ScreenLocationUtil.getCurrentGraphicsConfiguration(location);
        if (gc == null) {
            gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle scrBounds = gc.getBounds();
        Dimension size = parent.getPreferredSize();
        long rightX = (long)location.x + (long)size.width;
        long bottomY = (long)location.y + (long)size.height;
        int scrWidth = scrBounds.width;
        int scrHeight = scrBounds.height;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Insets scrInsets = toolkit.getScreenInsets(gc);
        scrBounds.x += scrInsets.left;
        scrBounds.y += scrInsets.top;
        int scrRightX = scrBounds.x + (scrWidth -= scrInsets.left + scrInsets.right);
        int scrBottomY = scrBounds.y + (scrHeight -= scrInsets.top + scrInsets.bottom);
        if (rightX > (long)scrRightX) {
            location.x = scrRightX - size.width;
        }
        if (bottomY > (long)scrBottomY) {
            location.y = scrBottomY - size.height;
        }
        if (location.x < scrBounds.x) {
            location.x = scrBounds.x;
        }
        if (location.y < scrBounds.y) {
            location.y = scrBounds.y;
        }
        return location;
    }

    private static GraphicsConfiguration getCurrentGraphicsConfiguration(Point location) {
        GraphicsConfiguration gc = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        for (int i = 0; i < gd.length; ++i) {
            GraphicsConfiguration dgc;
            if (gd[i].getType() != 0 || !(dgc = gd[i].getDefaultConfiguration()).getBounds().contains(location)) continue;
            gc = dgc;
            break;
        }
        return gc;
    }
}

