/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.utils;

import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.plugin.chat.ChatModel;
import com.oxygenxml.positron.plugin.chat.GenericTranslationChatStartMessage;
import com.oxygenxml.positron.plugin.chat.history.MessageNode;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.ActionParam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public final class ChatCommonUtil {
    private ChatCommonUtil() {
    }

    public static Optional<GenericTranslationChatStartMessage> getGenericTranslationChatStartMessage(AIActionDetails actionDetails) {
        Optional<GenericTranslationChatStartMessage> startMsgDetails = Optional.empty();
        Optional<String> lang = ChatCommonUtil.getGenericTranslationLanguage(actionDetails);
        if (lang.isPresent()) {
            String shortDesc = "Translate to " + lang.get();
            String longDesc = "Translate the selected content to " + lang.get() + " while preserving its original DITA XML markup";
            startMsgDetails = Optional.of(new GenericTranslationChatStartMessage(shortDesc, longDesc));
        }
        return startMsgDetails;
    }

    private static Optional<String> getGenericTranslationLanguage(AIActionDetails genericTranslationActionDetails) {
        Optional<String> lang = Optional.empty();
        List expandParams = genericTranslationActionDetails.getExpandParams();
        Optional<ActionParam> langParam = expandParams.stream().filter(p -> p.getName().equals("translationLanguage")).findFirst();
        if (langParam.isPresent()) {
            String value = langParam.get().getValue();
            if (value != null && !value.isBlank()) {
                lang = Optional.of(value);
            } else {
                String storedValue = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption("oxygen.positron.plugin." + genericTranslationActionDetails.getId() + "###---####translationLanguage", "");
                if (!storedValue.isBlank()) {
                    lang = Optional.of(storedValue);
                }
            }
        }
        return lang;
    }

    public static void removeLastAssistantMessage(List<Integer> pathToNode, List<MessageNode> chatMessages, ChatModel chatModel) {
        MessageNode lastMessageNode;
        Message lastMessage;
        if (!chatMessages.isEmpty() && (lastMessage = (lastMessageNode = chatModel.getLastMessageNodeInPath(pathToNode)).getMessage()) != null && RoleType.ASSISTANT == lastMessage.getRole()) {
            chatMessages.remove(lastMessageNode);
        }
    }

    public static Map<String, String> createActionParamsForRegeneration(String regenerationModel, boolean isRegenerateResponse, Map<String, String> actionParameters) {
        if (isRegenerateResponse && regenerationModel != null) {
            actionParameters = new HashMap<String, String>(ChatCommonUtil.cloneActionParamsAndAddImposedEngine(actionParameters, regenerationModel));
        }
        return actionParameters;
    }

    private static Map<String, String> cloneActionParamsAndAddImposedEngine(Map<String, String> map, String regenerationModel) {
        HashMap<String, String> clone = new HashMap<String, String>();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                clone.put(entry.getKey(), entry.getValue());
            }
        }
        clone.put("imposed.engine.model", regenerationModel);
        return clone;
    }
}

