/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.quickfind;

import com.oxygenxml.positron.plugin.chat.attachments.AttachmentChipUtil;
import com.oxygenxml.positron.plugin.chat.quickfind.QuickSearchListItem;
import java.net.URL;
import java.util.Collection;
import java.util.Objects;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.URLUtil;

public class URLQuickSearchItem
implements QuickSearchListItem {
    private final URL url;
    private Collection<URL> attachments;

    public URLQuickSearchItem(URL url, Collection<URL> attachments) {
        this.url = url;
        this.attachments = attachments;
    }

    @Override
    public String getDisplayText() {
        return AttachmentChipUtil.extractFileName(this.url, this.attachments) + " - " + URLQuickSearchItem.showSomePath(this.url, 50);
    }

    @Override
    public String getSecondaryText() {
        return URLUtil.getDescription((URL)URLUtil.clearUserInfo((URL)this.url));
    }

    public URL getURL() {
        return this.url;
    }

    private static String showSomePath(URL resource, int chars) {
        String[] extractPathAndFileName = URLUtil.extractPathAndFileName((URL)resource);
        String input = URLUtil.getDescription((String)extractPathAndFileName[0]);
        if (input.startsWith("/") || input.startsWith("\\")) {
            input = input.substring(1, input.length());
        }
        if (input.endsWith("/") || input.endsWith("\\")) {
            input = input.substring(0, input.length() - 1);
        }
        return input.length() > chars ? "..." + input.substring(input.length() - chars) : input;
    }

    public int hashCode() {
        return Objects.hash(this.url.toExternalForm());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        URLQuickSearchItem other = (URLQuickSearchItem)obj;
        return Equaler.verifyEquals((Object)this.url, (Object)other.url);
    }
}

